/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.cmd.SaveAsCommand;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;

public class EditorSaveAsCommand
extends SaveAsCommand {
    public EditorSaveAsCommand() {
        super(12);
    }

    @Override
    protected int saveAsNewNode(Node doc) {
        URL oldURL = doc.getURL();
        String suffix = URLFileSystem.getSuffix((URL)oldURL);
        try {
            boolean ownerAddedOk;
            boolean oldDirty = doc.isDirty();
            if (oldDirty || doc.isNew()) {
                URL tmpURL = URLFileSystem.createTempFile((String)"jdev", (String)suffix, (URL)URLFileSystem.getParent((URL)this._newURL));
                if (tmpURL == null) {
                    throw new IOException();
                }
                doc.setURL(tmpURL);
                doc.markDirty(true);
                try {
                    doc.save();
                }
                catch (Exception e) {
                    doc.setURL(oldURL);
                    doc.markDirty(oldDirty);
                    throw e;
                }
                if (URLFileSystem.exists((URL)this._newURL) && !URLFileSystem.delete((URL)this._newURL) || !URLFileSystem.renameTo((URL)tmpURL, (URL)this._newURL)) {
                    doc.setURL(oldURL);
                    doc.markDirty(oldDirty);
                    String msg = IdeArb.format(249, oldURL.getPath());
                    JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), msg, IdeArb.getString(241), 0);
                    return 2;
                }
                doc.setURL(oldURL);
                doc.markDirty(oldDirty);
            } else {
                if (URLFileSystem.exists((URL)this._newURL) && !URLFileSystem.delete((URL)this._newURL)) {
                    String msg = IdeArb.format(249, oldURL.getPath());
                    JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), msg, IdeArb.getString(241), 0);
                    return 2;
                }
                URLFileSystem.copy((URL)oldURL, (URL)this._newURL);
            }
            Node node = NodeFactory.findOrCreate(this._nodeClass, this._newURL);
            node.open();
            if (this._elementOwner != null && (ownerAddedOk = this._elementOwner.add(node)) && this._elementOwner instanceof Subject) {
                UpdateMessage.fireChildAdded((Subject)((Object)this._elementOwner), node);
            }
            this.reloadEditors(node);
            if (!doc.isDirty() && !doc.isNew()) {
                this.closeNode(doc);
            }
            return 0;
        }
        catch (Exception e) {
            String msg = IdeArb.format(248, oldURL.getPath(), e.toString());
            JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), msg, IdeArb.getString(241), 0);
            return 2;
        }
    }

    @Override
    protected int convertToNewNode(Node doc) {
        return this.saveAsNewNode(doc);
    }

    @Override
    protected int convertToDupNode(Node doc) {
        return 2;
    }

    @Override
    protected int saveAsDupNode(Node doc) {
        URL oldURL = doc.getURL();
        try {
            this._duplicate.close();
            if (doc.isNew()) {
                doc.save();
            }
            URLFileSystem.copy((URL)oldURL, (URL)this._newURL);
            this._duplicate.open();
            if (this._elementOwner != null) {
                this._elementOwner.add(this._duplicate);
                if (this._elementOwner instanceof Subject) {
                    UpdateMessage.fireChildAdded((Subject)((Object)this._elementOwner), this._duplicate);
                }
            }
            this.reloadEditors(this._duplicate);
            return 0;
        }
        catch (Exception e) {
            String msg = IdeArb.format(248, oldURL.getPath(), e.toString());
            JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), msg, IdeArb.getString(241), 0);
            return 2;
        }
    }

    private int closeNode(Node doc) {
        CloseNodeCommand clsCmd = new CloseNodeCommand();
        clsCmd.setContext(this.getContext());
        return clsCmd.close(doc, false, false);
    }

    private void reloadEditors(Node doc) {
        Context newContext = new Context(this.getContext());
        newContext.setNode(doc);
        Element[] selection = new Element[]{doc};
        newContext.setSelection(selection);
        EditorManager.getEditorManager().replaceEditors(this.getContext(), newContext);
    }
}

