/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controls.StatusBar;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetProvider;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Subject;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.ModelArb;
import oracle.javatools.data.ChangeBuffer;
import oracle.javatools.data.StructureChangeListener;

public class AddContentCommand
extends Command {
    public static final int ADD_URL_TO_PROJECT_CMD_ID = Ide.findOrCreateCmdID("ContentSetSupport.ADD_URL_TO_PROJECT_CMD_ID");
    public static final int ADD_TO_PROJECT_CMD_ID = Ide.findOrCreateCmdID("ContentSetSupport.ADD_TO_PROJECT_CMD_ID");
    private String _explicitKey;
    private String _registeredKey;
    private static final HashMap _mapping = new HashMap(15);
    private static final String RESOURCES_KEY = "oracle.ide.model.ResourcePaths/resourcesContentSet";
    public static final int FAILED = 2;

    public AddContentCommand() {
        super(ADD_URL_TO_PROJECT_CMD_ID, 2);
    }

    public static void registerPreferredContentSet(Class nodeClass, String contentSetKey) {
        _mapping.put(nodeClass, contentSetKey);
    }

    public static void unRegisterPreferredContentSet(Class nodeClass, String contentSetKey) {
        if (_mapping.containsKey(nodeClass) && _mapping.get(nodeClass).equals(contentSetKey)) {
            _mapping.remove(nodeClass);
        }
    }

    public static void addToProject(Node node, Project project, String contentSetKey) {
        Context context = new Context();
        context.setProject(project);
        context.setNode(node);
        AddContentCommand.addToProject(context, contentSetKey);
    }

    public static void addToProject(Node[] nodes, Project project, String contentSetKey) {
        Context context = new Context();
        context.setProject(project);
        context.setSelection(nodes);
        AddContentCommand.addToProject(context, contentSetKey);
    }

    public static void addToProject(Context context, String contentSetKey) {
        AddContentCommand cmd = new AddContentCommand();
        cmd.setContext(context);
        try {
            cmd.doit(contentSetKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int doit(boolean includeSubFolders) throws Exception {
        return this.doit();
    }

    public int doit(String contentSetKey) throws Exception {
        return this.doit(contentSetKey, false);
    }

    public int doit(String contentSetKey, boolean includeSubFolders) throws Exception {
        if (this.lookupProvider(contentSetKey) == null) {
            throw new IllegalArgumentException("Unknown content set key: " + contentSetKey);
        }
        this._explicitKey = contentSetKey;
        return this.doit();
    }

    @Override
    public int doit() throws Exception {
        Context context = this.getContext();
        Project project = context.getProject();
        if (project != null) {
            StatusBar statusBar = Ide.getStatusBar();
            String feedback = "";
            Node[] nodes = this.getNodes(context);
            if (nodes.length == 1) {
                if (this._explicitKey == null) {
                    this._registeredKey = this.lookupPreferredKey(nodes[0]);
                }
                feedback = URLFileSystem.getPlatformPathName((URL)nodes[0].getURL());
            } else if (nodes.length > 1) {
                feedback = ModelArb.getString(68);
            }
            statusBar.setText(ModelArb.format(65, feedback, project.getShortLabel()));
            int result = this.addContent(nodes, project);
            if (0 == result) {
                statusBar.setText(ModelArb.format(66, feedback, project.getShortLabel()));
                return 0;
            }
            statusBar.setText("");
            return result;
        }
        return 2;
    }

    private Node[] getNodes(Context context) {
        Node node;
        Project project = context.getProject();
        Element[] selection = context.getSelection();
        if ((selection.length == 0 || selection.length > 0 && !(selection[0] instanceof Subject)) && (node = context.getNode()) != null) {
            selection = new Element[]{node};
        }
        if (selection.length == 0) {
            return new Node[0];
        }
        ArrayList<Element> nodes = new ArrayList<Element>(selection.length);
        ContentSet cs = this._explicitKey != null && !RESOURCES_KEY.equals(this._explicitKey) ? ContentSet.getInstance(project, this._explicitKey) : ProjectContent.getInstance(project).getAllContents();
        for (int i = 0; i < selection.length; ++i) {
            URL url;
            Element element = selection[i];
            if (!(element instanceof Node) || cs.canHaveMember(url = ((Node)element).getURL())) continue;
            nodes.add(element);
        }
        return nodes.toArray(new Node[nodes.size()]);
    }

    private int addContent(Node[] nodes, final Project project) {
        Project projectCopy = (Project)project.copyTo(null);
        final ChangeBuffer sharedChangeBuffer = new ChangeBuffer();
        projectCopy.getSharedPropertiesOnly().addStructureChangeListener((StructureChangeListener)sharedChangeBuffer);
        final ChangeBuffer userChangeBuffer = new ChangeBuffer();
        projectCopy.getUserPropertiesOnly().addStructureChangeListener((StructureChangeListener)userChangeBuffer);
        ProjectContent projectContent = ProjectContent.getInstance(projectCopy);
        int status = this.addContentImpl(nodes, projectContent);
        projectCopy.getSharedPropertiesOnly().removeStructureChangeListener((StructureChangeListener)sharedChangeBuffer);
        projectCopy.getUserPropertiesOnly().removeStructureChangeListener((StructureChangeListener)userChangeBuffer);
        if (status == 0) {
            project.applyBatchChanges(new Runnable(){

                @Override
                public void run() {
                    project.getSharedPropertiesOnly().applyChanges(sharedChangeBuffer.getChanges());
                    project.getUserPropertiesOnly().applyChanges(userChangeBuffer.getChanges());
                }
            });
        }
        return status;
    }

    private int addContentImpl(Node[] nodes, ProjectContent projectContent) {
        if (nodes.length == 0) {
            return 0;
        }
        if (this._explicitKey != null) {
            return projectContent.add(nodes, this._explicitKey) ? 0 : 2;
        }
        ContentSetSelector optionPanel = new ContentSetSelector(nodes, projectContent);
        HelpSystem.getHelpSystem().registerTopic(optionPanel, "f1_idedaddtoproject_html");
        if (OnePageWizardDialogFactory.runDialog((Component)((Object)Ide.getMainWindow()), (Component)optionPanel, optionPanel.getFocusComponent(), ModelArb.getString(63))) {
            String key = optionPanel.getKey();
            return projectContent.add(nodes, key) ? 0 : 2;
        }
        return 1;
    }

    private ContentSetProvider lookupProvider(String key) {
        ContentSetProvider[] providers = ProjectContent.getContentSetProviders();
        for (int i = 0; i < providers.length; ++i) {
            if (!providers[i].getKey().equals(key)) continue;
            return providers[i];
        }
        return null;
    }

    private String lookupPreferredKey(Node node) {
        Class<?> nodeClass = node.getClass();
        if (_mapping.containsKey(nodeClass)) {
            return (String)_mapping.get(nodeClass);
        }
        return null;
    }

    private class ContentSetSelector
    extends JPanel {
        String csKey;
        JRadioButton focus;

        ContentSetSelector(Node[] nodes, ProjectContent projectContent) {
            block2: {
                Enumeration<AbstractButton> enumeration;
                super(new GridBagLayout());
                this.csKey = "";
                JLabel helpLabel1 = new JLabel(ModelArb.getString(67));
                String help2Text = nodes.length == 1 ? URLFileSystem.getPlatformPathName((URL)nodes[0].getURL()) : ModelArb.getString(68);
                JLabel helpLabel2 = new JLabel(help2Text + ".");
                JLabel prompt = new JLabel(ModelArb.getString(69));
                GridBagConstraints g = new GridBagConstraints();
                g.gridx = 0;
                g.gridy = -1;
                g.anchor = 18;
                g.weightx = 1.0;
                g.fill = 2;
                g.insets.bottom = 2;
                this.add((Component)helpLabel1, g);
                g.insets.bottom = 10;
                this.add((Component)helpLabel2, g);
                this.add((Component)prompt, g);
                g.insets.left = 8;
                g.insets.bottom = 3;
                g.fill = 0;
                final ContentSetProvider[] providers = ProjectContent.getContentSetProviders();
                ButtonGroup group = new ButtonGroup();
                for (int i = 0; i < providers.length; ++i) {
                    if (!this.canAdd(providers[i], nodes, projectContent)) continue;
                    final int which = i;
                    JRadioButton rb = new JRadioButton(providers[i].getNavigable().getShortLabel());
                    rb.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            if (e.getStateChange() == 1) {
                                ContentSetSelector.this.csKey = providers[which].getKey();
                            }
                        }
                    });
                    if (providers[i].getKey().equals(AddContentCommand.this._registeredKey)) {
                        rb.setSelected(true);
                        this.focus = rb;
                    }
                    group.add(rb);
                    this.add((Component)rb, g);
                }
                if (group.getSelection() != null || !(enumeration = group.getElements()).hasMoreElements()) break block2;
                JRadioButton rb = (JRadioButton)enumeration.nextElement();
                rb.setSelected(true);
            }
        }

        String getKey() {
            return this.csKey;
        }

        Component getFocusComponent() {
            return this.focus;
        }

        boolean canAdd(ContentSetProvider provider, Node[] nodes, ProjectContent projectContent) {
            for (int i = 0; i < nodes.length; ++i) {
                if (provider.getContentSetHelper().canAddContent(nodes[i].getURL(), projectContent)) continue;
                return false;
            }
            return true;
        }
    }
}

