/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.util.ArrayList;
import oracle.ide.util.IdeUtil;

public final class IdeArgs {
    private static final char OPTION_PREFIX = '-';
    private static final char VALUE_SEPARATOR = ':';
    private final String[] _args;
    private boolean _bCreateUI;
    private String _sPlatformFileName;
    private boolean _migrate;
    private String role;

    public IdeArgs() {
        this(new String[0]);
    }

    public IdeArgs(String[] args) {
        this._args = (String[])args.clone();
        this.parseArgs(args);
    }

    private void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String sVal;
            String sArg = args[i];
            if (sArg.length() == 0 || sArg.charAt(0) != '-') continue;
            String sArgNoDash = sArg.substring(1);
            String sOpt = IdeUtil.getSubString(sArgNoDash, ':', true);
            if (sOpt != null) {
                sVal = IdeUtil.getSubString(sArgNoDash, ':', false);
            } else {
                sOpt = sArg;
                sVal = null;
            }
            if (sOpt.compareTo("pf") == 0 || sOpt.compareTo("platformfile") == 0) {
                this._sPlatformFileName = IdeArgs.getValue(sVal);
                continue;
            }
            if (sOpt.compareTo("migrate") == 0) {
                this._migrate = true;
                continue;
            }
            if (sOpt.compareTo("role") != 0) continue;
            this.setRole(sVal);
        }
    }

    private static String getValue(String sValue) {
        int n;
        if (sValue != null && (n = sValue.length()) > 1 && (sValue.startsWith("\"") && sValue.endsWith("\"") || sValue.startsWith("'") && sValue.endsWith("'"))) {
            sValue = sValue.substring(1, n - 1);
        }
        return sValue;
    }

    public final String[] getArgs() {
        ArrayList<String> rgs = new ArrayList<String>();
        if (!this._bCreateUI) {
            rgs.add("-headless");
        }
        for (String a : this._args) {
            rgs.add(a);
        }
        return rgs.toArray(new String[rgs.size()]);
    }

    public boolean hasArg(String argName) {
        if (this._args != null && argName != null) {
            for (int i = 0; i < this._args.length; ++i) {
                if (!argName.equals(this._args[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getCreateUI() {
        return this._bCreateUI;
    }

    public void setCreateUI(boolean bCreateUI) {
        this._bCreateUI = bCreateUI;
    }

    public final void setRole(String role) {
        if (role != null && "".equals(role = role.trim())) {
            role = null;
        }
        this.role = role;
    }

    public String getPlatformFileName() {
        return this._sPlatformFileName;
    }

    public boolean isMigrate() {
        return this._migrate;
    }

    public String getRole() {
        return this.role;
    }
}

