/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.JARExtensionSource;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.Version;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.ide.Ide;
import oracle.ide.IdeHook;
import oracle.ide.extension.Role;
import oracle.ide.extension.RoleManager;

public abstract class ExtensionRegistry
extends javax.ide.extension.ExtensionRegistry {
    public static final String EDT_HOT_CLASSES = "edt.hot.classes";
    public static final String EDT_HOT_MANIFEST = "edt.hot.manifest";
    public static final String EDT_HOT_DEPLOY_DIR = "edt.hot.deploydir";
    public static final String EDT_EXTENSION_ID = "edt.extension.id";
    protected static final String EXTENSIONS_DIR = "extensions";
    public static final String DEFAULT_PROCESSOR_PLUGINS_DIR = "ide/macros";
    public static final String PRODUCT_PROCESSOR_PLUGINS_DIR = "macros";
    private static final Logger _extensionLogger = Logger.getLogger(ExtensionRegistry.class.getName());
    protected Logger _manifestLogger = null;
    private final Map _ideHooksByElementName = new HashMap();
    private final RoleManager _roleManager = this.createRoleManager();

    public static boolean isCustomizationContext(ElementContext context) {
        boolean override = Boolean.valueOf((String)context.getScopeData().get("unittest.customization.context"));
        if (override) {
            return true;
        }
        Extension extension = context.getExtension();
        if (extension == null) {
            return false;
        }
        return ExtensionRegistry.isRole(extension) || ExtensionRegistry.isProduct(extension);
    }

    private static boolean isRole(Extension extension) {
        String extensionId = extension.getID();
        if (extensionId == null) {
            return false;
        }
        return extensionId.startsWith("_role");
    }

    private static boolean isProduct(Extension extension) {
        String productId = System.getProperty("ide.product");
        if (productId == null) {
            return false;
        }
        return productId.equals(extension.getID());
    }

    public abstract Collection<File> getExtensionSearchPath();

    public static final ExtensionRegistry getExtensionRegistry() {
        return (ExtensionRegistry)javax.ide.extension.ExtensionRegistry.getExtensionRegistry();
    }

    public static final ExtensionRegistry getOracleRegistry() {
        return (ExtensionRegistry)javax.ide.extension.ExtensionRegistry.getExtensionRegistry();
    }

    public RoleManager getRoleManager() {
        return this._roleManager;
    }

    protected RoleManager createRoleManager() {
        return new RoleManager(){

            @Override
            public Role getActiveRole() {
                return NO_ROLE;
            }
        };
    }

    public abstract String getNotLoadedReason(String var1);

    public final Logger getLogger() {
        return _extensionLogger;
    }

    public final Logger getManifestLogger() {
        if (this._manifestLogger == null) {
            this.createExtensionLogger();
        }
        return this._manifestLogger;
    }

    public abstract boolean isLoaded(String var1);

    public abstract boolean isUserExtension(String var1);

    public abstract boolean isNewlyInstalled(String var1);

    public abstract URL getSystemDirectory(String var1);

    public abstract URL getSystemDirectory(String var1, Version var2);

    public final URI getInstallRoot(Extension extension) {
        File installDir = this.getInstallDirectory(extension);
        if (installDir == null) {
            return null;
        }
        return URIFactory.newDirURI((File)installDir);
    }

    public final String getInstallDirectory(String extensionId) {
        return this.getInstallDirectory(extensionId, null);
    }

    public final String getInstallDirectory(String extensionId, Version version) {
        Extension extension = this.findExtensionEvenIfNotLoaded(extensionId);
        if (extension == null) {
            throw new IllegalArgumentException("Unable to find extension " + extensionId);
        }
        File installDir = this.getInstallDirectory(extension);
        if (installDir != null) {
            return installDir.getAbsolutePath();
        }
        return "";
    }

    public final File getInstallDirectory(Extension extension) {
        File extensionDir;
        File extensionJAR = this.getExtensionJAR(extension);
        if (extensionJAR == null) {
            String hotId = System.getProperty(EDT_EXTENSION_ID);
            if (!extension.getID().equals(hotId)) {
                return null;
            }
            String hotDir = System.getProperty(EDT_HOT_DEPLOY_DIR);
            extensionDir = new File(Ide.getOracleHomeDirectory() + "/" + hotDir);
        } else {
            extensionDir = extensionJAR.getParentFile();
        }
        StringBuffer directory = new StringBuffer(extensionDir.getAbsolutePath() + "/");
        directory.append(extension.getID());
        directory.append('.');
        String versionNum = extension.getVersion().toCanonicalString();
        while (true) {
            File path;
            if ((path = new File(directory.toString() + versionNum)).isDirectory()) {
                return path;
            }
            int lastDot = versionNum.lastIndexOf(46);
            if (lastDot < 1) break;
            versionNum = versionNum.substring(0, lastDot);
        }
        File noVersionDir = new File(directory.substring(0, directory.length() - 1));
        if (noVersionDir.isDirectory()) {
            return noVersionDir;
        }
        return new File(directory.toString() + versionNum);
    }

    protected String getExtensionJAR(String extensionId, Version version, boolean userDirOk) {
        return this.getExtensionJAR(extensionId, version);
    }

    public String getExtensionJAR(String extensionId, Version version) {
        File jarFile;
        Extension extension = this.findExtensionEvenIfNotLoaded(extensionId);
        if (extension != null && (jarFile = this.getExtensionJAR(extension)) != null) {
            return jarFile.getAbsolutePath();
        }
        return null;
    }

    public final File getExtensionJAR(Extension extension) {
        DefaultExtension defaultExtension;
        if (extension == null) {
            throw new NullPointerException("extension is null");
        }
        if (extension instanceof DefaultExtension && (defaultExtension = (DefaultExtension)extension).getSource() instanceof JARExtensionSource) {
            URI jarUri = ((JARExtensionSource)defaultExtension.getSource()).getURI();
            return new File(VirtualFileSystem.getVirtualFileSystem().getPlatformPathName(jarUri));
        }
        return null;
    }

    public IdeHook getIdeHook(ElementName elementName) {
        return (IdeHook)this.getHook(elementName);
    }

    public ExtensionHook getHook(ElementName elementName) {
        ExtensionHook hook = super.getHook(elementName);
        if (hook == null) {
            hook = (ExtensionHook)this._ideHooksByElementName.get(elementName);
        }
        return hook;
    }

    protected final void registerIdeHook(ElementName elementName, ExtensionHook hook) {
        this._ideHooksByElementName.put(elementName, hook);
    }

    public abstract Collection<Extension> getAllExtensions();

    public Collection<String> getDisabledExtensions() {
        return Collections.emptyList();
    }

    public abstract Extension findExtensionEvenIfNotLoaded(String var1);

    public ClassLoader getClassLoader(String extensionId) {
        PolicyClassLoader cLoader = ClassLoaderQuery.findLoader((String)extensionId);
        if (cLoader == null) {
            cLoader = ClassLoaderQuery.findLoader((String)"ide-global");
        }
        return cLoader;
    }

    public Collection<ExtensionHook> getAllHooks() {
        return Collections.emptyList();
    }

    public static class ClassFactory {
        public static Class loadClass(String className) {
            return ClassFactory.findAndLoadClass(className, ClassLoaderQuery.findLoader((String)"ide-global"));
        }

        public static Class loadClass(String className, String extensionId) {
            PolicyClassLoader mainExtensionClassLoader = ClassLoaderQuery.findLoader((String)extensionId);
            HashSet<String> visitedClassLoaders = new HashSet<String>();
            if (mainExtensionClassLoader != null) {
                Class clazz = ClassFactory.loadClassWithLoader(className, mainExtensionClassLoader);
                if (clazz != null) {
                    return clazz;
                }
                visitedClassLoaders.add(mainExtensionClassLoader.getName());
            }
            Extension e = ExtensionRegistry.getExtensionRegistry().findExtension(extensionId);
            for (ExtensionDependency ed : e.getDependencies()) {
                PolicyClassLoader pcl = ClassLoaderQuery.findLoader((String)ed.getID());
                if (pcl == null || visitedClassLoaders.contains(pcl.getName())) continue;
                try {
                    return Class.forName(className, true, (ClassLoader)pcl);
                }
                catch (ClassNotFoundException f) {
                    _extensionLogger.log(Level.FINE, "Failed to find " + className + " in extension " + ed.getID() + " with loader " + pcl.getName());
                    visitedClassLoaders.add(pcl.getName());
                }
            }
            return null;
        }

        private static Class findAndLoadClass(String className, PolicyClassLoader loaderToStartFrom) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className, true, (ClassLoader)loaderToStartFrom);
            }
            catch (ClassNotFoundException e) {
                _extensionLogger.log(Level.FINE, "Failed to load " + className + " with loader " + loaderToStartFrom.getName());
                for (PolicyClassLoader childLoader : loaderToStartFrom.getChildren()) {
                    try {
                        clazz = Class.forName(className, true, (ClassLoader)childLoader);
                        if (clazz == null) continue;
                        return clazz;
                    }
                    catch (ClassNotFoundException f) {
                        _extensionLogger.log(Level.FINE, "Failed to load " + className + " with loader " + childLoader.getName());
                    }
                }
            }
            return clazz;
        }

        private static Class loadClassWithLoader(String className, PolicyClassLoader pcl) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className, true, (ClassLoader)pcl);
            }
            catch (ClassNotFoundException e) {
                _extensionLogger.log(Level.FINE, "Failed to load " + className + " with loader " + pcl.getName());
            }
            return clazz;
        }
    }
}

