/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.undo;

import ilog.views.sdm.IlvSDMModel;
import java.util.Collection;
import java.util.ResourceBundle;
import oracle.diagram.sdm.undo.SDMUndoUtil;
import oracle.diagram.sdm.undo.StateHelper;
import oracle.diagram.sdm.undo.StatefulCommand;
import oracle.javatools.util.BundleLoader;

public abstract class SDMModelCommand
extends StatefulCommand {
    protected static final String SET_ID;
    protected static final String SET_PROPERTY;
    protected static final String SET_FROM;
    protected static final String SET_TO;
    protected static final String ADD_OBJECT;
    protected static final String REMOVE_OBJECT;
    protected static final String BEGIN_ADJUSTMENT;
    protected static final String END_ADJUSTMENT;
    private final IlvSDMModel _model;

    public SDMModelCommand(int cmdId, String description, IlvSDMModel model) {
        super(cmdId, 0, description);
        this._model = model;
    }

    protected final IlvSDMModel getModel() {
        return this._model;
    }

    @Override
    protected Collection<StateHelper> getStateHelpers() {
        return SDMUndoUtil.getStateHelpers(this.getModel());
    }

    static {
        ResourceBundle rb = BundleLoader.getBundle((String)"oracle.diagram.res.UndoResource");
        SET_ID = rb.getString("setId.text");
        SET_PROPERTY = rb.getString("setProperty.text");
        SET_FROM = rb.getString("setFrom.text");
        SET_TO = rb.getString("setTo.text");
        ADD_OBJECT = rb.getString("addObject.text");
        REMOVE_OBJECT = rb.getString("removeObject.text");
        BEGIN_ADJUSTMENT = rb.getString("beginAdjustment.text");
        END_ADJUSTMENT = rb.getString("endAdjustment.text");
    }
}

