/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.dragdrop;

import ilog.views.IlvManagerView;
import ilog.views.sdm.IlvSDMEngine;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetListener;
import javax.swing.SwingUtilities;
import oracle.diagram.framework.dragdrop.ManagerViewDragAndDropController;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.datatransfer.SDMTransferable;

public class SDMManagerViewDragAndDropController
extends ManagerViewDragAndDropController
implements DragSourceListener {
    public SDMManagerViewDragAndDropController(DragSource ds, IlvManagerView view, Autoscroll autoscrollComponent, int actions, DropTargetListener dtl) {
        this(ds, view, autoscrollComponent, actions, SDMTransferable.DEFAULT_FLAVOR, dtl);
    }

    public SDMManagerViewDragAndDropController(DragSource ds, IlvManagerView view, Autoscroll autoscrollComponent, int actions, DataFlavor nativeFlavor, DropTargetListener dtl) {
        super(ds, view, autoscrollComponent, actions, nativeFlavor, dtl);
    }

    @Override
    protected void dragGestureRecognized(DragGestureEvent dge) {
        IlvSDMEngine engine = SDMDiagramContextUtil.getSDMEngine(this.getView());
        try {
            this.startDrag(dge, null, this.createTransferable(engine, this.getNativeFlavor(), dge), this);
        }
        catch (UnsupportedOperationException uoe) {
            System.out.println(uoe.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SDMDiagramContextUtil.getSDMEngine(SDMManagerViewDragAndDropController.this.getView()).deselectAllObjects();
            }
        });
    }

    protected Transferable createTransferable(IlvSDMEngine engine, DataFlavor flavor, DragGestureEvent dge) {
        return new SDMTransferable(engine, flavor);
    }
}

