/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.oppparse;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.bm.javatools.util.MultivaluedMap;
import oracle.diagram.oppparse.OPPArtifact;
import oracle.diagram.oppparse.OPPCID;
import oracle.diagram.oppparse.OPPDiagram;
import oracle.diagram.oppparse.OPPDiagramEdge;
import oracle.diagram.oppparse.OPPDiagramElement;
import oracle.diagram.oppparse.OPPDiagramNode;
import oracle.diagram.oppparse.OPPDiagramVisitor;
import oracle.diagram.oppparse.OPPElementReference;
import oracle.diagram.oppparse.OPPParseContext;
import oracle.ide.net.URLFactory;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;

public final class OPPDiagramParser {
    private static final Collection<OPPDiagramElement> EMPTY_SHAPES = Collections.unmodifiableCollection(new ArrayList(0));

    private OPPDiagramParser() {
    }

    public static OPPDiagram parseDiagram(URL diagramURL) throws Exception {
        DOMParser parser = new DOMParser();
        parser.setPreserveWhitespace(false);
        parser.parse(diagramURL);
        XMLDocument doc = parser.getDocument();
        return OPPDiagramParser.parseDiagram(doc);
    }

    public static OPPDiagram parseDiagram(XMLDocument doc) {
        return new OPPDiagram((OPPParseContext)new MyContext(), doc, (XMLElement)doc.getDocumentElement());
    }

    public static void main(String[] args) throws Exception {
        OPPDiagramParser.parseDiagram(URLFactory.newFileURL((String)args[0])).visit(new OPPDiagramVisitor(){

            @Override
            public void visitDiagram(OPPDiagram diagram) {
                System.out.println("Diagram");
            }

            @Override
            public void visitNodeShape(OPPDiagramNode node) {
                System.out.println("Node");
            }

            @Override
            public void visitEdgeShape(OPPDiagramEdge edge) {
                System.out.println("Edge");
            }
        });
    }

    private static final class MyContext
    implements OPPParseContext {
        private final Map<Long, OPPDiagramElement> _druidMap = new HashMap<Long, OPPDiagramElement>(133333);
        private final MultivaluedMap<OPPElementReference, OPPDiagramElement> _refMap = new MultivaluedMap();
        private final Map<OPPCID, OPPArtifact> _artifactMap = new HashMap<OPPCID, OPPArtifact>();

        private MyContext() {
        }

        @Override
        public void cacheShape(OPPDiagramElement shape) {
            if (this._druidMap.containsKey(shape.getDrUID())) {
                throw new IllegalArgumentException("caching duplicate DrUID: " + shape.getDrUID());
            }
            this._druidMap.put(shape.getDrUID(), shape);
            this._refMap.put((Object)shape.getPrimaryElementReference(), (Object)shape);
        }

        @Override
        public Collection<OPPDiagramElement> getShapesWithReference(OPPElementReference ref) {
            Collection result = this._refMap.get((Object)ref);
            if (result != null) {
                return result;
            }
            return EMPTY_SHAPES;
        }

        @Override
        public OPPDiagramElement resolveDrUID(long druid) {
            OPPDiagramElement result = this._druidMap.get(druid);
            if (result == null) {
                throw new IllegalStateException("Unable to resolve DrUID: " + druid);
            }
            return result;
        }

        @Override
        public void cacheArtifact(OPPCID cid, OPPArtifact artifact) {
            this._artifactMap.put(cid, artifact);
        }

        @Override
        public OPPArtifact resolveCID(OPPCID cid) {
            return this._artifactMap.get(cid);
        }
    }
}

