/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.oppparse;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.diagram.oppparse.OPPArtifact;
import oracle.diagram.oppparse.OPPCID;
import oracle.diagram.oppparse.OPPContainer;
import oracle.diagram.oppparse.OPPDiagramDisplayPreferences;
import oracle.diagram.oppparse.OPPDiagramNode;
import oracle.diagram.oppparse.OPPDiagramVisitor;
import oracle.diagram.oppparse.OPPDimension;
import oracle.diagram.oppparse.OPPElementReference;
import oracle.diagram.oppparse.OPPParseContext;
import oracle.diagram.oppparse.OPPParseUtil;
import oracle.diagram.oppparse.OPPPrintSettings;
import oracle.diagram.oppparse.OPPTopLevelShape;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class OPPDiagram
extends OPPContainer {
    private final XMLDocument _xmlDoc;
    private final String _name;
    private final List<OPPTopLevelShape> _contents;
    private final OPPPrintSettings _printSettings;
    private final OPPDiagramDisplayPreferences _prefs;
    private Point2D _diagTL;
    private OPPDimension _diagSize;
    private final Collection<OPPArtifact> _artifacts;

    OPPDiagram(OPPParseContext context, XMLDocument xmlDoc, XMLElement xmlSource) {
        super(context, null, xmlSource, OPPParseUtil.getSingleChild(xmlSource, "diagramProperty"));
        this._xmlDoc = xmlDoc;
        this._name = (String)OPPParseUtil.parseTypedProperty(OPPParseUtil.getNamedChild(xmlSource, "string", "diagramName"));
        XMLElement dp = OPPParseUtil.getSingleChild(xmlSource, "diagramProperty");
        XMLElement diagTL = OPPParseUtil.getNamedChild(dp, "point", "pageTL");
        this._diagTL = (Point2D)OPPParseUtil.parseTypedProperty(diagTL);
        XMLElement diagSize = OPPParseUtil.getNamedChild(dp, "point", "pageSize");
        Point2D tmp = (Point2D)OPPParseUtil.parseTypedProperty(diagSize);
        this._diagSize = new OPPDimension((float)tmp.getX(), (float)tmp.getY());
        this._printSettings = new OPPPrintSettings(this, dp);
        this._prefs = new OPPDiagramDisplayPreferences(this, dp);
        XMLElement layer = OPPParseUtil.getSingleChild(xmlSource, "layer");
        XMLElement base = OPPParseUtil.getNamedChild(layer, "infoList", "base");
        this._contents = Collections.unmodifiableList(OPPParseUtil.getShapesUsed(this, base));
        ArrayList<OPPArtifact> artifactList = new ArrayList<OPPArtifact>();
        NodeList artifacts = xmlSource.getChildrenByTagName("artifact", "http://xmlns.oracle.com/jdeveloper/modeler/artifact");
        if (artifacts != null) {
            int isize = artifacts.getLength();
            for (int i = 0; i < isize; ++i) {
                XMLElement artifact = (XMLElement)artifacts.item(i);
                artifactList.add(new OPPArtifact(context, null, artifact));
            }
        }
        this._artifacts = Collections.unmodifiableCollection(artifactList);
        for (OPPTopLevelShape s : this._contents) {
            s.resolveShapeReferences();
        }
    }

    void removeStructureRecord(OPPTopLevelShape shape) {
        OPPElementReference er = shape.getPrimaryElementReference();
        XMLElement structure = OPPParseUtil.getSingleChild(this.getXMLSource(), "structure");
        NodeList shapesList = structure.getChildrenByTagName("shape");
        int isize = shapesList.getLength();
        for (int i = 0; i < isize; ++i) {
            Node node = shapesList.item(i);
            if (!this.isMatchingStructureRecord((XMLElement)node, er)) continue;
            node.getParentNode().removeChild(node);
            return;
        }
    }

    private boolean isMatchingStructureRecord(XMLElement sr, OPPElementReference ref) {
        XMLElement er = OPPParseUtil.getSingleChild(sr, "elemRef");
        return ref.getValue().equals(OPPParseUtil.getValueAttribute(er));
    }

    public final OPPDiagramDisplayPreferences getDisplayPreferences() {
        return this._prefs;
    }

    public final OPPPrintSettings getPrintSettings() {
        return this._printSettings;
    }

    public final Point2D getDiagramTopLeft() {
        return new Point2D.Float((float)this._diagTL.getX(), (float)this._diagTL.getY());
    }

    public final OPPDimension getDiagramSize() {
        return this._diagSize;
    }

    public final Collection<OPPTopLevelShape> getShapes() {
        ArrayList<OPPTopLevelShape> filtered = new ArrayList<OPPTopLevelShape>(this._contents.size());
        for (OPPTopLevelShape s : this._contents) {
            if (s.isDeleted()) continue;
            filtered.add(s);
        }
        return Collections.unmodifiableCollection(filtered);
    }

    public final Collection<OPPArtifact> getArtifacts() {
        return this._artifacts;
    }

    public final OPPArtifact getArtifact(OPPCID cid) {
        return this.getContext().resolveCID(cid);
    }

    public final XMLDocument getXMLDocument() {
        return this._xmlDoc;
    }

    public final void visit(OPPDiagramVisitor visitor) {
        visitor.visitDiagram(this);
        Collection<OPPTopLevelShape> shapes = this.getShapes();
        for (OPPTopLevelShape s : shapes) {
            if (!(s instanceof OPPDiagramNode)) continue;
            s.visit(visitor, true);
        }
        for (OPPTopLevelShape s : shapes) {
            s.visit(visitor, false);
        }
    }

    public static final OPPDiagram getDiagram(OPPContainer item) {
        return (OPPDiagram)item.getRoot();
    }
}

