/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.selection;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import java.util.LinkedHashSet;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginManager;
import oracle.diagram.framework.selection.DiagramIdeSelectionPlugin;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.ide.model.Element;

public abstract class AbstractDiagramIdeSelectionPlugin
extends AbstractPlugin
implements DiagramIdeSelectionPlugin {
    private static final Element[] EMPTY = new Element[0];
    private final DiagramContext _context;
    private Element[] _cachedSelection = EMPTY;
    private Element[] _cachedInspectorSelection = EMPTY;

    public AbstractDiagramIdeSelectionPlugin(DiagramContext context) {
        this._context = context;
    }

    @Override
    public final void fetchSelectionFromUI() {
        IlvManager mgr = this.getDiagramContext().getManagerView().getManager();
        LinkedHashSet<Element> selection = new LinkedHashSet<Element>();
        LinkedHashSet<Element> inspectorSelection = new LinkedHashSet<Element>();
        boolean hasSelection = false;
        for (int pass = 0; pass < 2; ++pass) {
            IlvGraphicEnumeration e;
            IlvGraphicEnumeration ilvGraphicEnumeration = e = pass == 0 ? mgr.getSelectedObjects(true) : SubSelectionManager.getInstance().getSelectedSubObjects(mgr);
            while (e.hasMoreElements()) {
                Element[] tmpInspectorSelection;
                hasSelection = true;
                IlvGraphic g = e.nextElement();
                Element[] tmpSelection = this.getGraphicSelection(g);
                if (tmpSelection != null && tmpSelection.length > 0) {
                    for (Element el : tmpSelection) {
                        selection.add(el);
                    }
                }
                if ((tmpInspectorSelection = this.getGraphicInspectorSelection(g)) == null || tmpInspectorSelection.length <= 0) continue;
                for (Element el : tmpInspectorSelection) {
                    inspectorSelection.add(el);
                    if (tmpSelection != null && tmpSelection.length != 0) continue;
                    selection.add(el);
                }
            }
        }
        if (!hasSelection) {
            Element[] root = this.getGraphicInspectorSelection((IlvGraphic)mgr);
            if (root != null && root.length != 0) {
                this._cachedSelection = EMPTY;
                this._cachedInspectorSelection = root;
            } else {
                this._cachedSelection = EMPTY;
                this._cachedInspectorSelection = EMPTY;
            }
            return;
        }
        this._cachedSelection = selection != null ? selection.toArray(new Element[selection.size()]) : EMPTY;
        this._cachedInspectorSelection = inspectorSelection != null ? inspectorSelection.toArray(new Element[inspectorSelection.size()]) : EMPTY;
    }

    @Override
    public final Element[] getInspectorSelection() {
        return this._cachedInspectorSelection;
    }

    @Override
    public final Element[] getSelection() {
        return this._cachedSelection;
    }

    protected abstract Element[] getGraphicSelection(IlvGraphic var1);

    protected Element[] getGraphicInspectorSelection(IlvGraphic graphic) {
        return null;
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }

    @Override
    public void detach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
        super.detach(pluginManager, pluginType);
        this._cachedSelection = null;
        this._cachedInspectorSelection = null;
    }
}

