/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.print;

import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.print.IlvManagerPrintableDocument;
import ilog.views.print.IlvManagerPrintingController;
import ilog.views.util.print.IlvPrintableDocument;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.net.URL;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.framework.print.AbstractPrintPlugin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;

public class DefaultPrintPlugin
extends AbstractPrintPlugin {
    private IlvManagerPrintingController _controller = null;

    public DefaultPrintPlugin(DiagramContext context) {
        super(context);
    }

    @Override
    public void pageSetup() {
        IlvRect newPA;
        IlvManagerPrintingController c = this.getPrintingController();
        PageFormat oldPF = this.getPageFormat();
        c.getDocument().setPageFormat(oldPF);
        IlvRect oldPA = this.getPrintArea();
        ((IlvManagerPrintableDocument)c.getDocument()).setPrintArea(DefaultPrintPlugin.getEffectivePrintArea(oldPA, false));
        c.getDocument().setName(this.getDocumentName());
        c.setupDialog((Window)Ide.getMainWindow(), false, false);
        if (!DefaultPrintPlugin.areEquivalent(oldPF, c.getDocument().getPageFormat())) {
            this.setPageFormat(c.getDocument().getPageFormat());
        }
        if (!DefaultPrintPlugin.areEquivalent(oldPA, newPA = DefaultPrintPlugin.getEffectivePrintArea(((IlvManagerPrintableDocument)c.getDocument()).getPrintArea(), ((IlvManagerPrintableDocument)c.getDocument()).isPrintingAllManagerBBox()))) {
            this.setPrintArea(newPA);
        }
    }

    protected static IlvRect getEffectivePrintArea(IlvRect area, boolean all) {
        if (area == null || all) {
            return null;
        }
        if (area.getWidth() == 0.0 || area.getHeight() == 0.0) {
            return null;
        }
        return area;
    }

    protected static boolean areEquivalent(Object o1, Object o2) {
        if (o1 == null && o2 != null) {
            return false;
        }
        if (o2 == null && o1 != null) {
            return false;
        }
        if (o1 == null && o2 == null) {
            return true;
        }
        return o1.equals(o2);
    }

    @Override
    public void print(boolean withSetup) throws PrinterException {
        IlvManagerPrintingController c = this.getPrintingController();
        PageFormat oldPF = this.getPageFormat();
        c.getDocument().setPageFormat(oldPF);
        IlvRect oldPA = this.getPrintArea();
        ((IlvManagerPrintableDocument)c.getDocument()).setPrintArea(DefaultPrintPlugin.getEffectivePrintArea(oldPA, false));
        c.print(withSetup);
        if (withSetup) {
            IlvRect newPA;
            if (!DefaultPrintPlugin.areEquivalent(oldPF, c.getDocument().getPageFormat())) {
                this.setPageFormat(c.getDocument().getPageFormat());
            }
            if (!DefaultPrintPlugin.areEquivalent(oldPA, newPA = DefaultPrintPlugin.getEffectivePrintArea(((IlvManagerPrintableDocument)c.getDocument()).getPrintArea(), ((IlvManagerPrintableDocument)c.getDocument()).isPrintingAllManagerBBox()))) {
                this.setPrintArea(newPA);
            }
        }
    }

    @Override
    public void printPreview() {
        IlvManagerPrintingController c = this.getPrintingController();
        PageFormat oldPF = this.getPageFormat();
        c.getDocument().setPageFormat(oldPF);
        IlvRect oldPA = this.getPrintArea();
        ((IlvManagerPrintableDocument)c.getDocument()).setPrintArea(DefaultPrintPlugin.getEffectivePrintArea(oldPA, false));
        c.setPreviewMode(this.getPreviewMode());
        c.printPreview((Window)Ide.getMainWindow());
    }

    @Override
    protected void pageFormatChanged() {
        super.pageFormatChanged();
        IlvManagerPrintingController c = this.getPrintingController();
        IlvManagerPrintableDocument doc = (IlvManagerPrintableDocument)c.getDocument();
        doc.setPageFormat(this.getPageFormat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void printAreaChanged() {
        super.printAreaChanged();
        IlvManagerPrintingController c = this.getPrintingController();
        IlvManagerPrintableDocument doc = (IlvManagerPrintableDocument)c.getDocument();
        IlvRect oldPrintArea = doc.getPrintArea();
        IlvRect newPrintArea = this.getPrintArea();
        doc.setPrintArea(newPrintArea);
        IlvManagerView view = this.getDiagramContext().getManagerView();
        IlvManager mgr = view.getManager();
        mgr.initReDraws();
        int redrawMode = view.getRedrawMode();
        try {
            if (oldPrintArea != null) {
                mgr.invalidateRegion(oldPrintArea);
            }
            if (newPrintArea != null) {
                mgr.invalidateRegion(newPrintArea);
            }
        }
        finally {
            if (oldPrintArea != null || newPrintArea != null) {
                try {
                    view.setRedrawMode(1);
                    mgr.reDrawViews();
                }
                finally {
                    view.setRedrawMode(redrawMode);
                }
            } else {
                mgr.abortReDraws();
            }
        }
    }

    protected IlvManagerPrintingController createPrintingController(IlvManagerView view) {
        IlvManagerPrintingController pc = new IlvManagerPrintingController(view);
        pc.setDocument((IlvPrintableDocument)new IlvManagerPrintableDocument(this.getDocumentName(), view, this.getPageFormat()));
        return pc;
    }

    protected String getDocumentName() {
        Context context = this.getDiagramContext().getPlugin(IdeContextPlugin.class).getContext();
        Node node = context.getNode();
        if (node != null) {
            return URLFileSystem.getPlatformPathName((URL)node.getURL());
        }
        return null;
    }

    protected final synchronized IlvManagerPrintingController getPrintingController() {
        if (this._controller == null) {
            this._controller = this.createPrintingController(this.getDiagramContext().getManagerView());
            this.initController(this._controller);
        }
        return this._controller;
    }

    protected void initController(IlvManagerPrintingController c) {
        c.getDocument().setPageFormat(this.getPageFormat());
        ((IlvManagerPrintableDocument)c.getDocument()).setPrintArea(this.getPrintArea());
    }

    protected int getPreviewMode() {
        return 0;
    }
}

