/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference;

import java.awt.Color;
import java.awt.Font;
import java.util.ResourceBundle;
import oracle.bali.inspector.PropertyGroup;
import oracle.diagram.framework.graphic.NoteShape;
import oracle.diagram.framework.preference.PreferenceDefinition;
import oracle.diagram.framework.preference.PreferenceUtil;
import oracle.diagram.framework.preference.StandardPropertyGroup;
import oracle.diagram.framework.preference.propertyeditor.ColorPropertyEditor;
import oracle.diagram.framework.preference.propertyeditor.FontPropertyEditor;
import oracle.javatools.util.BundleLoader;

public class Preferences {
    public static final PropertyGroup GRAPHICAL_GROUP;
    public static final PropertyGroup DISPLAY_OPTIONS_GROUP;
    public static final PreferenceDefinition FILL_COLOR;
    public static final PreferenceDefinition LINE_COLOR;
    public static final PreferenceDefinition FONT_COLOR;
    public static final PreferenceDefinition FONT;
    public static final PreferenceDefinition LINE_WIDTH;
    public static final PreferenceDefinition NOTE_FILL_COLOR;
    public static final PreferenceDefinition NOTE_LINE_COLOR;

    static {
        ResourceBundle rb = BundleLoader.getBundle((String)"oracle.diagram.res.PreferenceResource");
        GRAPHICAL_GROUP = new StandardPropertyGroup(rb, "graphicalGroup");
        DISPLAY_OPTIONS_GROUP = new StandardPropertyGroup(rb, "displayOptionsGroup");
        FILL_COLOR = PreferenceUtil.createPreferenceDefinition("fillColor", rb, "fillColor", GRAPHICAL_GROUP, ColorPropertyEditor.class, Color.LIGHT_GRAY, Color.class);
        LINE_COLOR = PreferenceUtil.createPreferenceDefinition("lineColor", rb, "lineColor", GRAPHICAL_GROUP, ColorPropertyEditor.class, Color.BLACK, Color.class);
        FONT_COLOR = PreferenceUtil.createPreferenceDefinition("fontColor", rb, "fontColor", GRAPHICAL_GROUP, ColorPropertyEditor.class, Color.BLACK, Color.class);
        FONT = PreferenceUtil.createPreferenceDefinition("font", rb, "font", GRAPHICAL_GROUP, FontPropertyEditor.class, new Font("SansSerif", 0, 11), Font.class);
        LINE_WIDTH = PreferenceUtil.createPreferenceDefinition("lineWidth", rb, "lineWidth", GRAPHICAL_GROUP, null, new Float(2.0f), Float.class);
        NOTE_FILL_COLOR = PreferenceUtil.createPreferenceDefinitionAs(FILL_COLOR, NoteShape.DEFAULT_FILL_COLOR);
        NOTE_LINE_COLOR = PreferenceUtil.createPreferenceDefinitionAs(LINE_COLOR, NoteShape.DEFAULT_LINE_COLOR);
    }
}

