/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.palette;

import javax.swing.SwingUtilities;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.framework.palette.PaletteItemHandler;
import oracle.diagram.framework.palette.PalettePlugin;
import oracle.diagram.framework.palette.PaletteTask;
import oracle.diagram.framework.palette.event.PaletteItemDropTargetDragEvent;
import oracle.diagram.framework.palette.event.PaletteItemDropTargetDropEvent;
import oracle.diagram.framework.palette.event.PaletteItemDropTargetEvent;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteManager;
import oracle.ide.palette2.PalettePage;
import oracle.ideimpl.palette2.PaletteControllerUI;

public abstract class AbstractPalettePlugin
extends AbstractPlugin
implements PalettePlugin {
    private final DiagramContext _context;
    private PaletteTask _lastTask = null;
    private PaletteItem _lastItem;
    private PaletteTask _lastDropTask = null;
    private boolean _isSticky = false;

    public AbstractPalettePlugin(DiagramContext context) {
        this._context = context;
    }

    @Override
    public void synchronizePalette() {
    }

    @Override
    public void reset() {
        this.resetState();
        this.resetDropState();
        if (this._lastItem != null) {
            PaletteControllerUI.getInstance().unSelectSelectedItem(true);
        }
    }

    @Override
    public void taskFinished(PaletteTask task) {
        if (task == this._lastTask || this._lastTask instanceof DeferredPaletteTask && task == ((DeferredPaletteTask)this._lastTask).getDeferredTask()) {
            this.reset();
        }
    }

    protected void resetState() {
        if (this._lastTask != null) {
            this._lastTask.abort();
            this._lastTask = null;
        }
    }

    protected void resetDropState() {
        if (this._lastDropTask != null) {
            this._lastDropTask.abort();
            this._lastDropTask = null;
        }
    }

    @Override
    public void paletteItemSelected(PaletteItem item) {
        this.resetState();
        this.resetDropState();
        this._lastItem = item;
        PaletteItemHandler handler = this.getHandler(item);
        if (handler != null) {
            final DeferredPaletteTask task = new DeferredPaletteTask(this._context, item, handler);
            this._lastTask = task;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    task.invoke(AbstractPalettePlugin.this.isSticky());
                }
            });
        }
    }

    @Override
    public void paletteItemUnselected(PaletteItem item) {
        if (item == this._lastItem) {
            this._lastItem = null;
            this.resetState();
            this.resetDropState();
        }
    }

    @Override
    public void defaultCreate(final PaletteItem item) {
        final PaletteItemHandler handler = this.getHandler(item);
        if (handler != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    handler.defaultCreate(AbstractPalettePlugin.this._context, item);
                    if (!AbstractPalettePlugin.this.isSticky()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AbstractPalettePlugin.this.reset();
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    public void update() {
    }

    @Override
    public void dragEnter(PaletteItemDropTargetDragEvent dtde) {
        this.resetState();
        this.resetDropState();
        PaletteItemHandler handler = this.getHandler(dtde.getPaletteItem());
        if (handler != null) {
            handler.dragEnter(dtde);
        }
    }

    @Override
    public void dragExit(PaletteItemDropTargetEvent dte) {
        PaletteItemHandler handler = this.getHandler(dte.getPaletteItem());
        if (handler != null) {
            handler.dragExit(dte);
        }
    }

    @Override
    public void dragOver(PaletteItemDropTargetDragEvent dtde) {
        PaletteItemHandler handler = this.getHandler(dtde.getPaletteItem());
        if (handler != null) {
            handler.dragOver(dtde);
        }
    }

    @Override
    public void dropActionChanged(PaletteItemDropTargetDragEvent dtde) {
        PaletteItemHandler handler = this.getHandler(dtde.getPaletteItem());
        if (handler != null) {
            handler.dropActionChanged(dtde);
        }
    }

    @Override
    public void drop(PaletteItemDropTargetDropEvent dtde) {
        PaletteItemHandler handler = this.getHandler(dtde.getPaletteItem());
        if (handler != null) {
            this.resetState();
            this.resetDropState();
            this._lastDropTask = handler.drop(dtde);
            if (this._lastDropTask != null) {
                this._lastDropTask.invoke(this.isSticky());
            }
        }
    }

    @Override
    public void paletteClosed(PaletteManager manager) {
    }

    @Override
    public void paletteOpened(PaletteManager manager) {
    }

    @Override
    public void selectionChanged(PalettePage page) {
    }

    @Override
    public void stickyModeActivated(PaletteItem item) {
        this._isSticky = true;
        if (this._lastTask != null) {
            this._lastTask.setSticky(this._isSticky);
        }
    }

    @Override
    public void stickyModeDeactivated(PaletteItem item) {
        if (item == this._lastItem) {
            this._isSticky = false;
            if (this._lastTask != null) {
                this._lastTask.setSticky(this._isSticky);
            }
        }
    }

    @Override
    public boolean isSticky() {
        return this._isSticky;
    }

    @Override
    public boolean canHandleItem(PaletteItem item) {
        return this.getHandler(item) != null;
    }

    protected abstract PaletteItemHandler getHandler(PaletteItem var1);

    private class DeferredPaletteTask
    extends PaletteTask {
        private final PaletteItemHandler _handler;
        private boolean _invoked;
        private PaletteTask _task;

        public DeferredPaletteTask(DiagramContext context, PaletteItem item, PaletteItemHandler handler) {
            super(context, item);
            this._invoked = false;
            this._task = null;
            this._handler = handler;
        }

        public PaletteTask getDeferredTask() {
            return this._task;
        }

        @Override
        public void invoke(boolean isSticky) {
            if (!this._invoked) {
                this._invoked = true;
                this._task = this._handler.paletteItemSelected(this.getDiagramContext(), this.getPaletteItem());
                if (this._task != null) {
                    this._task.invoke(isSticky);
                }
            }
        }

        @Override
        public void setSticky(boolean isSticky) {
            if (this._invoked && this._task != null) {
                this._task.setSticky(isSticky);
            }
        }

        @Override
        protected void abortImpl() {
            if (this._invoked && this._task != null) {
                this._task.abortImpl();
                this._task = null;
            }
        }
    }
}

