/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.manager;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLayerVisibilityFilter;
import ilog.views.IlvManager;
import ilog.views.IlvManagerFrame;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvManagerStreamFactory;
import ilog.views.io.IlvOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import oracle.diagram.framework.manager.ManagerAction;

public final class ManagerUtil {
    public static final int CONTENT_ADJUSTING = 1;
    public static final int ADJUSTING_PARENTS = 2;
    public static final int SELECTION_ADJUSTING = 4;
    public static final int INVALIDATE_VIEWS = 8;
    private static final String SELECTION_LAYER_STATE = "layerVisibilityState";

    private ManagerUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object performAction(IlvManager manager, ManagerAction action, int flags) throws Exception {
        Object object;
        block8: {
            try {
                manager.initReDraws();
                if ((flags & 1) == 1) {
                    manager.setContentsAdjusting(true, (flags & 2) == 2);
                }
                if ((flags & 4) == 4) {
                    manager.setSelectionAdjusting(true);
                }
                if ((flags & 8) == 8) {
                    ManagerUtil.invalidateAllViews(manager);
                }
                object = action.performAction(manager);
                if ((flags & 4) != 4) break block8;
            }
            catch (Throwable throwable) {
                if ((flags & 4) == 4) {
                    manager.setSelectionAdjusting(false);
                }
                if ((flags & 1) == 1) {
                    manager.setContentsAdjusting(false, (flags & 2) == 2);
                }
                manager.reDrawViews();
                throw throwable;
            }
            manager.setSelectionAdjusting(false);
        }
        if ((flags & 1) == 1) {
            manager.setContentsAdjusting(false, (flags & 2) == 2);
        }
        manager.reDrawViews();
        return object;
    }

    public static void invalidateAllViews(IlvManager manager) {
        ManagerUtil.invalidateAllViews(manager, null);
    }

    public static void invalidateAllViews(IlvManager manager, IlvManagerView source) {
        Enumeration e = manager.getViews();
        while (e.hasMoreElements()) {
            IlvManagerView view = (IlvManagerView)e.nextElement();
            if (view == source) continue;
            view.invalidateView();
        }
    }

    public static IlvOutputStream createOutputStream(IlvManager mgr, OutputStream sourceOutputStream) {
        IlvManagerStreamFactory factory = mgr.getStreamFactory();
        if (factory != null) {
            return factory.createOutputStream(sourceOutputStream);
        }
        return new IlvOutputStream(sourceOutputStream);
    }

    public static IlvInputStream createInputStream(IlvManager mgr, InputStream sourceInputStream) {
        IlvManagerStreamFactory factory = mgr.getStreamFactory();
        if (factory != null) {
            return factory.createInputStream(sourceInputStream);
        }
        return new IlvInputStream(sourceInputStream);
    }

    public static IlvTransformer getConversionTransformer(IlvManager ancestor, IlvManager child) {
        if (child == ancestor) {
            return new IlvTransformer();
        }
        IlvManager parent = (IlvManager)child.getGraphicBag();
        if (parent != null) {
            IlvTransformer tx = ManagerUtil.getConversionTransformer(ancestor, parent);
            tx.postCompose(child.getTransformer());
            return tx;
        }
        throw new IllegalStateException("No path from child manager to ancestor manager");
    }

    public static IlvManager getManager(IlvGraphic g) {
        IlvGraphicBag bag;
        for (bag = g.getGraphicBag(); bag != null && !(bag instanceof IlvManager); bag = bag.getGraphicBag()) {
        }
        if (bag instanceof IlvManager) {
            return (IlvManager)bag;
        }
        return null;
    }

    public static IlvManager getTopManager(IlvGraphic g) {
        IlvManager owningManager = ManagerUtil.getManager(g);
        if (owningManager == null) {
            if (g instanceof IlvManager) {
                return (IlvManager)g;
            }
            return null;
        }
        IlvManager topManager = owningManager;
        for (IlvManager parentManager = owningManager.getParent(); parentManager != null; parentManager = parentManager.getParent()) {
            topManager = parentManager;
        }
        return topManager;
    }

    public static boolean isSelectedOrParentSelected(IlvGraphic g) {
        boolean isSelected = false;
        IlvManager parentManager = ManagerUtil.getManager(g);
        while (parentManager != null && !isSelected) {
            isSelected = parentManager.isSelected(g);
            if (isSelected) continue;
            g = parentManager;
            parentManager = parentManager.getParent();
        }
        return isSelected;
    }

    public static IlvGraphic selectedOrParentSelected(IlvGraphic g) {
        boolean isSelected = false;
        IlvManager parentManager = ManagerUtil.getManager(g);
        while (parentManager != null && !isSelected) {
            isSelected = parentManager.isSelected(g);
            if (isSelected) continue;
            g = parentManager;
            parentManager = parentManager.getParent();
        }
        return g;
    }

    public static IlvManager getTransformingManager(IlvGraphic g) {
        return ManagerUtil.getTransformingManagerImpl(g.getGraphicBag(), g, 0);
    }

    private static IlvManager getTransformingManagerImpl(IlvGraphicBag bag, IlvGraphic prevGraphic, int skipCount) {
        if (bag instanceof IlvManagerFrame) {
            IlvGraphicBag parentBag = bag.getGraphicBag();
            return ManagerUtil.getTransformingManagerImpl(parentBag, null, skipCount + 1);
        }
        if (bag instanceof IlvManager) {
            IlvManager mgr = (IlvManager)bag;
            IlvGraphic collapsed = mgr.getCollapsedGraphic();
            if (collapsed != null && collapsed == prevGraphic) {
                IlvGraphicBag parentBag = bag.getGraphicBag();
                return ManagerUtil.getTransformingManagerImpl(parentBag, (IlvGraphic)mgr, skipCount);
            }
            if (skipCount == 0) {
                return mgr;
            }
            IlvGraphicBag parentBag = bag.getGraphicBag();
            return ManagerUtil.getTransformingManagerImpl(parentBag, (IlvGraphic)((IlvManager)bag), skipCount - 1);
        }
        if (bag instanceof IlvGraphic) {
            return ManagerUtil.getTransformingManagerImpl(bag.getGraphicBag(), (IlvGraphic)bag, skipCount);
        }
        if (bag != null) {
            return ManagerUtil.getTransformingManagerImpl(bag.getGraphicBag(), null, skipCount);
        }
        return null;
    }

    public static void bringToFront(IlvGraphic g) {
        IlvManagerLayer layer = ManagerUtil.getLayer(g, false);
        if (layer == null) {
            return;
        }
        int newIndex = layer.getCardinal() - 1;
        layer.setIndex(g, newIndex);
    }

    public static void sendToBack(IlvGraphic g) {
        IlvManagerLayer layer = ManagerUtil.getLayer(g, false);
        if (layer == null) {
            return;
        }
        layer.setIndex(g, 0);
    }

    public static void bringForward(IlvGraphic g) {
        IlvManagerLayer layer = ManagerUtil.getLayer(g, false);
        if (layer == null) {
            return;
        }
        int index = layer.getIndex(g);
        if (index < layer.getCardinal() - 1) {
            layer.setIndex(g, index + 1);
        }
    }

    public static void sendBackward(IlvGraphic g) {
        IlvManagerLayer layer = ManagerUtil.getLayer(g, false);
        if (layer == null) {
            return;
        }
        int index = layer.getIndex(g);
        if (index > 0) {
            layer.setIndex(g, index - 1);
        }
    }

    public static IlvManager getSharedAncestor(IlvGraphic g1, IlvGraphic g2) {
        IlvManager mgr = ManagerUtil.getManager(g1);
        while (mgr != null && !ManagerUtil.isAncestor(mgr, g2)) {
            mgr = ManagerUtil.getManager((IlvGraphic)mgr);
        }
        return mgr;
    }

    public static int getLayerInManager(IlvGraphic g, IlvManager mgr) {
        IlvManager owningMgr = ManagerUtil.getManager(g);
        if (owningMgr == mgr) {
            return owningMgr.getLayer(g);
        }
        if (!ManagerUtil.isAncestor(mgr, (IlvGraphic)owningMgr)) {
            return -1;
        }
        return ManagerUtil.getLayerInManager((IlvGraphic)owningMgr, mgr);
    }

    public static IlvManagerLayer getLayer(IlvGraphic g, boolean traverse) {
        IlvManager mgr = null;
        if (traverse) {
            mgr = ManagerUtil.getManager(g);
        } else {
            IlvGraphicBag bag = g.getGraphicBag();
            if (!(bag instanceof IlvManager)) {
                return null;
            }
            mgr = (IlvManager)bag;
        }
        if (mgr == null) {
            return null;
        }
        int layerIndex = mgr.getLayer(g);
        if (layerIndex == -1) {
            return null;
        }
        IlvManagerLayer layer = mgr.getManagerLayer(layerIndex);
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateRegion(IlvGraphic g) {
        IlvManager mgr = ManagerUtil.getTransformingManager(g);
        IlvTransformer tx = mgr.getTopLevelTransformer();
        IlvManager rootManager = ManagerUtil.getTopManager((IlvGraphic)mgr);
        boolean shouldRedraw = !rootManager.isInvalidating();
        try {
            if (shouldRedraw) {
                rootManager.initReDraws();
            }
            rootManager.invalidateRegion(g.boundingBox(tx));
        }
        finally {
            if (shouldRedraw) {
                rootManager.reDrawViews();
            }
        }
    }

    public static IlvGraphic getManagedAncestor(IlvGraphic g) {
        IlvGraphicBag bag = g.getGraphicBag();
        if (bag instanceof IlvManager) {
            if (((IlvManager)bag).getCollapsedGraphic() == g) {
                return ManagerUtil.getManagedAncestor((IlvGraphic)bag);
            }
            return g;
        }
        if (bag instanceof IlvGraphic) {
            return ManagerUtil.getManagedAncestor((IlvGraphic)bag);
        }
        if (bag != null && bag.getGraphicBag() instanceof IlvGraphic) {
            return ManagerUtil.getManagedAncestor((IlvGraphic)bag.getGraphicBag());
        }
        return null;
    }

    public static void applyToObject(IlvGraphic g, IlvApplyObject a, Object param, boolean redraw) {
        IlvGraphic apply = ManagerUtil.getManagedAncestor(g);
        ((IlvManager)apply.getGraphicBag()).applyToObject(apply, a, param, redraw);
    }

    public static boolean hasSelectedAncestor(IlvGraphic g) {
        IlvGraphicBag bag = g.getGraphicBag();
        while (bag != null) {
            IlvGraphicBag mgrOfMgr = null;
            if (bag instanceof IlvManager) {
                IlvManager mgr = (IlvManager)bag;
                mgrOfMgr = mgr.getGraphicBag();
                if (mgrOfMgr != null && mgrOfMgr instanceof IlvManager && ((IlvManager)mgrOfMgr).isSelected((IlvGraphic)mgr)) {
                    return true;
                }
                bag = mgrOfMgr;
                continue;
            }
            bag = ((IlvGraphic)bag).getGraphicBag();
        }
        return false;
    }

    public static boolean isAncestor(IlvManager ancestor, IlvGraphic g) {
        for (IlvGraphicBag mgr = g.getGraphicBag(); mgr != null; mgr = mgr.getGraphicBag()) {
            if (mgr != ancestor) continue;
            return true;
        }
        return false;
    }

    public static boolean isInCollapsedManager(IlvGraphic g) {
        IlvManager mgr = ManagerUtil.getManager(g);
        while (mgr != null && !mgr.isCollapsed()) {
            mgr = ManagerUtil.getManager((IlvGraphic)mgr);
        }
        return mgr != null;
    }

    public static Collection<IlvManagerView> getViews(IlvManager mgr) {
        ArrayList<IlvManagerView> views = new ArrayList<IlvManagerView>();
        Enumeration e = mgr.getViews();
        while (e.hasMoreElements()) {
            views.add((IlvManagerView)e.nextElement());
        }
        return views;
    }

    public static void assignViewsToNewManager(IlvManager mgr, Collection<IlvManagerView> views) {
        for (IlvManagerView view : views) {
            ArrayList<IlvManagerViewInteractor> interactors = new ArrayList<IlvManagerViewInteractor>();
            while (view.getInteractor() != null) {
                interactors.add(view.popInteractor());
            }
            view.setManager(mgr);
            for (int i = interactors.size() - 1; i >= 0; --i) {
                view.pushInteractor((IlvManagerViewInteractor)interactors.get(i));
            }
        }
    }

    public static void saveAndSetLayerVisibility(IlvManagerView view, IlvManager manager, int layerIndex, boolean state, boolean redraw) {
        boolean layerVisibleState;
        if (manager == null || view == null) {
            throw new IllegalArgumentException("view or manager is null");
        }
        if (!manager.isVisible() && manager.isCollapsed()) {
            return;
        }
        IlvGraphicEnumeration managers = manager.getManagers();
        while (managers.hasMoreElements()) {
            IlvManager childManager = (IlvManager)managers.nextElement();
            ManagerUtil.saveAndSetLayerVisibility(view, childManager, layerIndex, state, redraw);
        }
        IlvManagerLayer layer = manager.getManagerLayer(layerIndex);
        if (layer != null && (layerVisibleState = layer.isVisible(view)) != state) {
            HashMap<IlvManagerView, Boolean> managerLayerVisMap = (HashMap<IlvManagerView, Boolean>)layer.getProperty(SELECTION_LAYER_STATE);
            if (managerLayerVisMap == null) {
                managerLayerVisMap = new HashMap<IlvManagerView, Boolean>();
                layer.setProperty(SELECTION_LAYER_STATE, managerLayerVisMap);
            }
            managerLayerVisMap.put(view, layerVisibleState);
            manager.setVisible(view, layerIndex, state, redraw);
        }
    }

    public static void restoreLayerVisibility(IlvManagerView view, IlvManager manager, int layerIndex, boolean state, boolean redraw) {
        Boolean savedVisState;
        Map managerLayerVisMap;
        if (manager == null || view == null) {
            throw new IllegalArgumentException("view or manager is null");
        }
        if (!manager.isVisible() && manager.isCollapsed()) {
            return;
        }
        IlvGraphicEnumeration managers = manager.getManagers();
        while (managers.hasMoreElements()) {
            IlvManager childManager = (IlvManager)managers.nextElement();
            ManagerUtil.restoreLayerVisibility(view, childManager, layerIndex, state, redraw);
        }
        IlvManagerLayer layer = manager.getManagerLayer(layerIndex);
        if (layer != null && (managerLayerVisMap = (Map)layer.getProperty(SELECTION_LAYER_STATE)) != null && (savedVisState = (Boolean)managerLayerVisMap.get(view)) != null) {
            manager.setVisible(view, layerIndex, savedVisState.booleanValue(), redraw);
            managerLayerVisMap.remove(view);
            if (managerLayerVisMap.size() == 0) {
                layer.setProperty(SELECTION_LAYER_STATE, null);
            }
        }
    }

    public static void setLayerVisibilityFilter(IlvLayerVisibilityFilter filter, IlvManager manager, boolean onlyToVisibleManagers, boolean onlyToExpandedManagers) {
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("manager is null");
        }
        if (onlyToVisibleManagers && !manager.isVisible() || onlyToExpandedManagers && manager.isCollapsed()) {
            return;
        }
        IlvGraphicEnumeration managers = manager.getManagers();
        while (managers.hasMoreElements()) {
            IlvManager childManager = (IlvManager)managers.nextElement();
            ManagerUtil.setLayerVisibilityFilter(filter, childManager, onlyToVisibleManagers, onlyToExpandedManagers);
        }
        int numLayers = manager.getLayersCount();
        for (int i = 0; i <= numLayers; ++i) {
            IlvManagerLayer layer = manager.getManagerLayer(i);
            if (layer == null) continue;
            layer.addVisibilityFilter(filter);
        }
    }

    public static void removeLayerVisibilityFilter(IlvLayerVisibilityFilter filter, IlvManager manager) {
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("manager is null");
        }
        IlvGraphicEnumeration managers = manager.getManagers();
        while (managers.hasMoreElements()) {
            IlvManager childManager = (IlvManager)managers.nextElement();
            ManagerUtil.removeLayerVisibilityFilter(filter, childManager);
        }
        int numLayers = manager.getLayersCount();
        for (int i = 0; i <= numLayers; ++i) {
            IlvManagerLayer layer = manager.getManagerLayer(i);
            if (layer == null) continue;
            layer.removeVisibilityFilter(filter);
        }
    }

    public static IlvRect calcEnclosingRectangle(IlvManager mgr, Collection<IlvGraphic> graphics) {
        IlvRect enclosure = new IlvRect(0.0f, 0.0f, 0.0f, 0.0f);
        for (IlvGraphic graphic : graphics) {
            if (!mgr.isManaged(graphic)) continue;
            IlvRect b = graphic.boundingBox();
            enclosure.add(b);
        }
        return enclosure;
    }
}

