/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.link.policy;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.linkconnector.IlvShapePath;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import oracle.diagram.framework.link.LinkUtil;
import oracle.diagram.framework.link.policy.DiagramFrameworkLinkPolicy;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.transformer.TransformerUtil;

public class ProportionalAttachmentLinkPolicy
extends DiagramFrameworkLinkPolicy {
    public void afterAdd(IlvLinkImage link) {
        if (this.isPolicyEnabled(link) && this.isJustCreated(link)) {
            if (link.getGraphicBag() != null) {
                link.getGraphicBag().applyToObject((IlvGraphic)link, new IlvApplyObject(){

                    public void apply(IlvGraphic graphic, Object obj) {
                        ProportionalAttachmentLinkPolicy.this.initPolicy((IlvLinkImage)graphic, false);
                    }
                }, null, true);
            } else {
                this.initPolicy(link, false);
            }
        }
        super.afterAdd(link);
    }

    public void onInstall(IlvLinkImage link) {
        if (this.isPolicyEnabled(link) && this.isJustCreated(link)) {
            this.initPolicy(link, false);
        }
        super.onInstall(link);
    }

    public void onUninstall(IlvLinkImage link) {
        super.onUninstall(link);
    }

    public void afterFromNodeMoved(IlvLinkImage link) {
        System.out.println("afterFromNodeMoved called");
        this.nodeMoved(link, true);
        super.afterFromNodeMoved(link);
    }

    public void afterToNodeMoved(IlvLinkImage link) {
        System.out.println("afterToNodeMoved called");
        this.nodeMoved(link, false);
        super.afterToNodeMoved(link);
    }

    @Override
    public void invoke(IlvLinkImage link) {
        this.initPolicy(link, true);
    }

    private void nodeMoved(IlvLinkImage link, boolean origin) {
        if (link.getFrom().getGraphicBag() == null || link.getTo().getGraphicBag() == null) {
            return;
        }
        if (ManagerUtil.isSelectedOrParentSelected(origin ? link.getTo() : link.getFrom())) {
            return;
        }
        Object[] points = LinkUtil.getLinkPointsUnclipped(link, TransformerUtil.IDENTITY_TRANSFORMER);
        int nbPoints = points.length;
        IlvRect fromBox = link.getFromBoundingBox(TransformerUtil.IDENTITY_TRANSFORMER);
        IlvRect toBox = link.getToBoundingBox(TransformerUtil.IDENTITY_TRANSFORMER);
        boolean isHorizontalToOriginBox = LinkUtil.isHorizontalToRectangle(points[0], fromBox);
        boolean isHorizontalToDestinationBox = LinkUtil.isHorizontalToRectangle(points[nbPoints - 1], toBox);
        boolean pointsUpdated = false;
        if (nbPoints == 2) {
            if (!LinkUtil.isLinkOrthogonal((IlvPoint[])points)) {
                pointsUpdated = true;
            }
        } else {
            if (origin && isHorizontalToOriginBox || !origin && isHorizontalToDestinationBox) {
                points[origin ? 1 : nbPoints - 2].y = points[origin ? 0 : nbPoints - 1].y;
            } else {
                points[origin ? 1 : nbPoints - 2].x = points[origin ? 0 : nbPoints - 1].x;
            }
            pointsUpdated = true;
        }
        if (pointsUpdated) {
            IlvPoint[] newPoints;
            IlvPoint[] initialEdge;
            IlvPoint[] truncatedPoints;
            IlvRect oRect = link.getFromBoundingBox(TransformerUtil.IDENTITY_TRANSFORMER);
            IlvRect dRect = link.getToBoundingBox(TransformerUtil.IDENTITY_TRANSFORMER);
            IlvTransformer oTrans = new IlvTransformer();
            oTrans.postCompose(link.getFromTransformer(TransformerUtil.IDENTITY_TRANSFORMER));
            PathIterator oPathIte = link.getFrom() instanceof IlvShapePath ? ((IlvShapePath)link.getFrom()).getShapePath(oTrans) : fromBox.getPathIterator(new AffineTransform());
            IlvTransformer dTrans = new IlvTransformer();
            dTrans.postCompose(link.getToTransformer(TransformerUtil.IDENTITY_TRANSFORMER));
            PathIterator dPathIte = link.getTo() instanceof IlvShapePath ? ((IlvShapePath)link.getTo()).getShapePath(dTrans) : toBox.getPathIterator(new AffineTransform());
            GeneralPath oNodePath = new GeneralPath();
            oNodePath.append(oPathIte, false);
            GeneralPath dNodePath = new GeneralPath();
            dNodePath.append(dPathIte, false);
            if (!origin) {
                this.reverseArray(points);
            }
            if ((truncatedPoints = this.nodeMovedTruncate((IlvPoint[])points, origin ? oNodePath : dNodePath, origin ? oRect : dRect)).length != points.length) {
                points = truncatedPoints;
            }
            this.reverseArray(points);
            truncatedPoints = this.nodeMovedTruncate((IlvPoint[])points, origin ? dNodePath : oNodePath, origin ? dRect : oRect);
            if (truncatedPoints.length != points.length) {
                points = truncatedPoints;
            }
            if (origin) {
                this.reverseArray(points);
            }
            if ((initialEdge = this.initialEdgeShape(link, (IlvPoint[])points, 0)) != null) {
                pointsUpdated = true;
                points = initialEdge;
            }
            if (pointsUpdated && (newPoints = this.massageEdgeClosePoints((IlvPoint[])points)) != null) {
                pointsUpdated = true;
                points = newPoints;
            }
            LinkUtil.updatePoints(link, (IlvPoint[])points, points.length);
        }
    }

    private IlvPoint[] nodeMovedTruncate(IlvPoint[] points, GeneralPath nodePath, IlvRect nodeRect) {
        IlvPoint interPt = null;
        int interPos = 1;
        for (int i = points.length - 1; i > 0 && interPt == null; --i) {
            float estimatedX;
            IlvPoint centerP;
            IlvPoint controlPt;
            float estimatedY;
            interPt = LinkUtil.getClosestIntersectionPoint(points[i], points[i - 1], nodePath.getPathIterator(new AffineTransform()));
            float lowX = points[i - 1].x <= points[i].x ? points[i - 1].x : points[i].x;
            float highX = points[i - 1].x <= points[i].x ? points[i].x : points[i - 1].x;
            float lowY = points[i - 1].y <= points[i].y ? points[i - 1].y : points[i].y;
            float highY = points[i - 1].y <= points[i].y ? points[i].y : points[i - 1].y;
            if (!(interPt == null || (lowX -= ERROR_TOLERANCE) <= interPt.x && interPt.x <= (highX += ERROR_TOLERANCE) && (lowY -= ERROR_TOLERANCE) <= interPt.y && interPt.y <= (highY += ERROR_TOLERANCE) || i <= 1)) {
                interPt = null;
            }
            if (interPt == null) continue;
            interPos = i;
            int attachRectPos = LinkUtil.getRelativePosToRectangle(points[0], nodeRect);
            float percentLeft = (points[0].x - nodeRect.x) / nodeRect.width;
            float percentTop = (points[0].y - nodeRect.y) / nodeRect.height;
            if (attachRectPos == 4 && interPt.x <= points[0].x || attachRectPos == 8 && interPt.x >= points[0].x) {
                estimatedY = nodeRect.y + nodeRect.height * (1.0f - percentLeft);
                controlPt = new IlvPoint(interPt.x, estimatedY);
                centerP = new IlvPoint((float)nodeRect.getCenterX(), (float)nodeRect.getCenterY());
                interPt = LinkUtil.getClosestIntersectionPoint(controlPt, centerP, nodePath.getPathIterator(new AffineTransform()));
                continue;
            }
            if (attachRectPos == 4 && interPt.x > points[0].x || attachRectPos == 8 && interPt.x < points[0].x) {
                estimatedY = nodeRect.y + nodeRect.height * percentLeft;
                controlPt = new IlvPoint(interPt.x, estimatedY);
                centerP = new IlvPoint((float)nodeRect.getCenterX(), (float)nodeRect.getCenterY());
                interPt = LinkUtil.getClosestIntersectionPoint(controlPt, centerP, nodePath.getPathIterator(new AffineTransform()));
                continue;
            }
            if (attachRectPos == 2 && interPt.y >= points[0].y || attachRectPos == 1 && interPt.y <= points[0].y) {
                estimatedX = nodeRect.x + nodeRect.width * percentTop;
                controlPt = new IlvPoint(estimatedX, interPt.y);
                centerP = new IlvPoint((float)nodeRect.getCenterX(), (float)nodeRect.getCenterY());
                interPt = LinkUtil.getClosestIntersectionPoint(controlPt, centerP, nodePath.getPathIterator(new AffineTransform()));
                continue;
            }
            if (!(attachRectPos == 2 && interPt.y < points[0].y) && (attachRectPos != 1 || !(interPt.y > points[0].y))) continue;
            estimatedX = nodeRect.x + nodeRect.width * (1.0f - percentTop);
            controlPt = new IlvPoint(estimatedX, interPt.y);
            centerP = new IlvPoint((float)nodeRect.getCenterX(), (float)nodeRect.getCenterY());
            interPt = LinkUtil.getClosestIntersectionPoint(controlPt, centerP, nodePath.getPathIterator(new AffineTransform()));
        }
        IlvPoint[] newPoints = new IlvPoint[points.length - interPos + 1];
        newPoints[0] = interPt == null ? points[0] : interPt;
        for (int j = interPos; j < points.length; ++j) {
            newPoints[j - interPos + 1] = points[j];
        }
        return newPoints;
    }

    public void afterMovePoint(IlvLinkImage link, int i, IlvTransformer trans) {
        System.out.println("afterMovePoint called");
        IlvPoint[] points = LinkUtil.getLinkPointsUnclipped(link, TransformerUtil.IDENTITY_TRANSFORMER);
        super.afterMovePoint(link, i, trans);
    }

    public boolean allowSetIntermediateLinkPoints(IlvLinkImage link, IlvPoint[] ilvPoint, int i, int i2) {
        System.out.println("allowSetIntermediateLinkPoints called");
        return super.allowSetIntermediateLinkPoints(link, ilvPoint, i, i2);
    }

    private IlvPoint[] proportionalTruncate(IlvPoint[] points, IlvLinkImage link, IlvTransformer trans) {
        ArrayList<IlvPoint> newPointList = new ArrayList<IlvPoint>();
        IlvRect fromBox = link.getFromBoundingBox(trans);
        IlvRect toBox = link.getToBoundingBox(trans);
        IlvTransformer fromTrans = new IlvTransformer();
        fromTrans.postCompose(link.getFromTransformer(trans));
        PathIterator fromPathIte = link.getFrom() instanceof IlvShapePath ? ((IlvShapePath)link.getFrom()).getShapePath(fromTrans) : fromBox.getPathIterator(new AffineTransform());
        IlvTransformer toTrans = new IlvTransformer();
        toTrans.postCompose(link.getToTransformer(trans));
        PathIterator toPathIte = link.getTo() instanceof IlvShapePath ? ((IlvShapePath)link.getTo()).getShapePath(toTrans) : toBox.getPathIterator(new AffineTransform());
        GeneralPath fromPath = new GeneralPath();
        fromPath.append(fromPathIte, false);
        GeneralPath toPath = new GeneralPath();
        toPath.append(toPathIte, false);
        IlvPoint changedFromPoint = points[0];
        IlvPoint changedToPoint = points[points.length - 1];
        int firstFromPointIndex = 1;
        int firstToPointIndex = -1;
        for (int i = 1; i < points.length && firstToPointIndex < 0; ++i) {
            IlvPoint interFromPt = LinkUtil.getClosestIntersectionPoint(points[i], points[i - 1], fromPath.getPathIterator(new AffineTransform()));
            IlvPoint interToPt = LinkUtil.getClosestIntersectionPoint(points[i - 1], points[i], toPath.getPathIterator(new AffineTransform()));
            float lowX = points[i - 1].x <= points[i].x ? points[i - 1].x : points[i].x;
            float highX = points[i - 1].x <= points[i].x ? points[i].x : points[i - 1].x;
            float lowY = points[i - 1].y <= points[i].y ? points[i - 1].y : points[i].y;
            float highY = points[i - 1].y <= points[i].y ? points[i].y : points[i - 1].y;
            if (!(interFromPt == null || (lowX -= ERROR_TOLERANCE) <= interFromPt.x && interFromPt.x <= (highX += ERROR_TOLERANCE) && (lowY -= ERROR_TOLERANCE) <= interFromPt.y && interFromPt.y <= (highY += ERROR_TOLERANCE))) {
                if (i == 1) {
                    changedFromPoint = interFromPt;
                } else {
                    interFromPt = null;
                }
            }
            if (interFromPt != null) {
                int pointRelativePos = LinkUtil.getRelativePosToRectangle(points[0], fromBox);
                switch (pointRelativePos) {
                    case 4: {
                        int interPos = LinkUtil.getRelativePosToRectangle(interFromPt, fromBox);
                    }
                }
                changedFromPoint = interFromPt;
                firstFromPointIndex = i;
            }
            float lowXTo = points[i - 1].x <= points[i].x ? points[i - 1].x : points[i].x;
            float highXTo = points[i - 1].x <= points[i].x ? points[i].x : points[i - 1].x;
            float lowYTo = points[i - 1].y <= points[i].y ? points[i - 1].y : points[i].y;
            float highYTo = points[i - 1].y <= points[i].y ? points[i].y : points[i - 1].y;
            if (!(interToPt == null || (lowXTo -= ERROR_TOLERANCE) <= interToPt.x && interToPt.x <= (highXTo += ERROR_TOLERANCE) && (lowYTo -= ERROR_TOLERANCE) <= interToPt.y && interToPt.y <= (highYTo += ERROR_TOLERANCE))) {
                if (i == points.length - 1) {
                    changedToPoint = interToPt;
                } else {
                    interToPt = null;
                }
            }
            if (interToPt == null) continue;
            changedToPoint = interToPt;
            firstToPointIndex = i;
        }
        newPointList.add(changedFromPoint);
        for (int j = firstFromPointIndex; j < firstToPointIndex; ++j) {
            newPointList.add(points[j]);
        }
        newPointList.add(changedToPoint);
        return newPointList.toArray(new IlvPoint[newPointList.size()]);
    }

    @Override
    protected IlvPoint[] truncateLink(IlvPoint[] points, IlvLinkImage link, IlvTransformer trans, float errorTolerance) {
        return LinkUtil.truncateLink(points, link, trans, errorTolerance);
    }

    void reverseArray(Object[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            Object temp = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = temp;
        }
    }
}

