/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.link.policy;

import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvAbstractLinkShapePolicy;
import ilog.views.linkconnector.IlvShapePath;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import oracle.diagram.framework.graphic.FakeNode;
import oracle.diagram.framework.link.LinkUtil;
import oracle.diagram.framework.link.policy.InvokablePolicy;
import oracle.diagram.framework.transformer.TransformerUtil;
import oracle.diagram.logging.AlertMessage;
import oracle.diagram.logging.DiagramLogPage;
import oracle.diagram.logging.EmphasizedMessage;

public abstract class DiagramFrameworkLinkPolicy
extends IlvAbstractLinkShapePolicy
implements InvokablePolicy {
    public static final String ENABLED_PROP = "Enabled";
    public static final String JUST_CREATED = "JustCreated";
    protected static float ERROR_TOLERANCE = 1.0f;
    protected static float POINTS_PROXIMITY_TOLERANCE = 10.0f;
    protected static float PIGS_EAR_DISTANCE = 50.0f;
    protected static float STRAIGHT_LINE_CREATION_THRESHOLD = 15.0f;
    protected boolean _updatingState = false;

    protected boolean isPolicyEnabled(IlvLinkImage link) {
        Boolean enabled = (Boolean)link.getProperty(ENABLED_PROP);
        return enabled == null || enabled != false;
    }

    protected boolean isJustCreated(IlvLinkImage link) {
        Boolean justCreated = (Boolean)link.getProperty(JUST_CREATED);
        return justCreated != null && justCreated != false;
    }

    protected void initPolicy(IlvLinkImage link, boolean triggered) {
        this.initPolicy(link, 0, triggered);
    }

    protected void initPolicy(IlvLinkImage link, int orthoSeed, boolean triggered) {
        IlvPoint[] newPoints;
        if (!this.isPolicyEnabled(link) || this._updatingState) {
            return;
        }
        if (link == null || link.getGraphicBag() == null) {
            return;
        }
        if (link.getFrom() instanceof FakeNode || link.getTo() instanceof FakeNode) {
            return;
        }
        if (link.getFrom().getGraphicBag() == null || link.getTo().getGraphicBag() == null) {
            return;
        }
        IlvPoint[] points = LinkUtil.getLinkPointsUnclipped(link, TransformerUtil.IDENTITY_TRANSFORMER);
        boolean pointsUpdated = false;
        IlvPoint[] initialEdge = this.initialEdgeShape(link, points, orthoSeed);
        if (initialEdge != null) {
            pointsUpdated = true;
            points = initialEdge;
        }
        if ((pointsUpdated || triggered) && (newPoints = this.massageEdgeClosePoints(points)) != null) {
            pointsUpdated = true;
            points = newPoints;
        }
        IlvPoint[] truncatedLink = points;
        if (!link.getFrom().equals(link.getTo())) {
            truncatedLink = this.truncateLink(points, link, TransformerUtil.IDENTITY_TRANSFORMER, ERROR_TOLERANCE);
        }
        points = truncatedLink;
        pointsUpdated = true;
        if (pointsUpdated) {
            this._updatingState = true;
            LinkUtil.updatePointsWithApply(link, points, points.length);
            this._updatingState = false;
        }
    }

    protected IlvPoint[] initialEdgeShape(IlvLinkImage link, IlvPoint[] points, int orthoSeed) {
        int nbPoints = points.length;
        IlvPoint[] edgePoints = points;
        IlvRect fromBox = link.getFromBoundingBox(TransformerUtil.IDENTITY_TRANSFORMER);
        IlvRect toBox = link.getToBoundingBox(TransformerUtil.IDENTITY_TRANSFORMER);
        boolean isHorizontalToOriginBox = LinkUtil.isHorizontalToRectangle(points[0], fromBox);
        boolean isHorizontalToDestinationBox = LinkUtil.isHorizontalToRectangle(points[nbPoints - 1], toBox);
        boolean pointsUpdated = false;
        if (link.getFrom().equals(link.getTo())) {
            edgePoints = this.initialEdgeShapeForPigsEar(link, points);
            nbPoints = edgePoints.length;
            pointsUpdated = true;
        } else if (isHorizontalToOriginBox == isHorizontalToDestinationBox) {
            IlvPoint[] newPoints;
            if (nbPoints == 2) {
                if (points[0].x == points[1].x) {
                    return null;
                }
                if (points[0].y == points[1].y) {
                    return null;
                }
                newPoints = null;
                if (this.isJustCreated(link) && (Math.abs(points[0].x - points[1].x) < STRAIGHT_LINE_CREATION_THRESHOLD || Math.abs(points[0].y - points[1].y) < STRAIGHT_LINE_CREATION_THRESHOLD)) {
                    newPoints = LinkUtil.fetchStraightLine(link);
                }
                if (newPoints == null) {
                    newPoints = new IlvPoint[4];
                    newPoints[0] = points[0];
                    if (isHorizontalToOriginBox) {
                        float newX = 0.0f;
                        newX = points[0].x <= points[1].x ? 0.5f * (fromBox.x + fromBox.width + toBox.x) : 0.5f * (toBox.x + toBox.width + fromBox.x);
                        newPoints[1] = new IlvPoint(newX, points[0].y);
                        newPoints[2] = new IlvPoint(newX, points[1].y);
                    } else {
                        float newY = 0.0f;
                        newY = points[0].y <= points[1].y ? 0.5f * (fromBox.y + fromBox.height + toBox.y) : 0.5f * (toBox.y + toBox.height + fromBox.y);
                        newPoints[1] = new IlvPoint(points[0].x, newY);
                        newPoints[2] = new IlvPoint(points[1].x, newY);
                    }
                    newPoints[3] = points[1];
                }
                edgePoints = newPoints;
                nbPoints = newPoints.length;
                pointsUpdated = true;
            } else if (nbPoints % 2 == 1) {
                newPoints = new IlvPoint[nbPoints + 1];
                for (int j = 0; j < nbPoints - 1; ++j) {
                    newPoints[j] = points[j];
                }
                newPoints[nbPoints - 1] = new IlvPoint(newPoints[nbPoints - 2]);
                newPoints[nbPoints] = points[nbPoints - 1];
                edgePoints = newPoints;
                ++nbPoints;
                pointsUpdated = true;
            }
        } else if (nbPoints % 2 == 0) {
            IlvPoint[] ailvpoint3 = new IlvPoint[nbPoints + 1];
            for (int k = 0; k < nbPoints - 1; ++k) {
                ailvpoint3[k] = points[k];
            }
            ailvpoint3[nbPoints - 1] = new IlvPoint(ailvpoint3[nbPoints - 2]);
            ailvpoint3[nbPoints] = points[nbPoints - 1];
            edgePoints = ailvpoint3;
            ++nbPoints;
            pointsUpdated = true;
        }
        if (pointsUpdated || !LinkUtil.isLinkOrthogonal(edgePoints)) {
            boolean hFlag = LinkUtil.isHorizontalRelativeToPoint(points[1], points[0]);
            for (int ind = 1; ind < nbPoints - 1; ++ind) {
                if (ind == orthoSeed && orthoSeed > 1) {
                    if (hFlag) {
                        edgePoints[ind - 1].y = edgePoints[ind].y;
                    } else {
                        edgePoints[ind - 1].x = edgePoints[ind].x;
                    }
                } else if (hFlag) {
                    edgePoints[ind].y = edgePoints[ind - 1].y;
                } else {
                    edgePoints[ind].x = edgePoints[ind - 1].x;
                }
                hFlag = !hFlag;
            }
            if (hFlag) {
                edgePoints[nbPoints - 2].y = edgePoints[nbPoints - 1].y;
            } else {
                edgePoints[nbPoints - 2].x = edgePoints[nbPoints - 1].x;
            }
            pointsUpdated = true;
        }
        return pointsUpdated ? edgePoints : null;
    }

    protected IlvPoint[] initialEdgeShapeForPigsEar(IlvLinkImage link, IlvPoint[] points) {
        IlvRect fromBox = link.getFromBoundingBox(TransformerUtil.IDENTITY_TRANSFORMER);
        IlvPoint[] edgePoints = points;
        IlvTransformer fromTrans = new IlvTransformer();
        fromTrans.postCompose(link.getFromTransformer(TransformerUtil.IDENTITY_TRANSFORMER));
        PathIterator fromPathIte = link.getFrom() instanceof IlvShapePath ? ((IlvShapePath)link.getFrom()).getShapePath(fromTrans) : fromBox.getPathIterator(new AffineTransform());
        GeneralPath fromPath = new GeneralPath();
        fromPath.append(fromPathIte, false);
        if (LinkUtil.isLinkEntirelyInShape(fromPath, points)) {
            int originPos = LinkUtil.getRelativePosToRectangle(points[0], fromBox);
            if (points.length != 4) {
                edgePoints = new IlvPoint[5];
                edgePoints[0] = points[0];
                edgePoints[4] = points[1];
                float rectCenterX = (float)fromBox.getCenterX();
                float rectCenterY = (float)fromBox.getCenterY();
                switch (originPos) {
                    case 1: {
                        edgePoints[1] = new IlvPoint(fromBox.x - PIGS_EAR_DISTANCE, edgePoints[0].y);
                        edgePoints[2] = points[1].y < rectCenterY ? new IlvPoint(edgePoints[1].x, fromBox.y - PIGS_EAR_DISTANCE) : new IlvPoint(edgePoints[1].x, fromBox.y + fromBox.height + PIGS_EAR_DISTANCE);
                        edgePoints[3] = new IlvPoint(edgePoints[4].x, edgePoints[2].y);
                        break;
                    }
                    case 2: {
                        edgePoints[1] = new IlvPoint(fromBox.x + fromBox.width + PIGS_EAR_DISTANCE, edgePoints[0].y);
                        edgePoints[2] = points[1].y < rectCenterY ? new IlvPoint(edgePoints[1].x, fromBox.y - PIGS_EAR_DISTANCE) : new IlvPoint(edgePoints[1].x, fromBox.y + fromBox.height + PIGS_EAR_DISTANCE);
                        edgePoints[3] = new IlvPoint(edgePoints[4].x, edgePoints[2].y);
                        break;
                    }
                    case 4: {
                        edgePoints[1] = new IlvPoint(edgePoints[0].x, fromBox.y - PIGS_EAR_DISTANCE);
                        edgePoints[2] = points[1].x < rectCenterX ? new IlvPoint(fromBox.x - PIGS_EAR_DISTANCE, edgePoints[1].y) : new IlvPoint(fromBox.x + fromBox.width + PIGS_EAR_DISTANCE, edgePoints[1].y);
                        edgePoints[3] = new IlvPoint(edgePoints[2].x, edgePoints[4].y);
                        break;
                    }
                    case 8: {
                        edgePoints[1] = new IlvPoint(edgePoints[0].x, fromBox.y + fromBox.height + PIGS_EAR_DISTANCE);
                        edgePoints[2] = points[1].x < rectCenterX ? new IlvPoint(fromBox.x - PIGS_EAR_DISTANCE, edgePoints[1].y) : new IlvPoint(fromBox.x + fromBox.width + PIGS_EAR_DISTANCE, edgePoints[1].y);
                        edgePoints[3] = new IlvPoint(edgePoints[2].x, edgePoints[4].y);
                    }
                }
            } else {
                IlvPoint[] cPoints = link.getLinkPoints(TransformerUtil.IDENTITY_TRANSFORMER);
                int cOriginPos = LinkUtil.getRelativePosToRectangle(cPoints[0], fromBox);
                edgePoints = new IlvPoint[4];
                edgePoints[0] = cPoints[0];
                edgePoints[3] = cPoints[3];
                switch (cOriginPos) {
                    case 1: {
                        edgePoints[1] = new IlvPoint(fromBox.x - PIGS_EAR_DISTANCE, edgePoints[0].y);
                        edgePoints[2] = new IlvPoint(edgePoints[1].x, edgePoints[3].y);
                        break;
                    }
                    case 2: {
                        edgePoints[1] = new IlvPoint(fromBox.x + fromBox.width + PIGS_EAR_DISTANCE, edgePoints[0].y);
                        edgePoints[2] = new IlvPoint(edgePoints[1].x, edgePoints[3].y);
                        break;
                    }
                    case 4: {
                        edgePoints[1] = new IlvPoint(edgePoints[0].x, fromBox.y - PIGS_EAR_DISTANCE);
                        edgePoints[2] = new IlvPoint(edgePoints[3].x, edgePoints[1].y);
                        break;
                    }
                    case 8: {
                        edgePoints[1] = new IlvPoint(edgePoints[0].x, fromBox.y + fromBox.height + PIGS_EAR_DISTANCE);
                        edgePoints[2] = new IlvPoint(edgePoints[3].x, edgePoints[1].y);
                    }
                }
            }
        }
        return edgePoints;
    }

    protected IlvPoint[] massageEdgeClosePoints(IlvPoint[] points) {
        IlvPoint[] cleanOne = LinkUtil.cleanLinkFromCycles(points);
        return cleanOne;
    }

    protected abstract IlvPoint[] truncateLink(IlvPoint[] var1, IlvLinkImage var2, IlvTransformer var3, float var4);

    protected void logInfo(IlvLinkImage link, IlvPoint[] points, String message) {
        DiagramLogPage msgPage = DiagramLogPage.makeDiagramLogPage();
        IlvRect fromBox = link.getFromBoundingBox(TransformerUtil.IDENTITY_TRANSFORMER);
        IlvRect toBox = link.getToBoundingBox(TransformerUtil.IDENTITY_TRANSFORMER);
        msgPage.log((Object)new EmphasizedMessage("--- Starting Info: " + message + " ---\n"));
        msgPage.log("From Box: x=" + fromBox.x + ", y=" + fromBox.y + ", width=" + fromBox.width + ", height=" + fromBox.height + "\n");
        msgPage.log("To Box: x=" + toBox.x + ", y=" + toBox.y + ", width=" + toBox.width + ", height=" + toBox.height + "\n");
        if (points.length > 0) {
            for (IlvPoint p : points) {
                msgPage.log("[" + p.x + "," + p.y + "]\n");
            }
            if (!DiagramFrameworkLinkPolicy.nonstrictContains((Rectangle2D)fromBox, (Point2D)points[0])) {
                msgPage.log((Object)new AlertMessage("ALERT ---- source point is out of From Box ---- delta=[" + (points[0].x - fromBox.x) + "," + (points[0].y - fromBox.y) + "]\n"));
            }
            if (!DiagramFrameworkLinkPolicy.nonstrictContains((Rectangle2D)toBox, (Point2D)points[points.length - 1])) {
                msgPage.log((Object)new AlertMessage("ALERT ---- destination point is out of To Box ---- delta=[" + (points[points.length - 1].x - toBox.x) + "," + (points[points.length - 1].y - toBox.y) + "]\n"));
            }
        } else {
            msgPage.log((Object)new AlertMessage("ALERT ----- POINTS IS EMPTY -----\n"));
        }
        msgPage.log((Object)new EmphasizedMessage("--- Ending Info: " + message + " ---\n"));
    }

    protected static boolean nonstrictContains(Rectangle2D rect, Point2D p) {
        boolean contains = true;
        if (p.getX() < rect.getX() || p.getX() > rect.getX() + rect.getWidth() || p.getY() < rect.getY() || p.getY() > rect.getY() + rect.getHeight()) {
            contains = false;
        }
        return contains;
    }
}

