/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.link.policy;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvAbstractLinkShapePolicy;
import ilog.views.linkconnector.IlvClippingLinkConnector;
import ilog.views.linkconnector.IlvShapePath;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import oracle.diagram.framework.graphic.FakeNode;
import oracle.diagram.framework.link.LinkUtil;
import oracle.diagram.framework.transformer.TransformerUtil;

public class ClippedOrthogonalLinkShapePolicy
extends IlvAbstractLinkShapePolicy {
    private IlvPoint[] _endPoints = new IlvPoint[2];
    private float _minFinalSegmentLength = 5.0f;
    private float _BendDeltaOnStraightLink = 2.0f;
    private float _deltaAlignement = 2.0f;

    public void setMinFinalSegmentLength(float f) {
        this._minFinalSegmentLength = f;
    }

    public float setMinFinalSegmentLength() {
        return this._minFinalSegmentLength;
    }

    public void setBendDeltaOnStraightLink(float f) {
        this._BendDeltaOnStraightLink = f;
    }

    public float getBendDeltaOnStraightLink() {
        return this._BendDeltaOnStraightLink;
    }

    public void afterAdd(IlvLinkImage ilvlinkimage) {
        if (ilvlinkimage.getGraphicBag() != null) {
            ilvlinkimage.getGraphicBag().applyToObject((IlvGraphic)ilvlinkimage, new IlvApplyObject(){

                public void apply(IlvGraphic ilvgraphic, Object obj) {
                    ClippedOrthogonalLinkShapePolicy.staticInitPolicy(ClippedOrthogonalLinkShapePolicy.this, (IlvLinkImage)ilvgraphic);
                }
            }, null, true);
        } else {
            this.initPolicy(ilvlinkimage);
        }
        super.afterAdd(ilvlinkimage);
    }

    public void onInstall(IlvLinkImage ilvlinkimage) {
        this.initPolicy(ilvlinkimage);
        super.onInstall(ilvlinkimage);
    }

    public void afterApplyTransform(IlvLinkImage ilvlinkimage, IlvTransformer ilvtransformer) {
        this.initPolicy(ilvlinkimage);
        super.afterApplyTransform(ilvlinkimage, ilvtransformer);
    }

    public void afterSetIntermediateLinkPoints(IlvLinkImage ilvlinkimage) {
        this.initPolicy(ilvlinkimage);
        super.afterSetIntermediateLinkPoints(ilvlinkimage);
    }

    public void afterInsertPoint(IlvLinkImage ilvlinkimage, int i, IlvTransformer ilvtransformer) {
        this.recalcAfterInsertPoint(ilvlinkimage, i, ilvtransformer);
        super.afterInsertPoint(ilvlinkimage, i, ilvtransformer);
    }

    public boolean allowRemovePoint(IlvLinkImage ilvlinkimage, int i, IlvTransformer ilvtransformer) {
        int nbPoints = ilvlinkimage.getPointsCardinal();
        if (i == 0 || i == nbPoints - 1 || nbPoints <= 3) {
            return false;
        }
        if (nbPoints == 4) {
            IlvPoint[] ailvpoint = ilvlinkimage.getLinkPoints(null);
            return ailvpoint[1].equals((Object)ailvpoint[2]);
        }
        return super.allowRemovePoint(ilvlinkimage, i, ilvtransformer);
    }

    public void afterRemovePoint(IlvLinkImage ilvlinkimage, int i, IlvTransformer ilvtransformer) {
        this.recalcAfterRemovePoint(ilvlinkimage, i, ilvtransformer);
        super.afterRemovePoint(ilvlinkimage, i, ilvtransformer);
    }

    public boolean allowMovePoint(IlvLinkImage ilvlinkimage, int i, float f, float f1, IlvTransformer ilvtransformer) {
        int nbPoints = ilvlinkimage.getPointsCardinal();
        if (nbPoints == 3 && i == 1) {
            return false;
        }
        return super.allowMovePoint(ilvlinkimage, i, f, f1, ilvtransformer);
    }

    public void afterMovePoint(IlvLinkImage ilvlinkimage, int ptIndex, IlvTransformer ilvtransformer) {
        int nbPoints = ilvlinkimage.getPointsCardinal();
        if (ilvlinkimage.zoomable()) {
            ilvtransformer = null;
        }
        if (!this.hasCorrectNumberOfPoints(ilvlinkimage, ilvtransformer)) {
            if (nbPoints % 2 == 0 || nbPoints < 4) {
                int k = ptIndex >= nbPoints - 1 ? ptIndex - 1 : ptIndex + 1;
                IlvPoint ilvpoint = ilvlinkimage.getPointAt(k, ilvtransformer);
                this.insertPointInLink(ilvlinkimage, k, ilvpoint.x, ilvpoint.y, ilvtransformer);
            } else {
                int l = ptIndex >= nbPoints - 2 ? ptIndex - 1 : ptIndex + 1;
                ilvlinkimage.removePoint(l, ilvtransformer);
            }
            this.initPolicy(ilvlinkimage);
            return;
        }
        if (ptIndex == 0) {
            this.recalcPointsAfterMove(ilvlinkimage, true, TransformerUtil.IDENTITY_TRANSFORMER);
        } else if (ptIndex == nbPoints - 1) {
            this.recalcPointsAfterMove(ilvlinkimage, false, TransformerUtil.IDENTITY_TRANSFORMER);
        } else {
            this.updateIntermediatePoint(ilvlinkimage, ptIndex, ilvtransformer);
        }
        super.afterMovePoint(ilvlinkimage, ptIndex, ilvtransformer);
    }

    public void afterFromNodeMoved(IlvLinkImage ilvlinkimage) {
        this.recalcPointsAfterMove(ilvlinkimage, true, TransformerUtil.IDENTITY_TRANSFORMER);
        super.afterFromNodeMoved(ilvlinkimage);
    }

    public void afterToNodeMoved(IlvLinkImage ilvlinkimage) {
        this.recalcPointsAfterMove(ilvlinkimage, false, TransformerUtil.IDENTITY_TRANSFORMER);
        super.afterToNodeMoved(ilvlinkimage);
    }

    public IlvPoint[] getLinkPoints(IlvLinkImage ilvlinkimage, IlvTransformer ilvtransformer) {
        IlvPoint[] ailvpoint = ilvlinkimage.getLinkPoints(ilvtransformer);
        float closeTolerance = 3.0f;
        int nbPoints = ailvpoint.length;
        boolean changedOrigin = false;
        boolean changedDestination = false;
        if (nbPoints >= 3 && ailvpoint[nbPoints - 2].y + 3.0f > ailvpoint[nbPoints - 1].y && ailvpoint[nbPoints - 1].y > ailvpoint[nbPoints - 2].y - 3.0f && ailvpoint[nbPoints - 2].x + 3.0f > ailvpoint[nbPoints - 1].x && ailvpoint[nbPoints - 1].x > ailvpoint[nbPoints - 2].x - 3.0f) {
            changedDestination = true;
        }
        if (nbPoints >= 3 && ailvpoint[1].y + 3.0f > ailvpoint[0].y && ailvpoint[0].y > ailvpoint[1].y - 3.0f && ailvpoint[1].x + 3.0f > ailvpoint[0].x && ailvpoint[0].x > ailvpoint[1].x - 3.0f) {
            changedOrigin = true;
        }
        if (changedOrigin || changedDestination) {
            IlvPoint[] a = new IlvPoint[nbPoints - 1];
            int i = changedOrigin ? 1 : 0;
            int j = 0;
            while (i < (changedDestination ? nbPoints - 1 : nbPoints)) {
                a[j] = ailvpoint[i];
                ++i;
                ++j;
            }
            ailvpoint = a;
        }
        return ailvpoint;
    }

    public IlvPoint getPointAt(IlvLinkImage ilvlinkimage, int pointIndex, IlvTransformer ilvtransformer) {
        IlvPoint resPoint = super.getPointAt(ilvlinkimage, pointIndex, ilvtransformer);
        return resPoint;
    }

    private void recalcAfterInsertPoint(IlvLinkImage ilvlinkimage, int i, IlvTransformer ilvtransformer) {
        IlvPoint[] ailvpoint;
        int nbPoints;
        if (ilvlinkimage.zoomable()) {
            ilvtransformer = null;
        }
        if ((nbPoints = (ailvpoint = LinkUtil.getLinkPointsUnclipped(ilvlinkimage, ilvtransformer)).length) == 3) {
            IlvRect ilvrect = ilvlinkimage.getFromBoundingBox(ilvtransformer);
            float f = 0.0f;
            float f1 = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            if (ClippedOrthogonalLinkShapePolicy.isInMyRelativePosition(ilvrect, ailvpoint, 0)) {
                f = 0.25f * (ailvpoint[i + 1].x - ailvpoint[i].x);
                float f4 = ailvpoint[0].y - ailvpoint[1].y;
                if (f4 < 0.0f) {
                    f4 = -f4;
                }
                if (f4 < this._BendDeltaOnStraightLink) {
                    f3 = this._BendDeltaOnStraightLink;
                }
            } else {
                f1 = 0.25f * (ailvpoint[i + 1].y - ailvpoint[i].y);
                float f5 = ailvpoint[0].x - ailvpoint[1].x;
                if (f5 < 0.0f) {
                    f5 = -f5;
                }
                if (f5 < this._BendDeltaOnStraightLink) {
                    f2 = this._BendDeltaOnStraightLink;
                }
            }
            this.insertPointInLink(ilvlinkimage, i + 1, ailvpoint[i].x + f2, ailvpoint[i].y + f3, ilvtransformer);
            this.insertPointInLink(ilvlinkimage, i + 2, ailvpoint[i].x + f + f2, ailvpoint[i].y + f1 + f3, ilvtransformer);
            this.insertPointInLink(ilvlinkimage, i + 3, ailvpoint[i].x + f, ailvpoint[i].y + f1, ilvtransformer);
            this.updateIntermediatePoint(ilvlinkimage, i, ilvtransformer);
            this.updateIntermediatePoint(ilvlinkimage, i + 3, ilvtransformer);
        } else {
            this.insertPointInLink(ilvlinkimage, i, ailvpoint[i].x, ailvpoint[i].y, ilvtransformer);
            this.updateIntermediatePoint(ilvlinkimage, i, ilvtransformer);
            this.updateIntermediatePoint(ilvlinkimage, i + 1, ilvtransformer);
        }
        if (!this.hasCorrectNumberOfPoints(ilvlinkimage, ilvtransformer)) {
            this.initPolicy(ilvlinkimage);
        }
    }

    private void recalcAfterRemovePoint(IlvLinkImage ilvlinkimage, int i, IlvTransformer ilvtransformer) {
        int j;
        if (ilvlinkimage.zoomable()) {
            ilvtransformer = null;
        }
        if ((j = ilvlinkimage.getPointsCardinal()) == 3) {
            ilvlinkimage.removePoint(1, ilvtransformer);
        } else {
            IlvPoint[] ailvpoint = LinkUtil.getLinkPointsUnclipped(ilvlinkimage, ilvtransformer);
            IlvRect ilvrect = ilvlinkimage.getFromBoundingBox(ilvtransformer);
            if (i == 1) {
                if (ClippedOrthogonalLinkShapePolicy.isInMyRelativePosition(ilvrect, ailvpoint, i)) {
                    this.movePointInLink(ilvlinkimage, 2, ailvpoint[0].x, ailvpoint[2].y, ilvtransformer);
                } else {
                    this.movePointInLink(ilvlinkimage, 2, ailvpoint[2].x, ailvpoint[0].y, ilvtransformer);
                }
                ilvlinkimage.removePoint(1, ilvtransformer);
            } else if (i == j - 1) {
                if (ClippedOrthogonalLinkShapePolicy.isInMyRelativePosition(ilvrect, ailvpoint, i)) {
                    this.movePointInLink(ilvlinkimage, j - 3, ailvpoint[j - 3].x, ailvpoint[j - 1].y, ilvtransformer);
                } else {
                    this.movePointInLink(ilvlinkimage, j - 3, ailvpoint[j - 1].x, ailvpoint[j - 3].y, ilvtransformer);
                }
                ilvlinkimage.removePoint(j - 2, ilvtransformer);
            } else {
                if (ClippedOrthogonalLinkShapePolicy.isInMyRelativePosition(ilvrect, ailvpoint, i)) {
                    this.movePointInLink(ilvlinkimage, i - 1, ailvpoint[i].x, ailvpoint[i - 1].y, ilvtransformer);
                } else {
                    this.movePointInLink(ilvlinkimage, i - 1, ailvpoint[i - 1].x, ailvpoint[i].y, ilvtransformer);
                }
                ilvlinkimage.removePoint(i, ilvtransformer);
            }
        }
        if (!this.hasCorrectNumberOfPoints(ilvlinkimage, ilvtransformer)) {
            this.initPolicy(ilvlinkimage);
        }
    }

    private void updateIntermediatePoint(IlvLinkImage ilvlinkimage, int i, IlvTransformer ilvtransformer) {
        if (ilvlinkimage.zoomable()) {
            ilvtransformer = null;
        }
        IlvPoint[] ailvpoint = LinkUtil.getLinkPointsUnclipped(ilvlinkimage, ilvtransformer);
        IlvRect ilvrect = ilvlinkimage.getFromBoundingBox(ilvtransformer);
        int nbPoints = ailvpoint.length;
        if (ClippedOrthogonalLinkShapePolicy.isInMyRelativePosition(ilvrect, ailvpoint, i)) {
            if (i > 1) {
                this.movePointInLink(ilvlinkimage, i - 1, ailvpoint[i].x, ailvpoint[i - 1].y, ilvtransformer);
            } else {
                this.movePointInLink(ilvlinkimage, i, ailvpoint[i - 1].x, ailvpoint[i].y, ilvtransformer);
            }
            if (i < nbPoints - 2) {
                this.movePointInLink(ilvlinkimage, i + 1, ailvpoint[i + 1].x, ailvpoint[i].y, ilvtransformer);
            } else {
                this.movePointInLink(ilvlinkimage, i, ailvpoint[i].x, ailvpoint[i + 1].y, ilvtransformer);
            }
        } else {
            if (i > 1) {
                this.movePointInLink(ilvlinkimage, i - 1, ailvpoint[i - 1].x, ailvpoint[i].y, ilvtransformer);
            } else {
                this.movePointInLink(ilvlinkimage, i, ailvpoint[i].x, ailvpoint[i - 1].y, ilvtransformer);
            }
            if (i < nbPoints - 2) {
                this.movePointInLink(ilvlinkimage, i + 1, ailvpoint[i].x, ailvpoint[i + 1].y, ilvtransformer);
            } else {
                this.movePointInLink(ilvlinkimage, i, ailvpoint[i + 1].x, ailvpoint[i].y, ilvtransformer);
            }
        }
    }

    private void initPolicy(IlvLinkImage ilvlinkimage) {
        if (ilvlinkimage == null || ilvlinkimage.getGraphicBag() == null) {
            return;
        }
        if (ilvlinkimage.getFrom() instanceof FakeNode || ilvlinkimage.getTo() instanceof FakeNode) {
            return;
        }
        if (ilvlinkimage.getFrom().getGraphicBag() == null || ilvlinkimage.getTo().getGraphicBag() == null) {
            return;
        }
        IlvPoint[] ailvpoint = LinkUtil.getLinkPointsUnclipped(ilvlinkimage, TransformerUtil.IDENTITY_TRANSFORMER);
        int nbPoints = ailvpoint.length;
        IlvRect fromBox = ilvlinkimage.getFromBoundingBox(TransformerUtil.IDENTITY_TRANSFORMER);
        IlvRect toBox = ilvlinkimage.getToBoundingBox(TransformerUtil.IDENTITY_TRANSFORMER);
        boolean isHorizontalToOriginBox = LinkUtil.isHorizontalToRectangle(ailvpoint[0], fromBox);
        boolean isHorizontalToDestinationBox = LinkUtil.isHorizontalToRectangle(ailvpoint[nbPoints - 1], toBox);
        boolean pointsUpdated = false;
        if (isHorizontalToOriginBox == isHorizontalToDestinationBox) {
            if (nbPoints == 2) {
                if (ailvpoint[0].x == ailvpoint[1].x) {
                    return;
                }
                if (ailvpoint[0].y == ailvpoint[1].y) {
                    return;
                }
                IlvPoint[] ailvpoint1 = new IlvPoint[4];
                ailvpoint1[0] = ailvpoint[0];
                if (isHorizontalToOriginBox) {
                    ailvpoint1[1] = new IlvPoint(0.5f * (ailvpoint[0].x + ailvpoint[1].x), ailvpoint[0].y);
                    ailvpoint1[2] = new IlvPoint(0.5f * (ailvpoint[0].x + ailvpoint[1].x), ailvpoint[1].y);
                } else {
                    ailvpoint1[1] = new IlvPoint(ailvpoint[0].x, 0.5f * (ailvpoint[0].y + ailvpoint[1].y));
                    ailvpoint1[2] = new IlvPoint(ailvpoint[1].x, 0.5f * (ailvpoint[0].y + ailvpoint[1].y));
                }
                ailvpoint1[3] = ailvpoint[1];
                ailvpoint = ailvpoint1;
                nbPoints = 4;
                pointsUpdated = true;
            } else if (nbPoints % 2 == 1) {
                IlvPoint[] ailvpoint2 = new IlvPoint[nbPoints + 1];
                for (int j = 0; j < nbPoints - 1; ++j) {
                    ailvpoint2[j] = ailvpoint[j];
                }
                ailvpoint2[nbPoints - 1] = new IlvPoint(ailvpoint2[nbPoints - 2]);
                ailvpoint2[nbPoints] = ailvpoint[nbPoints - 1];
                ailvpoint = ailvpoint2;
                ++nbPoints;
                pointsUpdated = true;
            }
        } else if (nbPoints % 2 == 0) {
            IlvPoint[] ailvpoint3 = new IlvPoint[nbPoints + 1];
            for (int k = 0; k < nbPoints - 1; ++k) {
                ailvpoint3[k] = ailvpoint[k];
            }
            ailvpoint3[nbPoints - 1] = new IlvPoint(ailvpoint3[nbPoints - 2]);
            ailvpoint3[nbPoints] = ailvpoint[nbPoints - 1];
            ailvpoint = ailvpoint3;
            ++nbPoints;
            pointsUpdated = true;
        }
        if (pointsUpdated || !this.isLinkOrthogonal(ailvpoint, isHorizontalToOriginBox)) {
            boolean flag3 = isHorizontalToOriginBox;
            for (int l = 1; l < nbPoints - 1; ++l) {
                if (flag3) {
                    ailvpoint[l].y = ailvpoint[l - 1].y;
                } else {
                    ailvpoint[l].x = ailvpoint[l - 1].x;
                }
                flag3 = !flag3;
            }
            if (flag3) {
                ailvpoint[nbPoints - 2].y = ailvpoint[nbPoints - 1].y;
            } else {
                ailvpoint[nbPoints - 2].x = ailvpoint[nbPoints - 1].x;
            }
            pointsUpdated = true;
        }
        if (pointsUpdated) {
            LinkUtil.updatePoints(ilvlinkimage, ailvpoint, nbPoints);
        }
    }

    private boolean isLinkOrthogonal(IlvPoint[] ailvpoint, boolean flag) {
        boolean flag1 = flag;
        for (int i = 1; i < ailvpoint.length - 1; ++i) {
            if (flag1 ? ailvpoint[i].y != ailvpoint[i - 1].y : ailvpoint[i].x != ailvpoint[i - 1].x) {
                return false;
            }
            flag1 = !flag1;
        }
        return true;
    }

    private boolean hasCorrectNumberOfPoints(IlvLinkImage ilvlinkimage, IlvTransformer ilvtransformer) {
        boolean isHorizontalToDestination;
        if (ilvlinkimage == null) {
            return false;
        }
        IlvPoint[] ailvpoint = LinkUtil.getLinkPointsUnclipped(ilvlinkimage, ilvtransformer);
        int nbPoints = ailvpoint.length;
        IlvRect ilvrect = ilvlinkimage.getFromBoundingBox(ilvtransformer);
        IlvRect ilvrect1 = ilvlinkimage.getToBoundingBox(ilvtransformer);
        boolean isHorizontalToOrigin = LinkUtil.isHorizontalToRectangle(ailvpoint[0], ilvrect);
        if (isHorizontalToOrigin == (isHorizontalToDestination = LinkUtil.isHorizontalToRectangle(ailvpoint[nbPoints - 1], ilvrect1))) {
            return nbPoints % 2 == 0;
        }
        return nbPoints % 2 == 1;
    }

    private void movePointInLink(IlvLinkImage ilvlinkimage, int pointIndex, float pointX, float pointY, IlvTransformer ilvtransformer) {
        if (ilvtransformer != null && !ilvtransformer.isIdentity()) {
            IlvPoint ilvpoint = new IlvPoint(pointX, pointY);
            ilvtransformer.inverse(ilvpoint);
            ilvlinkimage.movePoint(pointIndex, ilvpoint.x, ilvpoint.y, ilvtransformer);
        } else {
            ilvlinkimage.movePoint(pointIndex, pointX, pointY, ilvtransformer);
        }
    }

    protected void insertPointInLink(IlvLinkImage linkImage, int pointIndex, float pointX, float pointY, IlvTransformer trans) {
        if (trans != null && !trans.isIdentity()) {
            IlvPoint ilvpoint = new IlvPoint(pointX, pointY);
            trans.inverse(ilvpoint);
            linkImage.insertPoint(pointIndex, ilvpoint.x, ilvpoint.y, trans);
        } else {
            linkImage.insertPoint(pointIndex, pointX, pointY, trans);
        }
    }

    private IlvPoint getOriginClippedConnection(IlvLinkImage ilvlinkimage, IlvTransformer ilvtransformer, IlvPoint ilvpoint, IlvPoint ilvpoint1) {
        IlvLinkConnector ilvlinkconnector = IlvLinkConnector.Get((IlvLinkImage)ilvlinkimage, (boolean)true);
        if (ilvlinkconnector != null && ilvlinkconnector instanceof IlvClippingLinkConnector) {
            IlvClippingLinkConnector ilvclippinglinkconnector = (IlvClippingLinkConnector)ilvlinkconnector;
            IlvGraphic ilvgraphic = ilvlinkimage.getVisibleFrom();
            IlvTransformer ilvtransformer1 = ilvlinkimage.getFromTransformer(ilvtransformer);
            return ilvclippinglinkconnector.getClippedPoint(ilvgraphic, ilvtransformer1, (Object)ilvlinkimage, ilvpoint, ilvpoint1, true);
        }
        return ilvpoint;
    }

    private IlvPoint getDestinationClippedConnection(IlvLinkImage ilvlinkimage, IlvTransformer ilvtransformer, IlvPoint ilvpoint, IlvPoint ilvpoint1) {
        IlvLinkConnector ilvlinkconnector = IlvLinkConnector.Get((IlvLinkImage)ilvlinkimage, (boolean)false);
        if (ilvlinkconnector != null && ilvlinkconnector instanceof IlvClippingLinkConnector) {
            IlvClippingLinkConnector ilvclippinglinkconnector = (IlvClippingLinkConnector)ilvlinkconnector;
            IlvGraphic ilvgraphic = ilvlinkimage.getVisibleTo();
            IlvTransformer ilvtransformer1 = ilvlinkimage.getToTransformer(ilvtransformer);
            return ilvclippinglinkconnector.getClippedPoint(ilvgraphic, ilvtransformer1, (Object)ilvlinkimage, ilvpoint, ilvpoint1, false);
        }
        return ilvpoint;
    }

    private static boolean isInMyRelativePosition(IlvRect ilvrect, IlvPoint[] ailvpoint, int i) {
        boolean flag = LinkUtil.isHorizontalToRectangle(ailvpoint[0], ilvrect);
        if (i % 2 == 0) {
            return flag;
        }
        return !flag;
    }

    protected void recalcPointsAfterMove(IlvLinkImage link, boolean origin, IlvTransformer ilvTransformer) {
        IlvPoint[] ailvpoint = LinkUtil.getLinkPointsUnclipped(link, ilvTransformer);
        int nbPoints = ailvpoint.length;
        IlvRect fromBox = link.getFromBoundingBox(ilvTransformer);
        IlvRect toBox = link.getToBoundingBox(ilvTransformer);
        IlvTransformer fromTrans = new IlvTransformer();
        fromTrans.postCompose(link.getFromTransformer(ilvTransformer));
        PathIterator fromPath = link.getFrom() instanceof IlvShapePath ? ((IlvShapePath)link.getFrom()).getShapePath(fromTrans) : fromBox.getPathIterator(new AffineTransform());
        IlvTransformer toTrans = new IlvTransformer();
        toTrans.postCompose(link.getToTransformer(ilvTransformer));
        PathIterator toPath = link.getTo() instanceof IlvShapePath ? ((IlvShapePath)link.getTo()).getShapePath(toTrans) : toBox.getPathIterator(new AffineTransform());
        int relativePosToOrigin = LinkUtil.getRelativePosToRectangle(ailvpoint[0], fromBox);
        int relativePosToDestination = LinkUtil.getRelativePosToRectangle(ailvpoint[nbPoints - 1], toBox);
        boolean isHorizontalToOriginBox = relativePosToOrigin == 1 || relativePosToOrigin == 2;
        boolean isHorizontalToDestinationBox = relativePosToDestination == 1 || relativePosToDestination == 2;
        boolean pointsUpdated = false;
        LinkPointsCalcInfo calcInfo = null;
        if (isHorizontalToDestinationBox == isHorizontalToOriginBox) {
            if (isHorizontalToOriginBox) {
                calcInfo = this.calcPointsForHHPosition(fromPath, toPath, origin, ailvpoint);
                ailvpoint = calcInfo.points;
            } else {
                pointsUpdated = this.calcPointsForVVPosition(fromPath, toPath, origin, ailvpoint);
            }
        } else {
            calcInfo = this.calcPointsForHVPosition(fromPath, toPath, origin, !isHorizontalToOriginBox, ailvpoint);
            ailvpoint = calcInfo.points;
        }
        if (pointsUpdated || calcInfo != null && calcInfo.pointsUpdated) {
            LinkUtil.updatePointsWithApply(link, ailvpoint, ailvpoint.length);
        }
    }

    protected LinkPointsCalcInfo calcPointsForHHPosition(PathIterator originPath, PathIterator destinationPath, boolean origin, IlvPoint[] ailvpoint) {
        int nbPoints = ailvpoint.length;
        LinkPointsCalcInfo pointsCalc = new LinkPointsCalcInfo();
        if (ailvpoint[nbPoints - 1].y - this._deltaAlignement <= ailvpoint[0].y && ailvpoint[0].y <= ailvpoint[nbPoints - 1].y + this._deltaAlignement) {
            IlvPoint[] newPoints = new IlvPoint[]{ailvpoint[0], ailvpoint[nbPoints - 1]};
            ailvpoint = newPoints;
            pointsCalc.points = newPoints;
            pointsCalc.pointsUpdated = true;
        } else if (nbPoints == 2) {
            if (ailvpoint[0].x == ailvpoint[1].x) {
                return pointsCalc;
            }
            if (ailvpoint[0].y == ailvpoint[1].y) {
                return pointsCalc;
            }
            IlvPoint[] ailvpoint1 = new IlvPoint[]{ailvpoint[0], new IlvPoint(0.5f * (ailvpoint[0].x + ailvpoint[1].x), ailvpoint[0].y), new IlvPoint(0.5f * (ailvpoint[0].x + ailvpoint[1].x), ailvpoint[1].y), ailvpoint[1]};
            nbPoints = 4;
            pointsCalc.points = ailvpoint1;
            pointsCalc.pointsUpdated = true;
        } else if (nbPoints >= 3) {
            IlvPoint controlPoint = ailvpoint[1];
            IlvPoint attachPoint = ailvpoint[0];
            int pointIndex = 0;
            int increment = 1;
            PathIterator shapePath = originPath;
            if (!origin) {
                controlPoint = ailvpoint[nbPoints - 2];
                attachPoint = ailvpoint[nbPoints - 1];
                pointIndex = nbPoints - 1;
                increment = -1;
                shapePath = destinationPath;
            }
            GeneralPath shape = new GeneralPath();
            shape.append(shapePath, false);
            controlPoint.y = attachPoint.y;
            if (shape.contains((Point2D)controlPoint)) {
                controlPoint = ailvpoint[(pointIndex += increment) + increment];
                attachPoint = ailvpoint[pointIndex];
                IlvPoint interPoint = LinkUtil.getClosestIntersectionPoint(controlPoint, attachPoint, shape.getPathIterator(new AffineTransform()));
                attachPoint.x = interPoint.x;
                attachPoint.y = interPoint.y;
                pointsCalc.points = ailvpoint;
                pointsCalc.pointsUpdated = true;
            } else {
                controlPoint.y = attachPoint.y;
                pointsCalc.points = ailvpoint;
                pointsCalc.pointsUpdated = true;
            }
        }
        return pointsCalc;
    }

    protected LinkPointsCalcInfo calcPointsForHVPosition(PathIterator originPath, PathIterator destinationPath, boolean origin, boolean originForX, IlvPoint[] ailvpoint) {
        int nbPoints = ailvpoint.length;
        LinkPointsCalcInfo pointsCalc = new LinkPointsCalcInfo();
        if (nbPoints == 2) {
            if (ailvpoint[0].x == ailvpoint[1].x) {
                return pointsCalc;
            }
            if (ailvpoint[0].y == ailvpoint[1].y) {
                return pointsCalc;
            }
            IlvPoint[] ailvpoint1 = new IlvPoint[]{ailvpoint[0], new IlvPoint(0.5f * (ailvpoint[0].x + ailvpoint[1].x), ailvpoint[0].y), ailvpoint[1]};
            nbPoints = 3;
            pointsCalc.points = ailvpoint1;
            pointsCalc.pointsUpdated = true;
        } else if (nbPoints >= 3) {
            IlvPoint controlPoint = ailvpoint[1];
            IlvPoint attachPoint = ailvpoint[0];
            IlvPoint controlPoint2 = ailvpoint[nbPoints - 2];
            IlvPoint attachPoint2 = ailvpoint[nbPoints - 1];
            int pointIndex = 0;
            int pointIndex2 = nbPoints - 1;
            int increment = 1;
            PathIterator shapePath = originPath;
            PathIterator shapePath2 = destinationPath;
            if (!origin) {
                controlPoint = ailvpoint[nbPoints - 2];
                attachPoint = ailvpoint[nbPoints - 1];
                controlPoint2 = ailvpoint[1];
                attachPoint2 = ailvpoint[0];
                pointIndex = nbPoints - 1;
                pointIndex2 = 0;
                increment = -1;
                shapePath = destinationPath;
                shapePath2 = originPath;
            }
            GeneralPath shape = new GeneralPath();
            shape.append(shapePath, false);
            if (origin == originForX) {
                controlPoint.x = attachPoint.x;
            } else {
                controlPoint.y = attachPoint.y;
            }
            if (shape.contains((Point2D)controlPoint)) {
                controlPoint = ailvpoint[(pointIndex += increment) + increment];
                attachPoint = ailvpoint[pointIndex];
                IlvPoint interPoint = LinkUtil.getClosestIntersectionPoint(controlPoint, attachPoint, shape.getPathIterator(new AffineTransform()));
                attachPoint.x = interPoint.x;
                attachPoint.y = interPoint.y;
            } else if (origin == originForX) {
                controlPoint.x = attachPoint.x;
            } else {
                controlPoint.y = attachPoint.y;
            }
            GeneralPath shape2 = new GeneralPath();
            shape2.append(shapePath2, false);
            if (origin == originForX) {
                controlPoint2.y = attachPoint2.y;
            } else {
                controlPoint2.x = attachPoint2.x;
            }
            if (shape2.contains((Point2D)controlPoint2)) {
                controlPoint2 = ailvpoint[(pointIndex2 -= increment) - increment];
                attachPoint2 = ailvpoint[pointIndex2];
                IlvPoint interPoint = LinkUtil.getClosestIntersectionPoint(controlPoint2, attachPoint2, shape2.getPathIterator(new AffineTransform()));
                attachPoint2.x = interPoint.x;
                attachPoint2.y = interPoint.y;
            } else if (origin == originForX) {
                controlPoint2.y = attachPoint2.y;
            } else {
                controlPoint2.x = attachPoint2.x;
            }
            pointsCalc.points = ailvpoint;
            pointsCalc.pointsUpdated = true;
        }
        return pointsCalc;
    }

    protected boolean calcPointsForVVPosition(PathIterator originPath, PathIterator destinationPath, boolean origin, IlvPoint[] ailvpoint) {
        int nbPoints = ailvpoint.length;
        boolean pointsUpdated = false;
        if (ailvpoint[nbPoints - 1].x - this._deltaAlignement <= ailvpoint[0].x && ailvpoint[0].x <= ailvpoint[nbPoints - 1].x + this._deltaAlignement) {
            IlvPoint[] newPoints = new IlvPoint[]{ailvpoint[0], ailvpoint[nbPoints - 1]};
            ailvpoint = newPoints;
        } else if (nbPoints == 2) {
            if (ailvpoint[0].x == ailvpoint[1].x) {
                return false;
            }
            if (ailvpoint[0].y == ailvpoint[1].y) {
                return false;
            }
            IlvPoint[] ailvpoint1 = new IlvPoint[]{ailvpoint[0], new IlvPoint(ailvpoint[0].x, 0.5f * (ailvpoint[0].y + ailvpoint[1].y)), new IlvPoint(ailvpoint[1].x, 0.5f * (ailvpoint[0].y + ailvpoint[1].y)), ailvpoint[1]};
            ailvpoint = ailvpoint1;
            nbPoints = 4;
            pointsUpdated = true;
        } else if (nbPoints >= 3) {
            IlvPoint controlPoint = ailvpoint[1];
            IlvPoint attachPoint = ailvpoint[0];
            int pointIndex = 0;
            int increment = 1;
            PathIterator shapePath = originPath;
            if (!origin) {
                controlPoint = ailvpoint[nbPoints - 2];
                attachPoint = ailvpoint[nbPoints - 1];
                pointIndex = nbPoints - 1;
                increment = -1;
                shapePath = destinationPath;
            }
            GeneralPath shape = new GeneralPath();
            shape.append(shapePath, false);
            controlPoint.x = attachPoint.x;
            if (shape.contains((Point2D)controlPoint)) {
                controlPoint = ailvpoint[(pointIndex += increment) + increment];
                attachPoint = ailvpoint[pointIndex];
                IlvPoint interPoint = LinkUtil.getClosestIntersectionPoint(controlPoint, attachPoint, shape.getPathIterator(new AffineTransform()));
                attachPoint.x = interPoint.x;
                attachPoint.y = interPoint.y;
                pointsUpdated = true;
            } else {
                controlPoint.x = attachPoint.x;
                pointsUpdated = true;
            }
        }
        return pointsUpdated;
    }

    static void staticInitPolicy(ClippedOrthogonalLinkShapePolicy policy, IlvLinkImage ilvlinkimage) {
        policy.initPolicy(ilvlinkimage);
    }

    private static class LinkPointsCalcInfo {
        public boolean pointsUpdated;
        public IlvPoint[] points;

        private LinkPointsCalcInfo() {
        }
    }
}

