/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.features;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.diagram.framework.graphic.features.AlignFormat;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.util.ResourcePicker;

public class AlignPanel
extends JPanel {
    private static final ResourcePicker rp = new ResourcePicker(ResourceBundle.getBundle("oracle.diagram.res.FeatureResources"));
    private AlignFormat _internFormat = new AlignFormat();
    private JPanel _hPanel;
    private JPanel _vPanel;
    private JPanel _sizePanel;
    private ButtonGroup _hGroup;
    private ButtonGroup _vGroup;
    private JRadioButton _hNone;
    private JRadioButton _hTop;
    private JRadioButton _hCenter;
    private JRadioButton _hBottom;
    private JRadioButton _vNone;
    private JRadioButton _vLeft;
    private JRadioButton _vCenter;
    private JRadioButton _vRight;
    private JCheckBox _sameWidth;
    private JCheckBox _sameHeight;

    public AlignPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AlignFormat getAlignFormat() {
        return this._internFormat;
    }

    protected void jbInit() throws Exception {
        GridBagLayout layout = new GridBagLayout();
        ActionController aListener = new ActionController();
        this.setLayout(layout);
        this.setSize(new Dimension(300, 400));
        this._hGroup = new ButtonGroup();
        this._hNone = new JRadioButton("!NLS:HNone");
        this._hTop = new JRadioButton("!NLS:HLeft");
        this._hCenter = new JRadioButton("!NLS:HCenter");
        this._hBottom = new JRadioButton("!NLS:HRight");
        this._hNone.setName("AlignHorizontalNone");
        rp.fillComponent((Component)this._hNone);
        this._hTop.setName("AlignHorizontalTop");
        rp.fillComponent((Component)this._hTop);
        this._hCenter.setName("AlignHorizontalCenter");
        rp.fillComponent((Component)this._hCenter);
        this._hBottom.setName("AlignHorizontalBottom");
        rp.fillComponent((Component)this._hBottom);
        this._hGroup.add(this._hNone);
        this._hGroup.add(this._hTop);
        this._hGroup.add(this._hCenter);
        this._hGroup.add(this._hBottom);
        this._hNone.addActionListener(aListener);
        this._hTop.addActionListener(aListener);
        this._hCenter.addActionListener(aListener);
        this._hBottom.addActionListener(aListener);
        GridBagLayout hLayout = new GridBagLayout();
        this._hPanel = new JPanel(hLayout);
        TitledBorder hBorder = BorderFactory.createTitledBorder(rp.getStringResource("AlignHorizontalPanel.text"));
        this._hPanel.setBorder(hBorder);
        GridBagLayout vLayout = new GridBagLayout();
        this._vPanel = new JPanel(vLayout);
        TitledBorder vBorder = BorderFactory.createTitledBorder(rp.getStringResource("AlignVerticalPanel.text"));
        this._vPanel.setBorder(vBorder);
        GridBagLayout sLayout = new GridBagLayout();
        this._sizePanel = new JPanel(sLayout);
        TitledBorder sBorder = BorderFactory.createTitledBorder(rp.getStringResource("AlignSizePanel.text"));
        this._sizePanel.setBorder(sBorder);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        layout.setConstraints(this._hPanel, c);
        c.gridwidth = 0;
        layout.setConstraints(this._vPanel, c);
        layout.setConstraints(this._sizePanel, c);
        c.gridwidth = 0;
        hLayout.setConstraints(this._hNone, c);
        this._hPanel.add(this._hNone);
        hLayout.setConstraints(this._hTop, c);
        this._hPanel.add(this._hTop);
        hLayout.setConstraints(this._hCenter, c);
        this._hPanel.add(this._hCenter);
        hLayout.setConstraints(this._hBottom, c);
        this._hPanel.add(this._hBottom);
        this._vGroup = new ButtonGroup();
        this._vNone = new JRadioButton("!NLS:VNone");
        this._vLeft = new JRadioButton("!NLS:VTop");
        this._vCenter = new JRadioButton("!NLS:VCenter");
        this._vRight = new JRadioButton("!NLS:VBottom");
        this._vNone.setName("AlignVerticalNone");
        rp.fillComponent((Component)this._vNone);
        this._vLeft.setName("AlignVerticalLeft");
        rp.fillComponent((Component)this._vLeft);
        this._vCenter.setName("AlignVerticalCenter");
        rp.fillComponent((Component)this._vCenter);
        this._vRight.setName("AlignVerticalRight");
        rp.fillComponent((Component)this._vRight);
        this._vGroup.add(this._vNone);
        this._vGroup.add(this._vLeft);
        this._vGroup.add(this._vCenter);
        this._vGroup.add(this._vRight);
        this._vNone.addActionListener(aListener);
        this._vLeft.addActionListener(aListener);
        this._vCenter.addActionListener(aListener);
        this._vRight.addActionListener(aListener);
        c.gridwidth = 0;
        vLayout.setConstraints(this._vNone, c);
        this._vPanel.add(this._vNone);
        vLayout.setConstraints(this._vLeft, c);
        this._vPanel.add(this._vLeft);
        vLayout.setConstraints(this._vCenter, c);
        this._vPanel.add(this._vCenter);
        vLayout.setConstraints(this._vRight, c);
        this._vPanel.add(this._vRight);
        this._sameWidth = new JCheckBox("!NLS:Width");
        this._sameHeight = new JCheckBox("!NLS:Height");
        this._sameWidth.setName("AlignSameWidth");
        rp.fillComponent((Component)this._sameWidth);
        this._sameHeight.setName("AlignSameHeight");
        rp.fillComponent((Component)this._sameHeight);
        this._sameWidth.addActionListener(aListener);
        this._sameHeight.addActionListener(aListener);
        c.gridwidth = 1;
        sLayout.setConstraints(this._sameWidth, c);
        this._sizePanel.add(this._sameWidth);
        sLayout.setConstraints(this._sameHeight, c);
        this._sizePanel.add(this._sameHeight);
        this.add(this._hPanel);
        this.add(this._vPanel);
        this.add(this._sizePanel);
        this._hNone.setSelected(true);
        this._vNone.setSelected(true);
    }

    public boolean showDialog(Frame pFrame) {
        AlignDialog aDialog = new AlignDialog(pFrame);
        aDialog.setContent(this);
        aDialog.setResizable(true);
        aDialog.setName("AlignDialog");
        rp.fillComponent((Component)((Object)aDialog));
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_mcomdalignprops_html");
        return WizardLauncher.runDialog((JDialog)((Object)aDialog));
    }

    private static final class AlignDialog
    extends JEWTDialog {
        public AlignDialog(Frame pFrame) {
            super(pFrame, "!NLS:Title", 7);
        }
    }

    private final class ActionController
    implements ActionListener {
        private ActionController() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source instanceof JRadioButton) {
                if (source == AlignPanel.this._hNone) {
                    AlignPanel.this._internFormat.setHorizontalMode(AlignFormat.HorizontalMode.NONE);
                }
                if (source == AlignPanel.this._hTop) {
                    AlignPanel.this._internFormat.setHorizontalMode(AlignFormat.HorizontalMode.TOP);
                }
                if (source == AlignPanel.this._hCenter) {
                    AlignPanel.this._internFormat.setHorizontalMode(AlignFormat.HorizontalMode.CENTER);
                }
                if (source == AlignPanel.this._hBottom) {
                    AlignPanel.this._internFormat.setHorizontalMode(AlignFormat.HorizontalMode.BOTTOM);
                }
                if (source == AlignPanel.this._vNone) {
                    AlignPanel.this._internFormat.setVerticalMode(AlignFormat.VerticalMode.NONE);
                }
                if (source == AlignPanel.this._vLeft) {
                    AlignPanel.this._internFormat.setVerticalMode(AlignFormat.VerticalMode.LEFT);
                }
                if (source == AlignPanel.this._vCenter) {
                    AlignPanel.this._internFormat.setVerticalMode(AlignFormat.VerticalMode.CENTER);
                }
                if (source == AlignPanel.this._vRight) {
                    AlignPanel.this._internFormat.setVerticalMode(AlignFormat.VerticalMode.RIGHT);
                }
            } else if (source instanceof JCheckBox) {
                if (source == AlignPanel.this._sameWidth) {
                    AlignPanel.this._internFormat.setAdjustWidth(AlignPanel.this._sameWidth.isSelected());
                }
                if (source == AlignPanel.this._sameHeight) {
                    AlignPanel.this._internFormat.setAdjustHeight(AlignPanel.this._sameHeight.isSelected());
                }
            }
        }
    }
}

