/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.graphic.linkpolicy.IlvLinkShapePolicy;
import ilog.views.graphic.linkpolicy.IlvPolicyAwareLinkImage;
import java.util.ArrayList;
import oracle.diagram.framework.graphic.GraphicPin;
import oracle.diagram.framework.graphic.GraphicUtils;

public final class SubNodeLinkUtil {
    private SubNodeLinkUtil() {
    }

    public static final void updateSubNodeLinks(IlvGraphic source) {
        IlvGraphic managedParent = GraphicUtils.getManagedParent(source);
        if (managedParent != null) {
            IlvLinkShapePolicy policy;
            GraphicPin pin;
            IlvLinkImage link2;
            IlvGrapher grapher = (IlvGrapher)managedParent.getGraphicBag();
            ArrayList<IlvLinkImage> linksFrom = new ArrayList<IlvLinkImage>(grapher.getLinksCount(managedParent));
            ArrayList<IlvLinkImage> linksTo = new ArrayList<IlvLinkImage>(grapher.getLinksCount(managedParent));
            IlvGraphicEnumeration e = grapher.getLinksFrom(managedParent);
            while (e.hasMoreElements()) {
                link2 = (IlvLinkImage)e.nextElement();
                pin = GraphicPin.findPin(link2, true);
                if (pin == null || !GraphicUtils.isAncestorOf(source, pin.getGraphic())) continue;
                linksFrom.add(link2);
            }
            e = grapher.getLinksTo(managedParent);
            while (e.hasMoreElements()) {
                link2 = (IlvLinkImage)e.nextElement();
                pin = GraphicPin.findPin(link2, false);
                if (pin == null || !GraphicUtils.isAncestorOf(source, pin.getGraphic())) continue;
                linksTo.add(link2);
            }
            for (IlvLinkImage link2 : linksFrom) {
                if (!(link2 instanceof IlvPolicyAwareLinkImage) || (policy = ((IlvPolicyAwareLinkImage)link2).getLinkShapePolicy()) == null) continue;
                policy.afterFromNodeMoved(link2);
            }
            for (IlvLinkImage link2 : linksTo) {
                if (!(link2 instanceof IlvPolicyAwareLinkImage) || (policy = ((IlvPolicyAwareLinkImage)link2).getLinkShapePolicy()) == null) continue;
                policy.afterToNodeMoved(link2);
            }
        }
    }
}

