/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.linkconnector.IlvGrapherPin;
import ilog.views.linkconnector.IlvPinLinkConnector;
import oracle.diagram.framework.graphic.DefaultSubNodePinLinkConnectorFactory;
import oracle.diagram.framework.graphic.GraphicUtils;
import oracle.diagram.framework.graphic.NodeGraphicPin;
import oracle.diagram.framework.graphic.SubNodePinLinkConnectorFactory;

public final class SubNodeGraphicPin
extends NodeGraphicPin {
    private static final SubNodePinLinkConnectorFactory DEFAULT = new DefaultSubNodePinLinkConnectorFactory();

    @Override
    public void connect(IlvPoint p, IlvTransformer t) {
        IlvGraphic end = GraphicUtils.getManagedParent(this.getGraphic());
        if (this.isOrigin()) {
            this.getLink().setFrom(end);
        } else {
            this.getLink().setTo(end);
        }
        IlvPinLinkConnector plc = this.getFactory().createAndAttachConnector(this.getLink(), this.getGraphic(), this.isOrigin());
        IlvGrapherPin pin = plc.getClosestConnectionPin(p, (Object)this.getLink().getFrom(), (Object)this.getLink().getTo(), (Object)this.getLink(), this.isOrigin(), t);
        plc.connectLink(this.getLink(), pin, this.isOrigin());
    }

    protected SubNodePinLinkConnectorFactory getFactory() {
        SubNodePinLinkConnectorFactory fac = this.walkForFactory(this.getGraphic(), this.isOrigin() ? this.getLink().getFrom() : this.getLink().getTo());
        if (fac == null) {
            fac = DEFAULT;
        }
        return fac;
    }

    private SubNodePinLinkConnectorFactory walkForFactory(IlvGraphic start, IlvGraphic stop) {
        IlvGraphicBag bag;
        SubNodePinLinkConnectorFactory fac = SubNodePinLinkConnectorFactory.Util.getFactory(start);
        if (fac != null) {
            return fac;
        }
        if (start == stop) {
            return null;
        }
        for (bag = start.getGraphicBag(); bag != null && !(bag instanceof IlvGraphic); bag = bag.getGraphicBag()) {
        }
        if (bag == null) {
            return null;
        }
        return this.walkForFactory((IlvGraphic)bag, stop);
    }

    @Override
    protected void disconnectImpl() {
        IlvLinkConnector lc = IlvLinkConnector.GetAttached((IlvLinkImage)this.getLink(), (boolean)this.isOrigin());
        lc.detach(this.getLink(), this.isOrigin(), false);
        super.disconnectImpl();
    }
}

