/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvLinkShapePolicy;
import ilog.views.graphic.linkpolicy.IlvPolicyAwareLinkImage;
import ilog.views.linkconnector.IlvClippingLinkConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.diagram.framework.graphic.EdgeGraphicConnector;
import oracle.diagram.framework.graphic.GraphicPin;
import oracle.diagram.framework.graphic.NodeGraphicConnector;
import oracle.diagram.framework.manager.ManagerUtil;

public abstract class GraphicConnector {
    private static final String GRAPHIC_CONNECTOR = "oracle.diagram.framework.graphic.GraphicConnector";
    private IlvGraphic m_graphic;
    private ArrayList<GraphicPin> m_pins = new ArrayList();

    public IlvGraphic getGraphic() {
        return this.m_graphic;
    }

    public void attach(IlvGraphic graphic, boolean redraw) {
        if (graphic == null) {
            throw new IllegalArgumentException("Missing graphic");
        }
        GraphicConnector connector = GraphicConnector.findConnector(graphic);
        if (connector != null) {
            connector.detach();
        }
        this.detach();
        this.m_graphic = graphic;
        this.m_graphic.setProperty(GRAPHIC_CONNECTOR, (Object)this);
        this.attachImpl(graphic, redraw);
    }

    protected abstract void attachImpl(IlvGraphic var1, boolean var2);

    public GraphicPin connectLink(IlvLinkImage link, IlvPoint p, boolean origin, IlvTransformer t) {
        IlvGrapher grapher;
        IlvLinkConnector otherConnector = IlvLinkConnector.Get((IlvLinkImage)link, (!origin ? 1 : 0) != 0);
        IlvPoint otherPoint = null;
        if (otherConnector != null) {
            otherPoint = otherConnector instanceof IlvClippingLinkConnector ? ((IlvClippingLinkConnector)otherConnector).getUnclippedConnectionPoint(link, !origin, null) : otherConnector.getConnectionPoint(link, !origin, null);
        }
        IlvLinkShapePolicy policy = link instanceof IlvPolicyAwareLinkImage ? ((IlvPolicyAwareLinkImage)link).getLinkShapePolicy() : null;
        GraphicPin pin = GraphicPin.findPin(link, origin);
        if (pin != null && pin.getConnector() != this) {
            pin.disconnect();
            pin = null;
        }
        if (pin == null) {
            pin = this.createPin();
            pin.attach(this, link, origin);
            this.m_pins.add(pin);
        }
        if ((grapher = (IlvGrapher)link.getGraphicBag()) == null) {
            pin.connect(p, t);
        } else {
            GraphicConnector gc;
            IlvManagerLayer layer = grapher.getManagerLayer((IlvGraphic)link);
            int index = layer.getIndex((IlvGraphic)link);
            grapher.removeLink(link, false);
            if (otherPoint != null) {
                otherConnector.connectLink(link, otherPoint, !origin, null);
            }
            pin.connect(p, t);
            IlvGrapher lcg = IlvGrapher.getLowestCommonGrapher((IlvGraphic)link.getFrom(), (IlvGraphic)link.getTo());
            if (lcg != grapher) {
                lcg.addLink(link, true);
            } else {
                lcg.addLink(link, layer.getIndex(), true);
                layer.setIndex((IlvGraphic)link, index);
            }
            if (policy != null) {
                ((IlvPolicyAwareLinkImage)link).setLinkShapePolicy(policy);
            }
            if (lcg != grapher && (gc = GraphicConnector.findConnector((IlvGraphic)link)) != null) {
                try {
                    gc.reconnect(ManagerUtil.getConversionTransformer((IlvManager)grapher, (IlvManager)lcg));
                }
                catch (IllegalStateException ias) {
                    IlvTransformer trans = new IlvTransformer();
                    ManagerUtil.getConversionTransformer((IlvManager)lcg, (IlvManager)grapher).computeInverse(trans);
                    gc.reconnect(trans);
                }
            }
        }
        return pin;
    }

    private void reconnect(IlvTransformer t) {
        for (GraphicPin pin : this.m_pins) {
            IlvLinkImage link = pin.getLink();
            IlvPoint p = pin.getConnectionPoint();
            boolean origin = pin.isOrigin();
            this.connectLink(link, p, origin, t);
        }
    }

    protected abstract GraphicPin createPin();

    public void detach() {
        if (this.m_graphic != null) {
            ArrayList<GraphicPin> pins = this.m_pins;
            this.m_pins = new ArrayList();
            for (GraphicPin pin : pins) {
                pin.disconnect();
            }
            this.m_graphic.removeProperty(GRAPHIC_CONNECTOR);
            this.m_graphic = null;
        }
    }

    public void disconnectLink(IlvLinkImage link, boolean origin) {
        GraphicPin pin = GraphicPin.findPin(link, origin);
        if (pin == null) {
            throw new IllegalArgumentException("Missing pin");
        }
        if (pin.getConnector() != this) {
            throw new IllegalArgumentException("Pin not connected to this connector");
        }
        pin.disconnect();
    }

    void removePin(GraphicPin pin) {
        this.m_pins.remove(pin);
    }

    public boolean hasLinks() {
        return this.m_pins.size() > 0;
    }

    public Collection<GraphicPin> getPins() {
        return Collections.unmodifiableCollection(this.m_pins);
    }

    public static GraphicConnector findConnector(IlvGraphic graphic) {
        return (GraphicConnector)graphic.getProperty(GRAPHIC_CONNECTOR);
    }

    public static GraphicConnector findOrCreateConnector(IlvGraphic graphic) {
        GraphicConnector connector = GraphicConnector.findConnector(graphic);
        if (connector == null) {
            connector = graphic instanceof IlvLinkImage ? new EdgeGraphicConnector() : new NodeGraphicConnector();
            connector.attach(graphic, false);
        }
        return connector;
    }
}

