/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvAbstractLinkShapePolicy;
import ilog.views.graphic.linkpolicy.IlvLinkShapePolicy;
import ilog.views.graphic.linkpolicy.IlvPolicyAwareLinkImage;
import java.util.ArrayList;
import oracle.diagram.framework.manager.ManagerUtil;

public class Edge2EdgeLinkShapePolicy
extends IlvAbstractLinkShapePolicy {
    private static final String FROM_END = "oracle.diagram.framework.Edge2EdgeLinkShapePolicy.FromEnd";
    private static final String TO_END = "oracle.diagram.framework.Edge2EdgeLinkShapePolicy.ToEnd";
    public static final String CONN_SOURCE = "oracle.diagram.framework.Edge2EdgeLinkShapePolicy.ConnSource";
    public static final String CONN_DEST = "oracle.diagram.framework.Edge2EdgeLinkShapePolicy.ConnDest";
    private IlvLinkImage m_link;
    private int m_pointCount;
    private ArrayList<LinkEnd> m_ends = new ArrayList();

    Edge2EdgeLinkShapePolicy() {
    }

    public void onInstall(IlvLinkImage link) {
        super.onInstall(link);
        this.m_link = link;
        this.m_pointCount = this.m_link.getPointsCardinal();
    }

    public void afterApplyTransform(IlvLinkImage link, IlvTransformer t) {
        super.afterApplyTransform(link, t);
        if (this.checkPointCount()) {
            this.updateLinks(0, this.m_pointCount - 1);
        }
    }

    public void afterFromNodeMoved(IlvLinkImage link) {
        super.afterFromNodeMoved(link);
        if (this.checkPointCount()) {
            this.updateLinks(0, this.m_pointCount - 1);
        }
    }

    public void afterInsertPoint(IlvLinkImage link, int index, IlvTransformer t) {
        super.afterInsertPoint(link, index, t);
        this.checkPointCount();
    }

    public void afterMovePoint(IlvLinkImage link, int index, IlvTransformer t) {
        super.afterMovePoint(link, index, t);
        if (this.checkPointCount()) {
            this.updateLinks(0, this.m_pointCount - 1);
        }
    }

    public void afterRemovePoint(IlvLinkImage link, int index, IlvTransformer t) {
        super.afterRemovePoint(link, index, t);
        this.checkPointCount();
    }

    public void afterToNodeMoved(IlvLinkImage link) {
        super.afterToNodeMoved(link);
        if (this.checkPointCount()) {
            this.updateLinks(0, this.m_pointCount - 1);
        }
    }

    public void afterSetIntermediateLinkPoints(IlvLinkImage link) {
        super.afterSetIntermediateLinkPoints(link);
        if (this.checkPointCount()) {
            this.updateLinks(0, this.m_pointCount - 1);
        }
    }

    public void connectLink(IlvLinkImage endLink, boolean origin) {
        String key = origin ? FROM_END : TO_END;
        LinkEnd end = new LinkEnd(endLink, origin);
        this.m_ends.add(end);
        endLink.setProperty(key, (Object)end);
    }

    public void ensureConnection(IlvLinkImage endLink, boolean origin) {
        String key = origin ? FROM_END : TO_END;
        LinkEnd end = (LinkEnd)endLink.getProperty(key);
        if (end == null || this.m_ends.contains(end)) {
            return;
        }
        end.getPolicy().disconnectLink(endLink, origin);
        LinkEnd newEnd = new LinkEnd(end);
        this.m_ends.add(newEnd);
        endLink.setProperty(key, (Object)newEnd);
    }

    public void disconnectLink(IlvLinkImage endLink, boolean origin) {
        String key = origin ? FROM_END : TO_END;
        LinkEnd end = (LinkEnd)endLink.getProperty(key);
        if (end == null) {
            return;
        }
        this.m_ends.remove(end);
        endLink.removeProperty(key);
    }

    private void updateLinks(int from, int to) {
        for (LinkEnd end : this.m_ends) {
            int segment = end.m_segment;
            if (from > segment || segment > to) continue;
            end.move();
        }
    }

    private boolean checkPointCount() {
        int pointCount = this.m_link.getPointsCardinal();
        if (this.m_pointCount != this.m_link.getPointsCardinal()) {
            for (LinkEnd end : this.m_ends) {
                end.tCalc(Double.POSITIVE_INFINITY);
            }
            this.m_pointCount = pointCount;
            return false;
        }
        return true;
    }

    public static Edge2EdgeLinkShapePolicy findPolicy(IlvGraphic link) {
        if (link instanceof IlvPolicyAwareLinkImage) {
            IlvLinkShapePolicy policy = ((IlvPolicyAwareLinkImage)link).getLinkShapePolicy();
            while (!(policy instanceof Edge2EdgeLinkShapePolicy)) {
                if (policy instanceof IlvAbstractLinkShapePolicy) {
                    policy = ((IlvAbstractLinkShapePolicy)policy).getChildPolicy();
                    continue;
                }
                return null;
            }
            return (Edge2EdgeLinkShapePolicy)policy;
        }
        return null;
    }

    private static IlvTransformer getConversionTransformer(IlvManager toManager, IlvManager fromManager) {
        try {
            return ManagerUtil.getConversionTransformer(toManager, fromManager);
        }
        catch (IllegalStateException ise) {
            IlvTransformer trans = new IlvTransformer();
            ManagerUtil.getConversionTransformer(fromManager, toManager).computeInverse(trans);
            return trans;
        }
    }

    private class LinkEnd {
        private IlvLinkImage m_endLink;
        private boolean m_origin;
        private int m_segment;
        private double m_t;

        public LinkEnd(IlvLinkImage endLink, boolean origin) {
            this.m_endLink = endLink;
            this.m_origin = origin;
            this.tCalc(Double.POSITIVE_INFINITY);
        }

        public LinkEnd(LinkEnd end) {
            this.m_endLink = end.m_endLink;
            this.m_origin = end.m_origin;
            this.m_segment = end.m_segment;
            this.m_t = end.m_t;
            if (Edge2EdgeLinkShapePolicy.this.m_pointCount == end.getPolicy().m_pointCount) {
                this.move();
            } else {
                this.tCalc(Double.POSITIVE_INFINITY);
            }
        }

        public Edge2EdgeLinkShapePolicy getPolicy() {
            return Edge2EdgeLinkShapePolicy.this;
        }

        public void tCalc(double delta) {
            double y2;
            double x2;
            double y1;
            double x1;
            double y1_y2;
            double x1_x2;
            IlvGrapher parent = (IlvGrapher)Edge2EdgeLinkShapePolicy.this.m_link.getGraphicBag();
            IlvGrapher grapher = (IlvGrapher)this.m_endLink.getGraphicBag();
            if (grapher == null) {
                grapher = (IlvGrapher)Edge2EdgeLinkShapePolicy.this.m_link.getTopLevelGraphicBag();
            }
            IlvTransformer trans = Edge2EdgeLinkShapePolicy.getConversionTransformer((IlvManager)grapher, (IlvManager)parent);
            int numPoints = this.m_endLink.getPointsCardinal();
            IlvPoint p1 = this.m_endLink.getPointAt(this.m_origin ? 0 : numPoints - 1, null);
            int otherPoint = this.m_origin ? 1 : numPoints - 2;
            do {
                IlvPoint p2 = this.m_endLink.getPointAt(otherPoint, null);
                x1 = p1.getX();
                y1 = p1.getY();
                x2 = p2.getX();
                y2 = p2.getY();
                x1_x2 = x1 - x2;
                y1_y2 = y1 - y2;
                if (!this.m_origin ? --otherPoint < 0 : ++otherPoint == numPoints) break;
            } while (x1_x2 == 0.0 && y1_y2 == 0.0);
            IlvPoint[] points = Edge2EdgeLinkShapePolicy.this.m_link.getLinkPoints(trans);
            for (int i = points.length - 1; i > 0; --i) {
                double x3_x4;
                IlvPoint p3 = points[i];
                IlvPoint p4 = points[i - 1];
                double x3 = p3.getX();
                double y3 = p3.getY();
                double x4 = p4.getX();
                double y4 = p4.getY();
                double y3_y4 = y3 - y4;
                double detdiv = x1_x2 * y3_y4 - y1_y2 * (x3_x4 = x3 - x4);
                if (detdiv == 0.0) continue;
                double det12 = x1 * y2 - y1 * x2;
                double det34 = x3 * y4 - y3 * x4;
                double x = (det12 * x3_x4 - x1_x2 * det34) / detdiv;
                double y = (det12 * y3_y4 - y1_y2 * det34) / detdiv;
                double distSq = Math.pow(x - x1, 2.0) + Math.pow(y - y1, 2.0);
                if (distSq > delta) continue;
                double t = -1.0;
                if (x3 != x4) {
                    t = (x - x4) / (x3 - x4);
                } else if (y3 != y4) {
                    t = (y - y4) / (y3 - y4);
                } else if (x4 == x && y4 == y) {
                    t = 0.0;
                }
                if (!(0.0 <= t) || !(t <= 1.0)) continue;
                delta = distSq;
                this.m_t = t;
                this.m_segment = i - 1;
            }
            if (this.m_segment > points.length - 2) {
                this.m_segment = points.length - 2;
            }
            this.move();
        }

        public void move() {
            IlvManager m = (IlvManager)this.m_endLink.getGraphicBag();
            if (m == null) {
                this.moveImpl();
            } else {
                m.applyToObject((IlvGraphic)this.m_endLink, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        LinkEnd.this.moveImpl();
                    }
                }, null, true);
            }
        }

        private void moveImpl() {
            IlvLinkConnector connector = IlvLinkConnector.Get((IlvLinkImage)this.m_endLink, (boolean)this.m_origin);
            IlvPoint seg1 = Edge2EdgeLinkShapePolicy.this.m_link.getPointAt(this.m_segment, null);
            IlvPoint seg2 = Edge2EdgeLinkShapePolicy.this.m_link.getPointAt(this.m_segment + 1, null);
            double x = (1.0 - this.m_t) * seg1.getX() + this.m_t * seg2.getX();
            double y = (1.0 - this.m_t) * seg1.getY() + this.m_t * seg2.getY();
            IlvGraphic actualNode = this.m_origin ? this.m_endLink.getFrom() : this.m_endLink.getTo();
            IlvLinkConnector actualConnector = IlvLinkConnector.GetAttached((IlvGraphic)actualNode);
            IlvTransformer tx = null;
            IlvPoint connPoint = new IlvPoint((float)x, (float)y);
            if (actualConnector == connector) {
                IlvGraphic node = connector.getNode();
                IlvManager nodeBag = (IlvManager)node.getGraphicBag();
                IlvLinkConnector otherConnector = IlvLinkConnector.Get((IlvLinkImage)this.m_endLink, (!this.m_origin ? 1 : 0) != 0);
                IlvGraphic otherNode = otherConnector.getNode();
                IlvGrapher linkManager = IlvGrapher.getLowestCommonGrapher((IlvGraphic)node, (IlvGraphic)otherNode);
                IlvManager endPointLinkManager = ManagerUtil.getManager((IlvGraphic)Edge2EdgeLinkShapePolicy.this.m_link);
                if (nodeBag == endPointLinkManager) {
                    tx = ManagerUtil.getConversionTransformer((IlvManager)linkManager, nodeBag);
                    tx.apply(connPoint);
                } else {
                    tx = ManagerUtil.getConversionTransformer(endPointLinkManager, nodeBag);
                }
                connector.connectLink(this.m_endLink, connPoint, this.m_origin, tx);
            } else {
                this.m_endLink.setProperty(this.m_origin ? Edge2EdgeLinkShapePolicy.CONN_SOURCE : Edge2EdgeLinkShapePolicy.CONN_DEST, (Object)connPoint);
            }
        }
    }
}

