/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import java.awt.RenderingHints;

public class DiagramRenderingHints {
    private static final int NUM_KEYS = 4;
    private static final int VALS_PER_KEY = 3;
    public static final int INTKEY_SHAPE_SHADOW = 0;
    public static final int INTVAL_SHAPE_SHADOW_DEFAULT = 0;
    public static final int INTVAL_SHAPE_SHADOW_OFF = 1;
    public static final int INTVAL_SHAPE_SHADOW_ON = 2;
    public static final int INTKEY_HC_FILL_COLOR = 1;
    public static final int INTVAL_HC_FILL_COLOR_DEFAULT = 0;
    public static final int INTVAL_HC_FILL_COLOR_FORE = 1;
    public static final int INTVAL_HC_FILL_COLOR_BACK = 2;
    public static final int INTKEY_HC_TEXT_HIGHLIGHT = 2;
    public static final int INTVAL_HC_TEXT_HIGHLIGHT_DEFAULT = 0;
    public static final int INTVAL_HC_TEXT_HIGHLIGHT_ON = 1;
    public static final int INTVAL_HC_TEXT_HIGHLIGHT_OFF = 2;
    public static final Key KEY_SHAPE_SHADOW = new Key(0, "Shape shadow painting key");
    public static final Object VALUE_SHAPE_SHADOW_DEFAULT = new Value(KEY_SHAPE_SHADOW, 0, "Default Shape Shadow Mode");
    public static final Object VALUE_SHAPE_SHADOW_OFF = new Value(KEY_SHAPE_SHADOW, 1, "Shape Shadow Off");
    public static final Object VALUE_SHAPE_SHADOW_ON = new Value(KEY_SHAPE_SHADOW, 2, "Shape Shadow ON");
    public static final Key KEY_HC_FILL_COLOR = new Key(1, "Color to use to fill shapes in High Contrast mode");
    public static final Object VALUE_HC_FILL_COLOR_DEFAULT = new Value(KEY_HC_FILL_COLOR, 0, "Default Color for Shape fill in High Contrast mode");
    public static final Object VALUE_HC_FILL_COLOR_FORE = new Value(KEY_HC_FILL_COLOR, 1, "High Contrast foreground Color fill shape");
    public static final Object VALUE_HC_FILL_COLOR_BACK = new Value(KEY_HC_FILL_COLOR, 2, "High Contrast background Color fill shape");
    public static final Key KEY_HC_TEXT_HIGHLIGHT = new Key(2, "High Contrast - Text Highlight status");
    public static final Object VALUE_HC_TEXT_HIGHLIGHT_DEFAULT = new Value(KEY_HC_TEXT_HIGHLIGHT, 0, "High Contrast - Default Text Highlight status");
    public static final Object VALUE_HC_TEXT_HIGHLIGHT_ON = new Value(KEY_HC_TEXT_HIGHLIGHT, 1, "High Contrast - Text Highlight on");
    public static final Object VALUE_HC_TEXT_HIGHLIGHT_OFF = new Value(KEY_HC_TEXT_HIGHLIGHT, 2, "High Contrast - Text Highlight off");

    private static class Value {
        private static final Value[][] sValues = new Value[4][3];
        private final Key m_key;
        private final int m_index;
        private final String m_description;

        private static synchronized void register(Key key, Value value) {
            int ival;
            int ikey = key.getIndex();
            if (sValues[ikey][ival = value.m_index] != null) {
                throw new IllegalStateException("Duplicate index for DiagramRenderingHints value " + ival);
            }
            Value.sValues[ikey][ival] = value;
        }

        Value(Key key, int index, String description) {
            this.m_key = key;
            this.m_index = index;
            this.m_description = description;
            Value.register(key, this);
        }

        final boolean isValidKey(Key key) {
            return key == this.m_key;
        }

        public final int hashCode() {
            return System.identityHashCode(this);
        }

        public final boolean equals(Object o) {
            return this == o;
        }

        public final String toString() {
            return this.m_description;
        }
    }

    public static class Key
    extends RenderingHints.Key {
        private final String m_description;

        public Key(int privateKey, String description) {
            super(privateKey);
            this.m_description = description;
        }

        int getIndex() {
            return this.intKey();
        }

        public String toString() {
            return this.m_description;
        }

        @Override
        public boolean isCompatibleValue(Object val) {
            if (val instanceof Value) {
                return ((Value)val).isValidKey(this);
            }
            return false;
        }
    }
}

