/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.dragdrop.handler;

import java.awt.Frame;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JList;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bm.javatools.util.MultivaluedMap;
import oracle.bm.util.ResourcePicker;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.framework.dragdrop.event.DiagramDropTargetCommonEvent;
import oracle.diagram.framework.dragdrop.event.DiagramDropTargetDropEvent;
import oracle.diagram.framework.dragdrop.handler.DropChooserPanel;
import oracle.diagram.framework.dragdrop.handler.ModularDropHandler;
import oracle.diagram.framework.dragdrop.handler.SubDropHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Project;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.BundleLoader;

public abstract class DelegateChooserDropHandler
extends ModularDropHandler {
    @Override
    public void drop(DiagramDropTargetDropEvent ddtde) {
        if (this.checkAction(ddtde)) {
            try {
                List<Object> objects = Collections.unmodifiableList(this.getObjects(ddtde.getTransferable().getTransferData(this.getDataFlavor())));
                MultivaluedMap handlerSets = new MultivaluedMap(HashMap.class, HashSet.class);
                HashSet<SubDropHandler> multiHandlers = new HashSet<SubDropHandler>();
                HashSet<SubDropHandler> tmpMultiHandlers = new HashSet<SubDropHandler>();
                for (Object o : objects) {
                    tmpMultiHandlers.clear();
                    for (SubDropHandler sdh : this._subHandlers) {
                        try {
                            if (!sdh.interested(o)) continue;
                            tmpMultiHandlers.add(sdh);
                        }
                        catch (Exception e) {
                            FeedbackManager.reportException((Throwable)e);
                        }
                    }
                    Collection<SubDropHandler> filteredHandlers = this.filterDropHandlers(ddtde, tmpMultiHandlers, Arrays.asList(o));
                    for (SubDropHandler sdh : filteredHandlers) {
                        handlerSets.put((Object)sdh, o);
                    }
                    if (filteredHandlers.size() <= 1) continue;
                    multiHandlers.addAll(filteredHandlers);
                }
                Set<SubDropHandler> selected = this.choose(ddtde, handlerSets.keySet(), multiHandlers);
                this.dropSelected(ddtde, selected, (MultivaluedMap<SubDropHandler, Object>)handlerSets);
                ddtde.dropComplete(true);
                return;
            }
            catch (UnsupportedFlavorException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ddtde.dropComplete(false);
    }

    @Override
    protected boolean shouldAccept(DiagramDropTargetCommonEvent ddtce) {
        try {
            List<Object> objects = Collections.unmodifiableList(this.getObjects(ddtce.getTransferable().getTransferData(this.getDataFlavor())));
            Collection<SubDropHandler> filteredHandlers = Collections.unmodifiableCollection(this._subHandlers);
            if (ddtce instanceof DiagramDropTargetDropEvent) {
                filteredHandlers = this.filterDropHandlers((DiagramDropTargetDropEvent)ddtce, filteredHandlers, objects);
            }
            for (Object o : objects) {
                for (SubDropHandler sdh : filteredHandlers) {
                    try {
                        if (!sdh.interested(o)) continue;
                        return true;
                    }
                    catch (Exception e) {
                        FeedbackManager.reportException((Throwable)e);
                    }
                }
            }
        }
        catch (UnsupportedFlavorException e) {
            FeedbackManager.reportException((Throwable)e);
        }
        catch (IOException ioe) {
            FeedbackManager.reportException((Throwable)ioe);
        }
        return false;
    }

    protected abstract List<Object> getObjects(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<SubDropHandler> choose(DiagramDropTargetDropEvent ddtde, Set<SubDropHandler> available, Set<SubDropHandler> conflicted) {
        if (available.isEmpty() || conflicted.isEmpty()) {
            return available;
        }
        ResourcePicker rp = this.getPicker();
        Context context = ddtde.getDiagramContext().getPlugin(IdeContextPlugin.class).getContext();
        DropChooserPanel dp = new DropChooserPanel(rp, context, available, conflicted);
        final MyDialog dlg = new MyDialog((Frame)Ide.getMainWindow(), rp.getString("DropChooserDialog.title"), 7);
        dlg.setContent(dp);
        dlg.setPreferredSize(400, 300);
        dlg.setResizable(true);
        dlg.setInitialFocus(dp.getHandlerList());
        final JList handlersList = dp.getHandlerList();
        handlersList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = handlersList.locationToIndex(e.getPoint());
                    handlersList.setSelectedIndex(index);
                    dlg.finish();
                }
            }
        });
        try {
            if (dlg.runDialog()) {
                Set<SubDropHandler> set = dp.getSelection();
                return set;
            }
            HashSet<SubDropHandler> hashSet = new HashSet<SubDropHandler>();
            return hashSet;
        }
        finally {
            dlg.dispose();
        }
    }

    protected ResourcePicker getPicker() {
        return new ResourcePicker(BundleLoader.getBundle((String)"oracle.diagram.res.DropResources"));
    }

    protected Collection<SubDropHandler> filterDropHandlers(DiagramDropTargetDropEvent ddtde, Collection<SubDropHandler> handlers, Collection<Object> objects) {
        return handlers;
    }

    protected void dropSelected(DiagramDropTargetDropEvent ddtde, Set<SubDropHandler> selected, MultivaluedMap<SubDropHandler, Object> handlerSets) {
        Context context = ddtde.getDiagramContext().getPlugin(IdeContextPlugin.class).getContext();
        Project project = context != null ? context.getProject() : null;
        TechnologyScopeConfiguration tsc = null;
        TechnologyScope ts = null;
        boolean addTS = false;
        if (project != null) {
            tsc = TechnologyScopeConfiguration.getInstance((PropertyStorage)project);
            ts = tsc.getTechnologyScope();
            addTS = !ts.isEmpty();
        }
        for (SubDropHandler sdh : selected) {
            try {
                TechId[] ids;
                sdh.dropObjects(ddtde, handlerSets.get((Object)sdh).toArray());
                if (!addTS || (ids = sdh.getNewTechIds()) == null) continue;
                for (TechId id : ids) {
                    ts.add(id);
                }
            }
            catch (Exception ex) {
                FeedbackManager.reportException((Throwable)ex);
            }
        }
        if (addTS) {
            tsc.setTechnologyScope(ts);
        }
    }

    private class MyDialog
    extends JEWTDialog {
        public MyDialog(Frame parent, String title, int mask) {
            super(parent, title, mask);
        }

        public void finish() {
            this.dismissDialog(false);
        }
    }
}

