/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.dragdrop;

import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;
import oracle.diagram.core.interaction.DragAndDropAwareInteractor;
import oracle.diagram.core.interaction.MoveInteractorMarker;
import oracle.diagram.framework.datatransfer.SelectionTransferable;

public abstract class ManagerViewDragAndDropController {
    private final DragSource _dragSource;
    private final IlvManagerView _view;
    private final int _actions;
    private final DataFlavor _nativeFlavor;
    private final MyDragGestureListener _dgl;
    private final MyDropTargetListener _dtl;
    private final MyDragGestureRecognizer _dgr;
    private final MyDropTarget _dt;
    private IlvManagerView _initiatorView = null;
    private boolean _dropProcessed = false;
    private boolean _droppedElsewhere = false;
    protected boolean _dropPerformed;

    protected ManagerViewDragAndDropController(DragSource ds, IlvManagerView view, Autoscroll autoscrollComponent, int actions, DropTargetListener dtl) {
        this(ds, view, autoscrollComponent, actions, SelectionTransferable.FLAVOR, dtl);
    }

    protected ManagerViewDragAndDropController(DragSource ds, IlvManagerView view, Autoscroll autoscrollComponent, int actions, DataFlavor nativeFlavor, DropTargetListener dtl) {
        this._dragSource = ds;
        this._view = view;
        if (autoscrollComponent != null && !(autoscrollComponent instanceof Component)) {
            throw new IllegalArgumentException("autoscrollComponent must be null or a java.awt.Component");
        }
        this._actions = actions;
        this._nativeFlavor = nativeFlavor;
        this._dgl = new MyDragGestureListener();
        this._dtl = new MyDropTargetListener(dtl);
        this._dt = new MyDropTarget(autoscrollComponent != null ? (Component)((Object)autoscrollComponent) : this._view, this._actions, this._dtl);
        this._dgr = new MyDragGestureRecognizer(ds, (Component)this._view, this._actions, this._dgl);
    }

    protected int getSupportedActions() {
        return this._actions;
    }

    protected DataFlavor getNativeFlavor() {
        return this._nativeFlavor;
    }

    protected IlvManagerView getView() {
        return this._view;
    }

    protected abstract void dragGestureRecognized(DragGestureEvent var1);

    public final void startDrag(DragGestureEvent trigger, Cursor dragCursor, Transferable transferable, DragSourceListener dsl, FlavorMap flavorMap) throws InvalidDnDOperationException {
        this._dragSource.startDrag(trigger, dragCursor, transferable, new MyDragSourceListener(dsl), flavorMap);
    }

    public final void startDrag(DragGestureEvent trigger, Cursor dragCursor, Image dragImage, Point dragOffset, Transferable transferable, DragSourceListener dsl) throws InvalidDnDOperationException {
        this._dragSource.startDrag(trigger, dragCursor, dragImage, dragOffset, transferable, new MyDragSourceListener(dsl));
    }

    public final void startDrag(DragGestureEvent trigger, Cursor dragCursor, Transferable transferable, DragSourceListener dsl) throws InvalidDnDOperationException {
        this._dragSource.startDrag(trigger, dragCursor, transferable, new MyDragSourceListener(dsl));
    }

    public void startDrag(DragGestureEvent trigger, Cursor dragCursor, Image dragImage, Point imageOffset, Transferable transferable, DragSourceListener dsl, FlavorMap flavorMap) throws InvalidDnDOperationException {
        this._dragSource.startDrag(trigger, dragCursor, dragImage, imageOffset, transferable, dsl, flavorMap);
    }

    private DragAndDropAwareInteractor getActiveInteractor(IlvManagerView view) {
        if (view == null) {
            return null;
        }
        IlvManagerViewInteractor interactor = view.getInteractor();
        if (interactor instanceof DragAndDropAwareInteractor) {
            return (DragAndDropAwareInteractor)interactor;
        }
        return null;
    }

    private final class MyDropTargetListener
    implements DropTargetListener {
        private final DropTargetListener _chained;

        private MyDropTargetListener(DropTargetListener chained) {
            this._chained = chained;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (ManagerViewDragAndDropController.this._initiatorView != null && ManagerViewDragAndDropController.this._dt.getComponent() == dtde.getDropTargetContext().getComponent() && ManagerViewDragAndDropController.this._nativeFlavor != null && dtde.isDataFlavorSupported(ManagerViewDragAndDropController.this._nativeFlavor)) {
                DropTargetListener dsl;
                DragAndDropAwareInteractor i = ManagerViewDragAndDropController.this.getActiveInteractor(ManagerViewDragAndDropController.this._initiatorView);
                if (i != null && (dsl = i.getDropTargetListener()) != null) {
                    dsl.dragEnter(dtde);
                }
            } else {
                this._chained.dragEnter(dtde);
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            DropTargetListener dsl;
            this._chained.dragExit(dte);
            DragAndDropAwareInteractor i = ManagerViewDragAndDropController.this.getActiveInteractor(ManagerViewDragAndDropController.this._initiatorView);
            if (i != null && (dsl = i.getDropTargetListener()) != null) {
                dsl.dragExit(dte);
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (ManagerViewDragAndDropController.this._initiatorView != null && ManagerViewDragAndDropController.this._dt.getComponent() == dtde.getDropTargetContext().getComponent() && ManagerViewDragAndDropController.this._nativeFlavor != null && dtde.isDataFlavorSupported(ManagerViewDragAndDropController.this._nativeFlavor)) {
                DropTargetListener dsl;
                DragAndDropAwareInteractor i = ManagerViewDragAndDropController.this.getActiveInteractor(ManagerViewDragAndDropController.this._initiatorView);
                if (i != null && (dsl = i.getDropTargetListener()) != null) {
                    dsl.dragOver(dtde);
                }
            } else {
                this._chained.dragOver(dtde);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            if (ManagerViewDragAndDropController.this._initiatorView != null && ManagerViewDragAndDropController.this._dt.getComponent() == dtde.getDropTargetContext().getComponent()) {
                DropTargetListener dsl;
                ManagerViewDragAndDropController.this._droppedElsewhere = false;
                DragAndDropAwareInteractor i = ManagerViewDragAndDropController.this.getActiveInteractor(ManagerViewDragAndDropController.this._initiatorView);
                if (i != null && (dsl = i.getDropTargetListener()) != null) {
                    dsl.drop(dtde);
                }
                ManagerViewDragAndDropController.this._dropPerformed = true;
            } else {
                ManagerViewDragAndDropController.this._droppedElsewhere = true;
                this._chained.drop(dtde);
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            if (ManagerViewDragAndDropController.this._initiatorView != null && ManagerViewDragAndDropController.this._dt.getComponent() == dtde.getDropTargetContext().getComponent() && ManagerViewDragAndDropController.this._nativeFlavor != null && dtde.isDataFlavorSupported(ManagerViewDragAndDropController.this._nativeFlavor)) {
                DropTargetListener dsl;
                DragAndDropAwareInteractor i = ManagerViewDragAndDropController.this.getActiveInteractor(ManagerViewDragAndDropController.this._initiatorView);
                if (i != null && (dsl = i.getDropTargetListener()) != null) {
                    dsl.dropActionChanged(dtde);
                }
            } else {
                this._chained.dropActionChanged(dtde);
            }
        }
    }

    private final class MyDragSourceListener
    implements DragSourceListener {
        private final DragSourceListener _chained;

        private MyDragSourceListener(DragSourceListener chained) {
            this._chained = chained;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            try {
                DragSourceListener dsl;
                DragAndDropAwareInteractor i;
                this._chained.dragDropEnd(dsde);
                if ((!ManagerViewDragAndDropController.this._dropProcessed || ManagerViewDragAndDropController.this._droppedElsewhere) && (i = ManagerViewDragAndDropController.this.getActiveInteractor(ManagerViewDragAndDropController.this._view)) != null) {
                    ManagerViewDragAndDropController.this._view.popInteractor();
                }
                if ((i = ManagerViewDragAndDropController.this.getActiveInteractor(ManagerViewDragAndDropController.this._initiatorView)) != null && (dsl = i.getDragSourceListener()) != null) {
                    dsl.dragDropEnd(dsde);
                }
            }
            finally {
                ManagerViewDragAndDropController.this._initiatorView = null;
                ManagerViewDragAndDropController.this._dropProcessed = false;
                ManagerViewDragAndDropController.this._droppedElsewhere = false;
                ManagerViewDragAndDropController.this._dropPerformed = false;
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
            DragSourceListener dsl;
            this._chained.dragEnter(dsde);
            DragAndDropAwareInteractor i = ManagerViewDragAndDropController.this.getActiveInteractor(ManagerViewDragAndDropController.this._initiatorView);
            if (i != null && (dsl = i.getDragSourceListener()) != null) {
                dsl.dragEnter(dsde);
            }
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
            DragSourceListener dsl;
            this._chained.dragExit(dse);
            DragAndDropAwareInteractor i = ManagerViewDragAndDropController.this.getActiveInteractor(ManagerViewDragAndDropController.this._initiatorView);
            if (i != null && (dsl = i.getDragSourceListener()) != null) {
                dsl.dragExit(dse);
            }
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
            DragSourceListener dsl;
            this._chained.dragOver(dsde);
            DragAndDropAwareInteractor i = ManagerViewDragAndDropController.this.getActiveInteractor(ManagerViewDragAndDropController.this._initiatorView);
            if (i != null && (dsl = i.getDragSourceListener()) != null) {
                dsl.dragOver(dsde);
            }
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
            DragSourceListener dsl;
            this._chained.dropActionChanged(dsde);
            DragAndDropAwareInteractor i = ManagerViewDragAndDropController.this.getActiveInteractor(ManagerViewDragAndDropController.this._initiatorView);
            if (i != null && (dsl = i.getDragSourceListener()) != null) {
                dsl.dropActionChanged(dsde);
            }
        }
    }

    private final class MyDragGestureListener
    implements DragGestureListener {
        private MyDragGestureListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            ManagerViewDragAndDropController.this._initiatorView = (IlvManagerView)((DragGestureRecognizer)dge.getSource()).getComponent();
            try {
                ManagerViewDragAndDropController.this.dragGestureRecognized(dge);
            }
            finally {
                DragGestureListener dgl;
                DragAndDropAwareInteractor i = ManagerViewDragAndDropController.this.getActiveInteractor(ManagerViewDragAndDropController.this._initiatorView);
                if (i != null && (dgl = i.getDragGestureListener()) != null) {
                    dgl.dragGestureRecognized(dge);
                }
            }
        }
    }

    private final class MyDropTarget
    extends DropTarget {
        private boolean m_isActive;

        private MyDropTarget(Component c, int actions, DropTargetListener dtl) {
            super(c, actions, dtl);
            this.m_isActive = false;
            this.setActive(true);
            c.setDropTarget(this);
        }

        public void startAutoScrolling(Point point) {
            if (!this.m_isActive) {
                this.initializeAutoscrolling(point);
                this.m_isActive = true;
            }
        }

        public void stopAutoScrolling() {
            if (this.m_isActive) {
                this.clearAutoscroll();
                this.m_isActive = false;
            }
        }

        @Override
        protected void initializeAutoscrolling(Point p) {
            this.clearAutoscroll();
            super.initializeAutoscrolling(p);
        }
    }

    private final class MyDragGestureRecognizer
    extends MouseDragGestureRecognizer {
        private MyDragGestureRecognizer(DragSource ds, Component c, int act, DragGestureListener dgl) {
            super(ds, c, act, dgl);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (ManagerViewDragAndDropController.this._view.hasFocus() && ManagerViewDragAndDropController.this._view.getInteractor() instanceof MoveInteractorMarker) {
                Dimension size = this.getComponent().getSize();
                Rectangle rect = new Rectangle(0, 0, size.width, size.height);
                if (!rect.contains(e.getPoint())) {
                    this.appendEvent(e);
                    this.fireDragGestureRecognized(1, ((MouseEvent)this.getTriggerEvent()).getPoint());
                }
            } else {
                this.events.clear();
            }
            ManagerViewDragAndDropController.this._dt.stopAutoScrolling();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (ManagerViewDragAndDropController.this._view.hasFocus() && ManagerViewDragAndDropController.this._view.getInteractor() instanceof MoveInteractorMarker) {
                Dimension size = this.getComponent().getSize();
                Rectangle rect = new Rectangle(0, 0, size.width, size.height);
                if (!rect.contains(e.getPoint())) {
                    this.appendEvent(e);
                    this.fireDragGestureRecognized(1, ((MouseEvent)this.getTriggerEvent()).getPoint());
                }
            } else {
                this.events.clear();
            }
            ManagerViewDragAndDropController.this._dt.stopAutoScrolling();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.appendEvent(e);
            if (this.dragOccurredInAutoScrollExtents(e)) {
                ManagerViewDragAndDropController.this._dt.startAutoScrolling(e.getPoint());
            } else {
                ManagerViewDragAndDropController.this._dt.stopAutoScrolling();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ManagerViewDragAndDropController.this._dt.stopAutoScrolling();
        }

        private boolean dragOccurredInAutoScrollExtents(MouseEvent e) {
            Component c = ManagerViewDragAndDropController.this._dt.getComponent();
            if (!(c instanceof Autoscroll)) {
                return false;
            }
            Point eventPoint = e.getPoint();
            Insets scrollInsets = ((Autoscroll)((Object)c)).getAutoscrollInsets();
            Rectangle bounds = this.getComponent().getBounds();
            Rectangle outerBounds = this.getComponent().getBounds();
            bounds.x += scrollInsets.left;
            bounds.y += scrollInsets.top;
            bounds.width -= scrollInsets.right + scrollInsets.left;
            bounds.height -= scrollInsets.bottom + scrollInsets.top;
            return !bounds.contains(eventPoint) && outerBounds.contains(eventPoint);
        }
    }
}

