/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.dragdrop;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.dragdrop.DiagramDropPlugin;
import oracle.diagram.framework.dragdrop.event.DiagramDropTargetDragEvent;
import oracle.diagram.framework.dragdrop.event.DiagramDropTargetDropEvent;
import oracle.diagram.framework.dragdrop.event.DiagramDropTargetEvent;
import oracle.diagram.framework.palette.PalettePlugin;
import oracle.diagram.framework.palette.event.PaletteItemDropTargetDragEvent;
import oracle.diagram.framework.palette.event.PaletteItemDropTargetDropEvent;
import oracle.diagram.framework.palette.event.PaletteItemDropTargetEvent;
import oracle.diagram.framework.readonly.ReadOnlyUtil;
import oracle.ide.palette2.PaletteItem;
import oracle.javatools.dnd.DndUtils;

public class DropTargetHelper
implements DropTargetListener {
    private final DiagramContext _context;
    private DiagramDropPlugin _plugin = null;

    public DropTargetHelper(DiagramContext context) {
        this._context = context;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.paletteDragEnter(dtde)) {
            return;
        }
        if (this._plugin == null && this.getPlugin(DiagramDropPlugin.class) != null) {
            this._plugin = this.getPlugin(DiagramDropPlugin.class);
        }
        if (this._plugin != null) {
            this._plugin.dragEnter(new DiagramDropTargetDragEvent(this.getDiagramContext(), dtde));
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (this.paletteDragOver(dtde)) {
            return;
        }
        if (this._plugin == null && this.getPlugin(DiagramDropPlugin.class) != null) {
            this._plugin = this.getPlugin(DiagramDropPlugin.class);
        }
        if (this._plugin != null) {
            this._plugin.dragOver(new DiagramDropTargetDragEvent(this.getDiagramContext(), dtde));
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        if (this.paletteDropActionChanged(dtde)) {
            return;
        }
        if (this._plugin == null && this.getPlugin(DiagramDropPlugin.class) != null) {
            this._plugin = this.getPlugin(DiagramDropPlugin.class);
        }
        if (this._plugin != null) {
            this._plugin.dropActionChanged(new DiagramDropTargetDragEvent(this.getDiagramContext(), dtde));
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        if (this.paletteDragExit(dte)) {
            return;
        }
        if (this._plugin == null && this.getPlugin(DiagramDropPlugin.class) != null) {
            this._plugin = this.getPlugin(DiagramDropPlugin.class);
        }
        if (this._plugin != null) {
            this._plugin.dragExit(new DiagramDropTargetEvent(this.getDiagramContext(), dte));
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (this.paletteDrop(dtde)) {
            return;
        }
        if (this._plugin == null && this.getPlugin(DiagramDropPlugin.class) != null) {
            this._plugin = this.getPlugin(DiagramDropPlugin.class);
        }
        if (this._plugin != null) {
            this._plugin.drop(new DiagramDropTargetDropEvent(this.getDiagramContext(), dtde));
        }
    }

    private <T extends Plugin> T getPlugin(Class<T> clazz) {
        return PluginUtil.getPlugin(this.getDiagramContext(), clazz);
    }

    private DiagramContext getDiagramContext() {
        return this._context;
    }

    private boolean paletteDragEnter(DropTargetDragEvent dtde) {
        if (!ReadOnlyUtil.checkWritable(this.getDiagramContext())) {
            return false;
        }
        if (!dtde.isDataFlavorSupported(PaletteItem.PALETTE_ITEM_FLAVOR)) {
            return false;
        }
        PalettePlugin pp = this.getPalettePlugin();
        if (pp == null) {
            return false;
        }
        Transferable t = DndUtils.getTransferable((DropTargetEvent)dtde);
        PaletteItem item = this.getPaletteItem(t);
        if (!pp.canHandleItem(item)) {
            return false;
        }
        PaletteItemDropTargetDragEvent pdtde = new PaletteItemDropTargetDragEvent(item, this.getDiagramContext(), dtde);
        pp.dragEnter(pdtde);
        return true;
    }

    private boolean paletteDragOver(DropTargetDragEvent dtde) {
        if (!dtde.isDataFlavorSupported(PaletteItem.PALETTE_ITEM_FLAVOR)) {
            return false;
        }
        PalettePlugin pp = this.getPalettePlugin();
        if (pp == null) {
            return false;
        }
        Transferable t = DndUtils.getTransferable((DropTargetEvent)dtde);
        PaletteItem item = this.getPaletteItem(t);
        if (!pp.canHandleItem(item)) {
            return false;
        }
        PaletteItemDropTargetDragEvent pdtde = new PaletteItemDropTargetDragEvent(item, this.getDiagramContext(), dtde);
        pp.dragOver(pdtde);
        return true;
    }

    private boolean paletteDropActionChanged(DropTargetDragEvent dtde) {
        if (!dtde.isDataFlavorSupported(PaletteItem.PALETTE_ITEM_FLAVOR)) {
            return false;
        }
        PalettePlugin pp = this.getPalettePlugin();
        if (pp == null) {
            return false;
        }
        Transferable t = DndUtils.getTransferable((DropTargetEvent)dtde);
        PaletteItem item = this.getPaletteItem(t);
        if (!pp.canHandleItem(item)) {
            return false;
        }
        PaletteItemDropTargetDragEvent pdtde = new PaletteItemDropTargetDragEvent(item, this.getDiagramContext(), dtde);
        pp.dropActionChanged(pdtde);
        return true;
    }

    private boolean paletteDragExit(DropTargetEvent dte) {
        PalettePlugin pp = this.getPalettePlugin();
        if (pp == null) {
            return false;
        }
        Transferable t = DndUtils.getTransferable((DropTargetEvent)dte);
        if (!t.isDataFlavorSupported(PaletteItem.PALETTE_ITEM_FLAVOR)) {
            return false;
        }
        PaletteItem item = this.getPaletteItem(t);
        if (!pp.canHandleItem(item)) {
            return false;
        }
        PaletteItemDropTargetEvent pdtde = new PaletteItemDropTargetEvent(item, this.getDiagramContext(), dte);
        pp.dragExit(pdtde);
        return true;
    }

    private boolean paletteDrop(DropTargetDropEvent dtde) {
        if (!dtde.isDataFlavorSupported(PaletteItem.PALETTE_ITEM_FLAVOR)) {
            return false;
        }
        PalettePlugin pp = this.getPalettePlugin();
        if (pp == null) {
            return false;
        }
        Transferable t = dtde.getTransferable();
        PaletteItem item = this.getPaletteItem(t);
        if (!pp.canHandleItem(item)) {
            return false;
        }
        PaletteItemDropTargetDropEvent pdtde = new PaletteItemDropTargetDropEvent(item, this.getDiagramContext(), dtde);
        pp.drop(pdtde);
        return true;
    }

    private PalettePlugin getPalettePlugin() {
        PalettePlugin pp = this.getPlugin(PalettePlugin.class);
        return pp;
    }

    private PaletteItem getPaletteItem(Transferable transferable) {
        if (!transferable.isDataFlavorSupported(PaletteItem.PALETTE_ITEM_FLAVOR)) {
            return null;
        }
        try {
            PaletteItem item = (PaletteItem)transferable.getTransferData(PaletteItem.PALETTE_ITEM_FLAVOR);
            return item;
        }
        catch (UnsupportedFlavorException ufx) {
            return null;
        }
        catch (IOException iox) {
            return null;
        }
    }
}

