/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.datatransfer;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import oracle.diagram.framework.manager.ManagerUtil;

public final class SelectionTransferData {
    private static final String REFPOINT_AVAILABLE = "refpointAvailable";
    private static final String REFPOINT_POINT = "refpointLoc";

    private SelectionTransferData() {
    }

    public static String serializeSelection(IlvManager manager) throws IOException {
        return SelectionTransferData.serializeSelection(manager, null);
    }

    public static String serializeSelection(IlvManager manager, IlvPoint refPoint) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IlvOutputStream ios = ManagerUtil.createOutputStream(manager, baos);
        if (refPoint != null) {
            ios.write(REFPOINT_AVAILABLE, true);
            ios.write(REFPOINT_POINT, refPoint);
        } else {
            ios.write(REFPOINT_AVAILABLE, false);
        }
        ios.write(manager, true);
        ios.flush();
        String str = baos.toString();
        baos.close();
        return str;
    }

    public static IlvGraphicEnumeration deserializeTo(IlvManager manager, String data, IlvPoint point, boolean select) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data.getBytes());
        IlvInputStream iis = ManagerUtil.createInputStream(manager, bais);
        iis.setDocumentBase(manager.getFileName());
        iis.setCopyPasteMode();
        try {
            manager.initReDraws();
            manager.setContentsAdjusting(true);
            manager.setSelectionAdjusting(true);
            ManagerUtil.invalidateAllViews(manager);
            IlvPoint refPoint = null;
            if (iis.readBoolean(REFPOINT_AVAILABLE)) {
                refPoint = iis.readPoint(REFPOINT_POINT);
            }
            iis.read((IlvGraphicBag)manager);
            try {
                bais.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (select) {
                manager.deSelectAll(true, false);
                IlvGraphicEnumeration e = iis.getObjects();
                while (e.hasMoreElements()) {
                    manager.setSelected(e.nextElement(), true, false);
                }
            }
            if (point != null) {
                IlvGraphic g;
                IlvRect r = null;
                IlvGraphicEnumeration e = iis.getObjects();
                while (e.hasMoreElements()) {
                    g = e.nextElement();
                    if (!manager.isManaged(g)) continue;
                    if (r == null) {
                        r = new IlvRect(g.boundingBox(null));
                        continue;
                    }
                    r.add(g.boundingBox(null));
                }
                if (r != null) {
                    float dx = refPoint != null ? point.x - refPoint.x - (refPoint.x - r.x) : point.x - r.x;
                    float dy = refPoint != null ? point.y - refPoint.y - (refPoint.y - r.y) : point.y - r.y;
                    IlvGraphicEnumeration e2 = iis.getObjects();
                    while (e2.hasMoreElements()) {
                        g = e2.nextElement();
                        if (!manager.isManaged(g)) continue;
                        IlvRect bbox = g.boundingBox(null);
                        manager.moveObject(g, bbox.x + dx, bbox.y + dy, false);
                    }
                }
            }
            IlvGraphicEnumeration ilvGraphicEnumeration = iis.getObjects();
            return ilvGraphicEnumeration;
        }
        catch (IlvReadFileException rfex) {
            throw new IOException(rfex.getMessage());
        }
        finally {
            if (manager.getParent() != null) {
                manager.getParent().reDrawObj((IlvGraphic)manager);
            }
            manager.setSelectionAdjusting(false);
            manager.setContentsAdjusting(false);
            manager.reDrawViews();
        }
    }
}

