/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.copypaste;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.copypaste.AbstractCopyPastePlugin;
import oracle.diagram.framework.readonly.ReadOnlyUtil;

public class NativeJViewsCopyPastePlugin
extends AbstractCopyPastePlugin {
    public NativeJViewsCopyPastePlugin(DiagramContext context) {
        super(context);
    }

    @Override
    public boolean canCopy() {
        if (!this.hasSelection()) {
            return super.canCopy();
        }
        return true;
    }

    @Override
    public boolean canCut() {
        if (ReadOnlyUtil.isPermanentReadOnlyContext(this.getDiagramContext())) {
            return false;
        }
        if (!this.hasSelection()) {
            return super.canCut();
        }
        return true;
    }

    @Override
    public boolean canPaste() {
        if (ReadOnlyUtil.isPermanentReadOnlyContext(this.getDiagramContext())) {
            return false;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (!clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
            return super.canPaste();
        }
        return true;
    }

    @Override
    public void copy() {
        IlvManager mgr;
        if (this.canCopy() && (mgr = this.getManager()) != null) {
            mgr.copySelection();
        }
    }

    @Override
    public void cut() {
        IlvManager mgr;
        if (this.canCut() && (mgr = this.getManager()) != null) {
            ArrayList<IlvGraphic> graphics = new ArrayList<IlvGraphic>(mgr.getSelectedObjectsCount(true));
            IlvGraphicEnumeration e = mgr.getSelectedObjects(true);
            while (e.hasMoreElements()) {
                graphics.add(e.nextElement());
            }
            if (!ReadOnlyUtil.checkWritableCut(this.getDiagramContext(), graphics.toArray(new IlvGraphic[graphics.size()]))) {
                return;
            }
            mgr.copySelection();
            this.deleteForCut();
        }
    }

    protected void deleteForCut() {
        IlvManager mgr = this.getManager();
        if (mgr != null) {
            mgr.deleteSelections(true, true);
        }
    }

    @Override
    public void paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
            Transferable contents;
            IlvManagerView view = this.getDiagramContext().getManagerView();
            if (view == null) {
                return;
            }
            IlvManager mgr = view.getManager();
            if (mgr == null) {
                return;
            }
            IlvPoint ptCenter = new IlvPoint((float)(view.getX() + view.getWidth() / 2), (float)(view.getY() + view.getHeight() / 2));
            view.getTransformer().inverse(ptCenter);
            if (clipboard != null && (contents = clipboard.getContents(new ClipboardOwner(){

                @Override
                public void lostOwnership(Clipboard clipboard, Transferable contents) {
                }
            })) != null && !ReadOnlyUtil.checkWritablePaste(this.getDiagramContext(), contents)) {
                return;
            }
            this.postPaste(mgr.pasteSelection(ptCenter, true));
        } else {
            super.paste();
        }
    }

    protected void postPaste(IlvGraphicEnumeration pastedGraphics) {
    }

    protected boolean hasSelection() {
        IlvManager mgr = this.getManager();
        if (mgr == null) {
            return false;
        }
        return mgr.getSelectedObjectsCount() > 0;
    }

    protected IlvManager getManager() {
        IlvManagerView view = this.getDiagramContext().getManagerView();
        if (view == null) {
            return null;
        }
        IlvManager mgr = view.getManager();
        return mgr;
    }
}

