/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.copypaste;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.util.Arrays;
import java.util.List;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.framework.copypaste.CopyPastePlugin;
import oracle.diagram.framework.copypaste.PasteFlavorHandler;
import oracle.diagram.framework.datatransfer.PrioritizedHandlers;

public abstract class AbstractCopyPastePlugin
extends AbstractPlugin
implements CopyPastePlugin {
    private final DiagramContext _context;
    private PrioritizedHandlers _handlers = new PrioritizedHandlers();

    protected AbstractCopyPastePlugin(DiagramContext context) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        this._context = context;
    }

    public void registerPasteHandler(PasteFlavorHandler handler, float priority) {
        this._handlers.addHandler(handler.getDataFlavor(), handler, priority);
    }

    public void removePasteHandler(DataFlavor flavor) {
        this._handlers.removeHandler(flavor);
    }

    @Override
    public boolean canCopy() {
        return false;
    }

    @Override
    public boolean canCut() {
        return false;
    }

    @Override
    public boolean canPaste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        List<DataFlavor> flavors = Arrays.asList(clipboard.getAvailableDataFlavors());
        PasteFlavorHandler h = (PasteFlavorHandler)this._handlers.getPriorityHandler(flavors);
        if (h != null) {
            return h.canPaste();
        }
        return false;
    }

    @Override
    public boolean canPasteSpecial() {
        return false;
    }

    @Override
    public void copy() {
    }

    @Override
    public void cut() {
    }

    @Override
    public void paste() {
    }

    @Override
    public void pasteSpecial() {
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }
}

