/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.accessibility;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import oracle.diagram.core.context.DiagramView;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.accessibility.NavigableGraphicPlugin;
import oracle.diagram.framework.accessibility.PresentableGraphicPlugin;
import oracle.diagram.framework.graphic.GraphicDescriptor;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controls.ToggleAction;
import oracle.javatools.util.BundleLoader;

public class NavigateContextMenuBuilder {
    private static final ResourceBundle RB = BundleLoader.getBundle((String)"oracle.diagram.res.AccessibilityResources");
    private static final float PARENT_WEIGHT = 100.0f;
    private static final float ENDS_WEIGHT = 200.0f;
    private static final float LINKS_WEIGHT = 300.0f;
    private static final float CONTENTS_WEIGHT = 400.0f;
    private static final float CHILDREN_WEIGHT = 500.0f;
    private IlvManagerView _view;

    public final void buildAndAddNavigateMenu(ContextMenu menu, IlvGraphic graphic) {
        DiagramView dv;
        Context context = menu.getContext();
        DiagramView diagramView = dv = context.getView() instanceof DiagramView ? (DiagramView)context.getView() : null;
        if (dv == null) {
            return;
        }
        this._view = dv.getActiveManagerView();
        if (this._view == null) {
            return;
        }
        IlvManagerView view = this._view;
        NavigableGraphicPlugin ngp = this.getNavigableGraphicPlugin(graphic);
        if (ngp != null) {
            List<IlvGraphic> children;
            List<IlvGraphic> contents;
            List<IlvLinkImage> links;
            List<IlvGraphic> ends;
            List<IlvGraphic> selectableEnds;
            JMenu nav = null;
            IlvGraphic parent = ngp.getNavigableParent(graphic);
            if (parent != null && parent != view.getManager() && ngp.isSelectable(parent)) {
                if (nav == null) {
                    nav = this.createNavigateJMenu(menu);
                }
                this.addParentItem(view, menu, nav, 100.0f, ngp, parent);
            }
            if (graphic instanceof IlvLinkImage && (selectableEnds = this.filterSelectable(ngp, ends = ngp.getNavigableEnds((IlvLinkImage)graphic))) != null && !selectableEnds.isEmpty()) {
                if (nav == null) {
                    nav = this.createNavigateJMenu(menu);
                }
                this.addEnds(view, menu, nav, ngp, ends, selectableEnds);
            }
            if ((links = this.filterSelectable(ngp, ngp.getNavigableLinks(graphic))) != null && !links.isEmpty()) {
                if (nav == null) {
                    nav = this.createNavigateJMenu(menu);
                }
                this.addLinks(view, menu, nav, ngp, links);
            }
            if ((contents = this.filterSelectable(ngp, ngp.getNavigableContents(graphic))) != null && !contents.isEmpty()) {
                if (nav == null) {
                    nav = this.createNavigateJMenu(menu);
                }
                this.addContents(view, menu, nav, ngp, contents);
            }
            if (graphic instanceof IlvManager && (children = this.filterSelectable(ngp, ngp.getNavigableChildren((IlvManager)graphic))) != null && !children.isEmpty()) {
                if (nav == null) {
                    nav = this.createNavigateJMenu(menu);
                }
                this.addChildren(view, menu, nav, ngp, children);
            }
            if (nav != null) {
                menu.add((Component)nav, this.getNavigateSectionId());
            }
        }
    }

    protected float getNavigateWeight() {
        return Float.MAX_VALUE;
    }

    protected float getNavigateSectionId() {
        return Float.MAX_VALUE;
    }

    protected float getNavigateAddinSectionId() {
        return Float.MAX_VALUE;
    }

    protected ToggleAction createAction(IlvManagerView view, NavigableGraphicPlugin ngp, IlvGraphic graphic, String template, float weight) {
        String tmp;
        GraphicDescriptor gd;
        String name = RB.getString("NavigateMenu.noName.text");
        PresentableGraphicPlugin pgp = this.getPresentableGraphicPlugin(graphic);
        if (pgp != null && (gd = pgp.getGraphicDescriptor(graphic)) != null && (tmp = gd.getName()) != null && tmp.length() != 0) {
            name = tmp;
        }
        String text = MessageFormat.format(template, name);
        return new StandardAction(view, text, ngp, graphic, weight);
    }

    protected String getActionNameTemplate(NavigationType type) {
        switch (type) {
            case PARENT: {
                return RB.getString("NavigateMenu.parentItem.text");
            }
            case CONTENT_ITEM: {
                return RB.getString("NavigateMenu.contentItem.text");
            }
            case CHILD: {
                return RB.getString("NavigateMenu.childItem.text");
            }
            case LINK: {
                return RB.getString("NavigateMenu.linkItem.text");
            }
            case SOURCE_END: {
                return RB.getString("NavigateMenu.sourceItem.text");
            }
            case DESTINATION_END: {
                return RB.getString("NavigateMenu.destinationItem.text");
            }
        }
        throw new IllegalArgumentException("unsupported NavigationType: " + (Object)((Object)type));
    }

    protected NavigableGraphicPlugin getNavigableGraphicPlugin(IlvGraphic g) {
        return this.getPlugin(g, NavigableGraphicPlugin.class);
    }

    protected PresentableGraphicPlugin getPresentableGraphicPlugin(IlvGraphic g) {
        return this.getPlugin(g, PresentableGraphicPlugin.class);
    }

    protected <T extends Plugin> T getPlugin(IlvGraphic g, Class<T> key) {
        return PluginUtil.getPlugin(this.getView(), g, key);
    }

    protected final IlvManagerView getView() {
        return this._view;
    }

    private JMenu createNavigateJMenu(ContextMenu contextMenu) {
        JMenu menu = contextMenu.createMenu(RB.getString("NavigateMenu.menuName.text"), Integer.valueOf(RB.getString("NavigateMenu.menuName.mnemonic").charAt(0)), this.getNavigateWeight(), this.getNavigateAddinSectionId());
        return menu;
    }

    private void addParentItem(IlvManagerView view, ContextMenu menu, JMenu nav, float weight, NavigableGraphicPlugin ngp, IlvGraphic graphic) {
        if (graphic != NavigableGraphicPlugin.SEPARATOR_GRAPHIC) {
            ToggleAction a = this.createNavigateAction(view, ngp, graphic, NavigationType.PARENT, weight);
            menu.add((Component)menu.createMenuItem(a), nav);
        }
    }

    private void addEnd(IlvManagerView view, ContextMenu menu, JMenu endMenu, float weight, NavigableGraphicPlugin ngp, IlvGraphic end, boolean source) {
        if (end != NavigableGraphicPlugin.SEPARATOR_GRAPHIC) {
            ToggleAction a = this.createNavigateAction(view, ngp, end, source ? NavigationType.SOURCE_END : NavigationType.DESTINATION_END, weight);
            menu.add((Component)menu.createMenuItem(a), endMenu);
        }
    }

    private void addContentItem(IlvManagerView view, ContextMenu menu, JMenu contentMenu, float weight, NavigableGraphicPlugin ngp, IlvGraphic contentItem) {
        if (contentItem != NavigableGraphicPlugin.SEPARATOR_GRAPHIC) {
            ToggleAction a = this.createNavigateAction(view, ngp, contentItem, NavigationType.CONTENT_ITEM, weight);
            menu.add((Component)menu.createMenuItem(a), contentMenu);
        } else {
            this.addSeparator(menu, contentMenu, weight);
        }
    }

    private void addLink(IlvManagerView view, ContextMenu menu, JMenu linkMenu, float weight, NavigableGraphicPlugin ngp, IlvLinkImage link) {
        if (link != NavigableGraphicPlugin.SEPARATOR_GRAPHIC) {
            ToggleAction a = this.createNavigateAction(view, ngp, (IlvGraphic)link, NavigationType.LINK, weight);
            menu.add((Component)menu.createMenuItem(a), linkMenu);
        }
    }

    private void addChild(IlvManagerView view, ContextMenu menu, JMenu childMenu, float weight, NavigableGraphicPlugin ngp, IlvGraphic child) {
        if (child != NavigableGraphicPlugin.SEPARATOR_GRAPHIC) {
            ToggleAction a = this.createNavigateAction(view, ngp, child, NavigationType.CHILD, weight);
            menu.add((Component)menu.createMenuItem(a), childMenu);
        } else {
            this.addSeparator(menu, childMenu, weight);
        }
    }

    private void addSeparator(ContextMenu menu, JMenu parentMenu, float weight) {
        JSeparator s = new JSeparator();
        s.putClientProperty("menu-weight", Float.valueOf(weight));
        menu.add((Component)s, parentMenu);
    }

    private ToggleAction createNavigateAction(IlvManagerView view, NavigableGraphicPlugin ngp, IlvGraphic graphic, NavigationType type, float weight) {
        String template = this.getActionNameTemplate(type);
        return this.createAction(view, ngp, graphic, template, weight);
    }

    private void addLinks(IlvManagerView view, ContextMenu menu, JMenu nav, NavigableGraphicPlugin ngp, List<IlvLinkImage> links) {
        JMenu linkMenu = menu.createMenu(RB.getString("LinksMenu.menuName.text"), Integer.valueOf(RB.getString("LinksMenu.menuName.mnemonic").charAt(0)), 300.0f);
        menu.add((Component)linkMenu, nav);
        float weight = 300.0f;
        for (IlvLinkImage link : links) {
            this.addLink(view, menu, linkMenu, weight, ngp, link);
            weight += 1.0f;
        }
    }

    private void addChildren(IlvManagerView view, ContextMenu menu, JMenu nav, NavigableGraphicPlugin ngp, List<IlvGraphic> children) {
        JMenu childMenu = menu.createMenu(RB.getString("ChildrenMenu.menuName.text"), Integer.valueOf(RB.getString("ChildrenMenu.menuName.mnemonic").charAt(0)), 500.0f);
        menu.add((Component)childMenu, nav);
        float weight = 500.0f;
        for (IlvGraphic child : children) {
            this.addChild(view, menu, childMenu, weight, ngp, child);
            weight += 1.0f;
        }
    }

    private void addContents(IlvManagerView view, ContextMenu menu, JMenu nav, NavigableGraphicPlugin ngp, List<IlvGraphic> contents) {
        JMenu contentMenu = menu.createMenu(RB.getString("ContentsMenu.menuName.text"), Integer.valueOf(RB.getString("ContentsMenu.menuName.mnemonic").charAt(0)), 400.0f);
        menu.add((Component)contentMenu, nav);
        float weight = 400.0f;
        for (IlvGraphic contentItem : contents) {
            this.addContentItem(view, menu, contentMenu, weight, ngp, contentItem);
            weight += 1.0f;
        }
    }

    private void addEnds(IlvManagerView view, ContextMenu menu, JMenu nav, NavigableGraphicPlugin ngp, List<IlvGraphic> ends, List<IlvGraphic> selectableEnds) {
        float weight = 200.0f;
        IlvGraphic src = ends.get(0);
        for (IlvGraphic end : selectableEnds) {
            this.addEnd(view, menu, nav, weight, ngp, end, end == src);
            weight += 1.0f;
        }
    }

    protected <T extends IlvGraphic> List<T> filterSelectable(NavigableGraphicPlugin ngp, List<T> graphics) {
        if (graphics == null || graphics.isEmpty()) {
            return graphics;
        }
        ArrayList<IlvGraphic> result = new ArrayList<IlvGraphic>(graphics.size());
        for (IlvGraphic g : graphics) {
            if (!ngp.isSelectable(g)) continue;
            result.add(g);
        }
        return result;
    }

    protected static class StandardAction
    extends ToggleAction {
        private final IlvManagerView _view;
        private final IlvGraphic _graphic;
        private final NavigableGraphicPlugin _ngp;

        public StandardAction(IlvManagerView view, String name, NavigableGraphicPlugin ngp, IlvGraphic g, float weight) {
            super(name, null);
            this._view = view;
            this._graphic = g;
            this._ngp = ngp;
            this.setMenuWeight(weight);
        }

        public void actionPerformed(ActionEvent e) {
            this.getNavigableGraphicPlugin().navigateTo(this.getView(), this.getGraphic(), true);
        }

        protected final IlvManagerView getView() {
            return this._view;
        }

        protected final IlvGraphic getGraphic() {
            return this._graphic;
        }

        protected final NavigableGraphicPlugin getNavigableGraphicPlugin() {
            return this._ngp;
        }
    }

    public static enum NavigationType {
        PARENT,
        CONTENT_ITEM,
        CHILD,
        LINK,
        SOURCE_END,
        DESTINATION_END;

    }
}

