/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.accessibility;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ManagerSelectionChangedEvent;
import ilog.views.event.ManagerSelectionListener;
import ilog.views.event.ManagerViewsChangedEvent;
import ilog.views.event.ManagerViewsChangedListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.accessibility.AccessibleGraphicPlugin;
import oracle.diagram.framework.accessibility.AccessibleManager;
import oracle.diagram.framework.accessibility.HCGraphics2D;
import oracle.diagram.framework.manager.VisibleObjectsIterator;
import oracle.diagram.framework.view.ViewUtil;

public class AccessibleManagerView
extends IlvManagerView
implements Accessible {
    private final IlvPoint _tmpPt = new IlvPoint();
    private final Map<IlvGraphic, Accessible> _cache = new HashMap<IlvGraphic, Accessible>(1365);
    private AccessibleViewContext _ac;
    private boolean inInputVerifier;

    public AccessibleManagerView(IlvManager manager) {
        super(manager);
        this.setMinZoomXFactor(ViewUtil.MIMINUM_SCALE);
        this.setMinZoomYFactor(ViewUtil.MIMINUM_SCALE);
        this.setKeepingAspectRatio(true);
        this.setBackground(Color.WHITE);
        this.setAntialiasing(true);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this._ac == null) {
            this._ac = new AccessibleViewContext();
        }
        return this._ac;
    }

    public final Accessible getAccessibleGraphic(IlvGraphic g) {
        Accessible a = this._cache.get(g);
        if (a != null) {
            return a;
        }
        a = this.getAccessibleGraphicImpl(g);
        if (a != null) {
            this._cache.put(g, a);
        }
        return a;
    }

    protected Accessible getAccessibleGraphicImpl(IlvGraphic g) {
        AccessibleGraphicPlugin agp = this.getPlugin(g, AccessibleGraphicPlugin.class);
        if (agp != null) {
            return agp.getAccessible(g, this);
        }
        return null;
    }

    public <T extends Plugin> T getPlugin(IlvGraphic g, Class<T> key) {
        return PluginUtil.getPlugin(this, g, key);
    }

    protected void managerChanged(IlvManager oldMgr, IlvManager newMgr) {
        if (this._ac != null) {
            this._ac.managerChanged(oldMgr, newMgr);
        }
        super.managerChanged(oldMgr, newMgr);
    }

    public void requestFocus() {
        if (this.runInputVerifier()) {
            super.requestFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runInputVerifier() {
        Window window;
        if (this.inInputVerifier) {
            return true;
        }
        Component focOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focOwner == null && (window = SwingUtilities.getWindowAncestor((Component)((Object)this))) != null) {
            try {
                Method accessibleMethod = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws Exception {
                        Method method = KeyboardFocusManager.class.getDeclaredMethod("getMostRecentFocusOwner", Window.class);
                        method.setAccessible(true);
                        return method;
                    }
                });
                focOwner = (Component)accessibleMethod.invoke(null, window);
            }
            catch (Exception e) {
                focOwner = null;
            }
        }
        if (focOwner == this) {
            return true;
        }
        if (focOwner == null || !(focOwner instanceof JComponent)) {
            return true;
        }
        JComponent jFocOwner = (JComponent)focOwner;
        InputVerifier inputVerifier = jFocOwner.getInputVerifier();
        if (inputVerifier == null) {
            return true;
        }
        this.inInputVerifier = true;
        try {
            boolean bl = inputVerifier.shouldYieldFocus(jFocOwner);
            return bl;
        }
        finally {
            this.inInputVerifier = false;
        }
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        super.repaint(tm, x, y, width, height);
    }

    public void repaint(IlvRect r) {
        super.repaint(r);
    }

    public void paint(Graphics g) {
        super.paint(HCGraphics2D.get(g));
    }

    protected class AccessibleViewContext
    extends Container.AccessibleAWTContainer
    implements AccessibleSelection {
        private final SelectionListener _selListener;
        private final ManagerContentChangedListener _mgrListener;
        private final ViewsChangedListener _viewListener;
        private AccessibleManager _am;

        public AccessibleViewContext() {
            super((Container)((Object)AccessibleManagerView.this));
            this._selListener = new SelectionListener();
            this._mgrListener = new ManagerChangeListener();
            this._viewListener = new ViewsChangedListener();
            this.managerChanged(null, AccessibleManagerView.this.getManager());
        }

        protected void managerChanged(IlvManager oldMgr, IlvManager newMgr) {
            if (oldMgr != null) {
                oldMgr.removeManagerTreeSelectionListener((ManagerSelectionListener)this._selListener);
                oldMgr.removeManagerTreeContentChangedListener(this._mgrListener);
                oldMgr.removeManagerViewsListener((ManagerViewsChangedListener)this._viewListener);
                this._am = null;
            }
            AccessibleManagerView.this._cache.clear();
            if (newMgr != null) {
                this._am = new AccessibleManager(AccessibleManagerView.this, newMgr){

                    @Override
                    public Accessible getAccessibleParent() {
                        return AccessibleManagerView.this;
                    }

                    @Override
                    public int getAccessibleIndexInParent() {
                        return 0;
                    }

                    @Override
                    protected boolean isSelected() {
                        return false;
                    }

                    @Override
                    protected boolean isSelectable() {
                        return false;
                    }
                };
                newMgr.addManagerTreeSelectionListener((ManagerSelectionListener)this._selListener);
                newMgr.addManagerTreeContentChangedListener(this._mgrListener);
                newMgr.addManagerViewsListener((ManagerViewsChangedListener)this._viewListener);
            }
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            AccessibleManagerView.this._tmpPt.setLocation(p.getX(), p.getY());
            IlvGraphic g = AccessibleManagerView.this.getManager().getObject(AccessibleManagerView.this._tmpPt, (IlvManagerView)AccessibleManagerView.this, false);
            if (g != null) {
                return AccessibleManagerView.this.getAccessibleGraphic(g);
            }
            return AccessibleManagerView.this;
        }

        @Override
        public int getAccessibleIndexInParent() {
            return 0;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return this._am.getAccessibleChildrenCount();
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            return this._am.getAccessibleChild(i);
        }

        @Override
        public Locale getLocale() throws IllegalComponentStateException {
            return AccessibleManagerView.this.getLocale();
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public int getAccessibleSelectionCount() {
            return AccessibleManagerView.this.getManager().getSelectedObjectsCount(true);
        }

        @Override
        public Accessible getAccessibleSelection(int i) {
            IlvGraphic g = this.getSelected(i);
            return AccessibleManagerView.this.getAccessibleGraphic(g);
        }

        @Override
        public void addAccessibleSelection(int i) {
            IlvGraphic g = this.getChild(i);
            if (g != null) {
                AccessibleManagerView.this.getManager().setSelected(g, true, true);
            }
        }

        @Override
        public void clearAccessibleSelection() {
            AccessibleManagerView.this.getManager().deSelectAll(true, true);
        }

        @Override
        public boolean isAccessibleChildSelected(int i) {
            IlvGraphic g = this.getChild(i);
            if (g != null) {
                return ((IlvManager)g.getGraphicBag()).isSelected(g);
            }
            return false;
        }

        @Override
        public void removeAccessibleSelection(int i) {
            IlvGraphic g = this.getChild(i);
            if (g != null) {
                ((IlvManager)g.getGraphicBag()).setSelected(g, false, true);
            }
        }

        @Override
        public void selectAllAccessibleSelection() {
            AccessibleManagerView.this.getManager().selectAll(false, true);
        }

        protected IlvGraphic getChild(int i) {
            for (IlvGraphic g : new VisibleObjectsIterator(AccessibleManagerView.this.getManager())) {
                if (i-- != 0) continue;
                return g;
            }
            return null;
        }

        protected IlvGraphic getSelected(int i) {
            IlvGraphicEnumeration e = AccessibleManagerView.this.getManager().getSelectedObjects(true);
            while (e.hasMoreElements()) {
                IlvGraphic g = e.nextElement();
                if (i == 0) {
                    return g;
                }
                --i;
            }
            return null;
        }

        protected class ViewsChangedListener
        implements ManagerViewsChangedListener {
            protected ViewsChangedListener() {
            }

            public void viewChanged(ManagerViewsChangedEvent event) {
                if (event.getType() == 2 && event.getManagerView() == AccessibleManagerView.this) {
                    AccessibleViewContext.this.managerChanged(event.getManager(), null);
                }
            }
        }

        protected class ManagerChangeListener
        implements ManagerContentChangedListener {
            protected ManagerChangeListener() {
            }

            public void contentsChanged(ManagerContentChangedEvent event) {
                if (!event.isAdjusting() || event.getType() == 32) {
                    AccessibleViewContext.this.firePropertyChange("accessibleInvalidateChildren", null, AccessibleManagerView.this);
                }
            }
        }

        protected class SelectionListener
        implements ManagerSelectionListener {
            protected SelectionListener() {
            }

            public void selectionChanged(ManagerSelectionChangedEvent event) {
                if (!event.isAdjusting() || event.isAdjustmentEnd()) {
                    AccessibleViewContext.this.firePropertyChange("AccessibleSelection", null, null);
                }
            }
        }
    }
}

