/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.accessibility;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import java.util.ArrayList;
import java.util.List;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.framework.accessibility.KeyboardNavigationPlugin;
import oracle.diagram.framework.accessibility.NavigableGraphicPlugin;

public abstract class AbstractKeyboardNavigationPlugin
extends AbstractPlugin
implements KeyboardNavigationPlugin {
    private static final float FUDGE_FACTOR = 0.5f;

    protected AbstractKeyboardNavigationPlugin() {
    }

    protected List<IlvGraphic> filterSelectableChildren(NavigableGraphicPlugin ngp, IlvManager parent, List<IlvGraphic> graphics) {
        if (graphics == null || graphics.isEmpty()) {
            return graphics;
        }
        ArrayList<IlvGraphic> result = new ArrayList<IlvGraphic>(graphics.size());
        for (IlvGraphic g : graphics) {
            if (!ngp.isSelectable(g)) continue;
            result.add(g);
        }
        return result;
    }

    protected List<IlvGraphic> filterSelectableContents(NavigableGraphicPlugin ngp, IlvGraphic parent, List<IlvGraphic> graphics) {
        if (graphics == null || graphics.isEmpty()) {
            return graphics;
        }
        ArrayList<IlvGraphic> result = new ArrayList<IlvGraphic>(graphics.size());
        for (IlvGraphic g : graphics) {
            if (!ngp.isSelectable(g)) continue;
            result.add(g);
        }
        return result;
    }

    protected IlvGraphic navigateNext(IlvManagerView view, IlvGraphic current, KeyboardNavigationPlugin.Direction direction) {
        if (current == null) {
            NavigableGraphicPlugin ngp = this.getNavigableGraphicPlugin((IlvGraphic)view.getManager());
            if (ngp != null) {
                List<IlvGraphic> children = this.filterSelectableChildren(ngp, view.getManager(), ngp.getNavigableChildren(view.getManager()));
                if (children == null || children.isEmpty()) {
                    return null;
                }
                IlvGraphic child = children.get(0);
                ngp.navigateTo(view, child, true);
                return child;
            }
            return null;
        }
        NavigableGraphicPlugin curNgp = this.getNavigableGraphicPlugin(current);
        if (curNgp == null) {
            return current;
        }
        IlvGraphic parent = curNgp.getNavigableParent(current);
        if (parent == null || !curNgp.isSelectable(parent)) {
            return current;
        }
        NavigableGraphicPlugin parentNgp = this.getNavigableGraphicPlugin(parent);
        if (direction == KeyboardNavigationPlugin.Direction.CHILD) {
            if (current == null || !(current instanceof IlvManager)) {
                return null;
            }
            List<IlvGraphic> children = this.filterSelectableChildren(curNgp, (IlvManager)current, curNgp.getNavigableChildren((IlvManager)current));
            if (children == null || children.isEmpty()) {
                return current;
            }
            IlvGraphic child = children.get(0);
            curNgp.navigateTo(view, child, true);
            return child;
        }
        if (direction == KeyboardNavigationPlugin.Direction.PARENT) {
            curNgp.navigateTo(view, parent, true);
        } else {
            List<IlvGraphic> children = parent instanceof IlvManager ? this.filterSelectableChildren(parentNgp, (IlvManager)parent, parentNgp.getNavigableChildren((IlvManager)parent)) : null;
            boolean canNavigateToOtherGroup = true;
            if (children == null || children.size() < 2 || !children.contains(current)) {
                children = this.filterSelectableContents(parentNgp, parent, parentNgp.getNavigableContents(parent));
                canNavigateToOtherGroup = false;
                if (children == null || children.size() < 2 || !children.contains(current)) {
                    return current;
                }
            }
            int currentGraphicGroup = 0;
            for (IlvGraphic check : children) {
                if (check == NavigableGraphicPlugin.SEPARATOR_GRAPHIC) {
                    ++currentGraphicGroup;
                    continue;
                }
                if (check != current) continue;
                break;
            }
            IlvRect r = current.boundingBox();
            IlvPoint topLeftPoint = new IlvPoint(r.x, r.y);
            IlvPoint midPoint = new IlvPoint((float)r.getCenterX(), (float)r.getCenterY());
            IlvPoint checkMidPoint = new IlvPoint();
            IlvGraphic closest = null;
            float factor = 0.5f;
            int i = 0;
            while (i < 5 && closest == null) {
                boolean first = true;
                float closestDistance = 0.0f;
                int checkGroup = 0;
                for (IlvGraphic check : children) {
                    if (check == current) continue;
                    if (check == NavigableGraphicPlugin.SEPARATOR_GRAPHIC) {
                        ++checkGroup;
                        continue;
                    }
                    r = check.boundingBox();
                    if ((direction == KeyboardNavigationPlugin.Direction.UP || direction == KeyboardNavigationPlugin.Direction.DOWN) && r.x == topLeftPoint.x) {
                        checkMidPoint.setLocation((double)midPoint.x, r.getCenterY());
                    } else {
                        checkMidPoint.setLocation(r.getCenterX(), r.getCenterY());
                    }
                    float diffX = checkMidPoint.x - midPoint.x;
                    float diffY = checkMidPoint.y - midPoint.y;
                    boolean inBand = false;
                    switch (direction) {
                        case LEFT: {
                            inBand = diffX < 0.0f && Math.abs(diffY) < Math.abs(diffX) * factor;
                            break;
                        }
                        case RIGHT: {
                            inBand = diffX > 0.0f && Math.abs(diffY) < Math.abs(diffX) * factor;
                            break;
                        }
                        case UP: {
                            inBand = diffY < 0.0f && Math.abs(diffX) < Math.abs(diffY) * factor;
                            break;
                        }
                        case DOWN: {
                            boolean bl = inBand = diffY > 0.0f && Math.abs(diffX) < Math.abs(diffY) * factor;
                        }
                    }
                    if (!canNavigateToOtherGroup && checkGroup != currentGraphicGroup) {
                        inBand = false;
                    }
                    if (!inBand) continue;
                    float distance = AbstractKeyboardNavigationPlugin.distanceSq(midPoint.x, midPoint.y, checkMidPoint.x, checkMidPoint.y);
                    if (first || distance < closestDistance) {
                        closest = check;
                        closestDistance = distance;
                    }
                    first = false;
                }
                if (closest != null) {
                    parentNgp.navigateTo(view, closest, true);
                    return closest;
                }
                ++i;
                factor *= 2.0f;
            }
        }
        return current;
    }

    protected abstract <T extends Plugin> T getPlugin(IlvGraphic var1, Class<T> var2);

    protected NavigableGraphicPlugin getNavigableGraphicPlugin(IlvGraphic g) {
        return this.getPlugin(g, NavigableGraphicPlugin.class);
    }

    private static float distanceSq(float x1, float y1, float x2, float y2) {
        float dx = x1 - x2;
        float dy = y1 - y2;
        return dx * dx + dy * dy;
    }
}

