/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.dif;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.diagram.dif.GraphConnector;
import oracle.diagram.dif.GraphElement;
import oracle.diagram.dif.GraphicBridge;
import oracle.diagram.dif.Point;
import oracle.mof.xmi.XMIBean;
import oracle.mof.xmi.XMIPropertyType;

public class GraphEdge
extends GraphElement {
    private ArrayList<Point> m_waypoints = new ArrayList();
    private GraphConnector[] m_anchors = new GraphConnector[2];

    @XMIBean(type=XMIPropertyType.COMPOSITE, multivalued=true)
    public void addWaypoint(Point waypoint) {
        if (waypoint == null) {
            throw new IllegalArgumentException("Missing waypoint");
        }
        this.m_waypoints.add(waypoint);
    }

    @XMIBean(type=XMIPropertyType.COMPOSITE, tag="waypoint", multivalued=true)
    public Iterator<Point> waypoints() {
        return this.m_waypoints.iterator();
    }

    public void clearWaypoints() {
        this.m_waypoints.clear();
    }

    @XMIBean(type=XMIPropertyType.REFERENCE, multivalued=true)
    public void addAnchor(GraphConnector anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Missing anchor");
        }
        if (this.m_anchors[1] != null) {
            throw new IllegalStateException("Too many anchors");
        }
        this.m_anchors[this.m_anchors[0] == null ? 0 : 1] = anchor;
    }

    @XMIBean(type=XMIPropertyType.REFERENCE, tag="anchor", multivalued=true)
    public GraphConnector[] anchors() {
        return this.m_anchors;
    }

    void setAnchor(GraphConnector anchor, int position) {
        this.m_anchors[position] = anchor;
    }

    public Point getStartPoint() {
        return this.m_waypoints.get(0);
    }

    public Point getEndPoint() {
        return this.m_waypoints.get(this.m_waypoints.size() - 1);
    }

    @Override
    public <P> void createGraphic(GraphicBridge<P> bridge, P parentGraphic) {
        bridge.createEdgeGraphic(this, parentGraphic);
    }

    @Override
    public <P> void connect(GraphicBridge<P> bridge) {
        super.connect(bridge);
        bridge.connectGraphics(this);
    }

    @Override
    public <P> void update(GraphicBridge<P> bridge) {
        this.updateAnchors(bridge);
        bridge.updateEdge(this);
    }
}

