/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.thumbnail;

import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerChangedEvent;
import ilog.views.event.ManagerChangedListener;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import oracle.diagram.framework.view.ViewUtil;

public class ThumbnailViewInteractor
extends IlvManagerViewInteractor
implements MouseWheelListener {
    private static final float HANDLE_SIZE = 3.0f;
    private static final int DRAG_SENSITIVITY = 5;
    private IlvManagerView _view;
    private IlvManagerView _targetView;
    private Cursor _oldViewCursor;
    private final IlvRect _controlRect = new IlvRect();
    private final ViewListener _listener = new ViewListener();
    private int _direction = 0;
    private final IlvPoint _lastDragPoint = new IlvPoint();
    private int _updatingTarget = 0;
    private IlvRect _lastKnownValidExtents = new IlvRect();
    private boolean _draggingStarted;
    private final IlvRect _tmpRect = new IlvRect();
    private final IlvRect _paintRect = new IlvRect();
    private IlvRect _lastMgrBounds = new IlvRect(0.0f, 0.0f, 0.0f, 0.0f);
    private boolean _isConstrained = false;

    public ThumbnailViewInteractor() {
        this(false);
    }

    public ThumbnailViewInteractor(boolean isConstrained) {
        this._isConstrained = isConstrained;
        this.setXORGhost(false);
        this.enableEvents(131120L);
    }

    public final void setTarget(IlvManagerView targetView) {
        IlvManager mgr;
        if (this._targetView != null) {
            this._targetView.removeComponentListener((ComponentListener)this._listener);
            this._targetView.removeManagerChangedListener((ManagerChangedListener)this._listener);
            this._targetView.removeTransformerListener((TransformerListener)this._listener);
            mgr = this._targetView.getManager();
            if (mgr != null) {
                mgr.removeManagerContentChangedListener((ManagerContentChangedListener)this._listener);
            }
        }
        this._targetView = targetView;
        if (targetView != null) {
            targetView.addComponentListener((ComponentListener)this._listener);
            targetView.addManagerChangedListener((ManagerChangedListener)this._listener);
            targetView.addTransformerListener((TransformerListener)this._listener);
            mgr = targetView.getManager();
            if (mgr != null) {
                mgr.addManagerContentChangedListener((ManagerContentChangedListener)this._listener);
            }
            this.recalculateAll();
        }
    }

    protected void recalculateAll() {
        this._lastMgrBounds.setRect((Rectangle2D)this._view.getManager().boundingBox());
        this._view.invalidateView();
        this.recalculateThumbnailTransformer(false);
        this.recalculateControlRectangle(false);
        this._view.reDrawViews();
    }

    public final IlvManagerView getTarget() {
        return this._targetView;
    }

    protected void attach(IlvManagerView view) {
        super.attach(view);
        if (this._view != null) {
            this._view.removeMouseWheelListener((MouseWheelListener)this);
            this._view.removeComponentListener((ComponentListener)this._listener);
            this._view.setCursor(this._oldViewCursor);
            this._oldViewCursor = null;
        }
        this._view = view;
        if (this._view != null) {
            this._view.addMouseWheelListener((MouseWheelListener)this);
            this._view.addComponentListener((ComponentListener)this._listener);
            this._oldViewCursor = this._view.getCursor();
            this.recalculateAll();
        }
    }

    protected void detach() {
        super.detach();
        if (this._view != null) {
            this._view.removeMouseWheelListener((MouseWheelListener)this);
            this._view.removeComponentListener((ComponentListener)this._listener);
            this._view.setCursor(this._oldViewCursor);
            this._oldViewCursor = null;
        }
        this._view = null;
        if (this._targetView != null) {
            this.setTarget(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        IlvManagerView target = this.getTarget();
        if (target == null) {
            return;
        }
        double scale = e.getWheelRotation() >= 0 ? (target.isWheelZoomingInverted() ? 0.9 : 1.1) : (target.isWheelZoomingInverted() ? 1.1 : 0.9);
        Dimension dimension = target.getSize();
        IlvPoint center = new IlvPoint((float)Math.floor(dimension.width / 2), (float)Math.floor(dimension.height / 2));
        if (!this._isConstrained) {
            target.zoom(center, scale, scale, true);
        } else {
            if (scale < 1.0 && this._controlRect.x <= this._lastKnownValidExtents.x && this._controlRect.y <= this._lastKnownValidExtents.y && this._controlRect.width >= this._lastKnownValidExtents.width && this._controlRect.height >= this._lastKnownValidExtents.height) {
                return;
            }
            Dimension viewSize = this._targetView.getSize();
            IlvRect rView = this._tmpRect;
            rView.setRect(1.0f, 1.0f, (float)viewSize.getWidth() - 1.0f, (float)viewSize.getHeight() - 1.0f);
            IlvTransformer viewTx = this._targetView.getTransformer();
            IlvTransformer tx = new IlvTransformer();
            double x = (double)center.x - scale * (double)center.x;
            double y = (double)center.y - scale * (double)center.y;
            tx.setValues(scale, 0.0, 0.0, scale, x, y);
            viewTx.compose(tx);
            boolean result = viewTx.inverse(rView);
            this._view.getTransformer().apply(rView);
            this.constrainControlRectangle(rView, this._lastKnownValidExtents);
            this._view.invalidateRect(this._controlRect);
            this._view.invalidateRect(rView);
            this._controlRect.setRect((Rectangle2D)rView);
            int redrawMode = this._view.getRedrawMode();
            try {
                this._view.setRedrawMode(1);
                this._view.reDrawViews();
            }
            finally {
                this._view.setRedrawMode(redrawMode);
            }
            this.updateTargetFromControlRectangle();
        }
    }

    protected void processMouseEvent(MouseEvent event) {
        super.processMouseEvent(event);
        switch (event.getID()) {
            case 501: {
                if ((event.getModifiers() & 0x10) != 16) {
                    return;
                }
                this._draggingStarted = false;
                int direction = this.getControlDirection(event.getX(), event.getY());
                this.updateCursor(direction);
                this._direction = direction;
                this._lastDragPoint.setLocation((float)event.getX(), (float)event.getY());
                break;
            }
            case 502: {
                if ((event.getModifiers() & 0x10) != 16) {
                    return;
                }
                if (this._draggingStarted || this._direction != 16 && this._direction != 0) break;
                this._lastDragPoint.setLocation(this._controlRect.getCenterX(), this._controlRect.getCenterY());
                this.updateControlRectangle(16, event.getX(), event.getY(), true);
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent event) {
        super.processMouseMotionEvent(event);
        switch (event.getID()) {
            case 503: {
                int direction = this.getControlDirection(event.getX(), event.getY());
                this.updateCursor(direction);
                break;
            }
            case 506: {
                if ((event.getModifiers() & 0x10) != 16) {
                    return;
                }
                if (!this._draggingStarted) {
                    if (Math.abs((double)event.getX() - this._lastDragPoint.getX()) >= 5.0 || Math.abs((double)event.getY() - this._lastDragPoint.getY()) >= 5.0) {
                        this._draggingStarted = true;
                    } else {
                        return;
                    }
                }
                if (!this.updateControlRectangle(this._direction, event.getX(), event.getY(), true)) break;
                this._lastDragPoint.setLocation((float)event.getX(), (float)event.getY());
            }
        }
    }

    private void updateCursor(int direction) {
        switch (direction) {
            case 5: {
                this._view.setCursor(Cursor.getPredefinedCursor(6));
                break;
            }
            case 6: {
                this._view.setCursor(Cursor.getPredefinedCursor(7));
                break;
            }
            case 10: {
                this._view.setCursor(Cursor.getPredefinedCursor(5));
                break;
            }
            case 9: {
                this._view.setCursor(Cursor.getPredefinedCursor(4));
                break;
            }
            case 16: {
                this._view.setCursor(Cursor.getPredefinedCursor(12));
                break;
            }
            default: {
                this._view.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private void recalculateControlRectangle(boolean redraw) {
        if (this._targetView == null || this._view == null) {
            return;
        }
        if (redraw) {
            this._view.invalidateRect(this._controlRect);
        }
        Dimension viewSize = this._targetView.getSize();
        IlvRect rView = this._tmpRect;
        rView.setRect(1.0f, 1.0f, (float)viewSize.getWidth() - 1.0f, (float)viewSize.getHeight() - 1.0f);
        IlvTransformer tx = this._targetView.getTransformer();
        boolean result = tx.inverse(rView);
        this._view.getTransformer().apply(rView);
        this._controlRect.setRect((Rectangle2D)rView);
        if (redraw) {
            this._view.invalidateRect(this._controlRect);
            this._view.reDrawViews();
        }
    }

    private void recalculateThumbnailTransformer(boolean redraw) {
        if (this._targetView == null || this._view == null) {
            return;
        }
        this.fitTransformerToContent();
        if (redraw) {
            this._view.invalidateView();
            this._view.reDrawViews();
        }
        IlvTransformer tx = this._view.getManager().getDrawingTransformer(this._view);
        this._lastKnownValidExtents.setRect((Rectangle2D)this._view.getManager().boundingBox(tx));
    }

    private void fitTransformerToContent() {
        ViewUtil.zoomFitToWindow(this._view, 0.5, false);
    }

    private int getControlDirection(int x, int y) {
        if (this.isWithinControlHandle(x, y, (float)this._controlRect.getX(), (float)this._controlRect.getY(), 3.0f)) {
            return 5;
        }
        if (this.isWithinControlHandle(x, y, (float)(this._controlRect.getX() + this._controlRect.getWidth()), (float)this._controlRect.getY(), 3.0f)) {
            return 6;
        }
        if (this.isWithinControlHandle(x, y, (float)(this._controlRect.getX() + this._controlRect.getWidth()), (float)(this._controlRect.getY() + this._controlRect.getHeight()), 3.0f)) {
            return 10;
        }
        if (this.isWithinControlHandle(x, y, (float)this._controlRect.getX(), (float)(this._controlRect.getY() + this._controlRect.getHeight()), 3.0f)) {
            return 9;
        }
        if (this._controlRect.contains((double)x, (double)y)) {
            return 16;
        }
        return 0;
    }

    private boolean isWithinControlHandle(float mouseX, float mouseY, float cornerX, float cornerY, float handleSize) {
        return mouseX >= cornerX - handleSize / 2.0f && mouseX <= cornerX + handleSize / 2.0f && mouseY >= cornerY - handleSize / 2.0f && mouseY <= cornerY + handleSize / 2.0f;
    }

    protected void handleExpose(Graphics g) {
        super.handleExpose(g);
        this.drawControlRectangle((Graphics2D)g);
    }

    protected void drawControlRectangle(Graphics2D g) {
        if (this._view != null && this._targetView != null && !this._controlRect.isEmpty()) {
            g.draw((Shape)this._controlRect);
            this._paintRect.setRect(this._controlRect.getX() - 1.5, this._controlRect.getY() - 1.5, 3.0, 3.0);
            g.fill((Shape)this._paintRect);
            this._paintRect.setRect(this._controlRect.getX() + this._controlRect.getWidth() - 1.5, this._controlRect.getY() - 1.5, 3.0, 3.0);
            g.fill((Shape)this._paintRect);
            this._paintRect.setRect(this._controlRect.getX() + this._controlRect.getWidth() - 1.5, this._controlRect.getY() + this._controlRect.getHeight() - 1.5, 3.0, 3.0);
            g.fill((Shape)this._paintRect);
            this._paintRect.setRect(this._controlRect.getX() - 1.5, this._controlRect.getY() + this._controlRect.getHeight() - 1.5, 3.0, 3.0);
            g.fill((Shape)this._paintRect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTargetFromControlRectangle() {
        if (this._targetView == null || this._view == null) {
            return;
        }
        try {
            ++this._updatingTarget;
            this._targetView.invalidateView();
            IlvRect control = this._tmpRect;
            control.setRect((Rectangle2D)this._controlRect);
            this._view.getTransformer().inverse(control);
            Dimension viewSize = this._targetView.getSize();
            double scaleX = (double)viewSize.width / ((double)control.width + 1.0);
            double scaleY = (double)viewSize.height / ((double)control.height + 1.0);
            if (this._targetView.isKeepingAspectRatio()) {
                scaleX = scaleY = Math.min(scaleX, scaleY);
            }
            double offX = ((double)viewSize.width - scaleX * (double)control.width) / 2.0 - (double)control.x * scaleX;
            double offY = ((double)viewSize.height - scaleX * (double)control.height) / 2.0 - (double)control.y * scaleY;
            IlvTransformer t = new IlvTransformer();
            t.setValues(scaleX, 0.0, 0.0, scaleY, offX, offY);
            this._targetView.setTransformer(t);
            this._targetView.invalidateView();
            int redrawMode = this._targetView.getRedrawMode();
            try {
                this._targetView.setRedrawMode(1);
                this._targetView.reDrawViews();
            }
            finally {
                this._targetView.setRedrawMode(redrawMode);
            }
        }
        finally {
            --this._updatingTarget;
        }
    }

    private boolean updateControlRectangle(int direction, int x, int y, boolean redraw) {
        if (direction == 0 || this._targetView == null || this._view == null) {
            return false;
        }
        IlvRect oldControlRect = this._tmpRect;
        oldControlRect.setRect((Rectangle2D)this._controlRect);
        if (redraw) {
            this._view.invalidateRect(this._controlRect);
        }
        switch (direction) {
            case 5: {
                float dx = (float)x - this._controlRect.x;
                float dy = (float)y - this._controlRect.y;
                if (dx >= this._controlRect.width || dy >= this._controlRect.height) {
                    return false;
                }
                this._controlRect.x = x;
                this._controlRect.y = y;
                this._controlRect.width -= dx;
                this._controlRect.height -= dy;
                break;
            }
            case 6: {
                float dx = (float)x - (this._controlRect.x + this._controlRect.width);
                float dy = (float)y - this._controlRect.y;
                if (this._controlRect.width + dx < 1.0f || dy >= this._controlRect.height) {
                    return false;
                }
                this._controlRect.width += dx;
                this._controlRect.y = y;
                this._controlRect.height -= dy;
                break;
            }
            case 10: {
                float dx = (float)x - (this._controlRect.x + this._controlRect.width);
                float dy = (float)y - (this._controlRect.y + this._controlRect.height);
                if (this._controlRect.width + dx < 1.0f || this._controlRect.height + dy < 1.0f) {
                    return false;
                }
                this._controlRect.width += dx;
                this._controlRect.height += dy;
                break;
            }
            case 9: {
                float dx = (float)x - this._controlRect.x;
                float dy = (float)y - (this._controlRect.y + this._controlRect.height);
                if (dx >= this._controlRect.width || this._controlRect.height + dy < 1.0f) {
                    return false;
                }
                this._controlRect.x = x;
                this._controlRect.width -= dx;
                this._controlRect.height += dy;
                break;
            }
            case 16: {
                float dx = (float)x - this._lastDragPoint.x;
                float dy = (float)y - this._lastDragPoint.y;
                this._controlRect.x += dx;
                this._controlRect.y += dy;
                break;
            }
        }
        if (this._targetView.isKeepingAspectRatio() && direction != 16) {
            Dimension viewSize = this._targetView.getSize();
            float aspect = (float)viewSize.width / (float)viewSize.height;
            float width = this._controlRect.width;
            float height = this._controlRect.height;
            float aspHeight = width / aspect;
            float aspWidth = height * aspect;
            if (aspHeight > height) {
                height = aspHeight;
            } else {
                width = aspWidth;
            }
            float dw = width - this._controlRect.width;
            float dh = height - this._controlRect.height;
            this._controlRect.width += dw;
            this._controlRect.height += dh;
            switch (direction) {
                case 5: {
                    this._controlRect.x -= dw;
                    this._controlRect.y -= dh;
                    break;
                }
                case 6: {
                    this._controlRect.y -= dh;
                    break;
                }
                case 10: {
                    break;
                }
                case 9: {
                    this._controlRect.x -= dw;
                }
            }
        }
        if (!this._controlRect.intersects(this._lastKnownValidExtents)) {
            this._controlRect.setRect((Rectangle2D)oldControlRect);
            return false;
        }
        if (this._isConstrained && direction == 16 && this._controlRect.width > this._lastKnownValidExtents.width && this._controlRect.height > this._lastKnownValidExtents.height) {
            Dimension viewSize = this._targetView.getSize();
            IlvRect rView = new IlvRect(1.0f, 1.0f, (float)viewSize.getWidth() - 1.0f, (float)viewSize.getHeight() - 1.0f);
            IlvTransformer tx = ViewUtil.calculateZoomToFitTransformer(this._view.getManager().boundingBox(), rView, true, 0.5);
            this._targetView.setTransformer(tx);
            this._targetView.invalidateView();
            this._targetView.reDrawViews();
            return false;
        }
        this.constrainControlRectangle(this._controlRect, this._lastKnownValidExtents);
        this.updateTargetFromControlRectangle();
        if (redraw) {
            this._view.invalidateRect(this._controlRect);
            this._view.reDrawViews();
        }
        return true;
    }

    private void constrainControlRectangle(IlvRect r, IlvRect rConstraint) {
        if (this._isConstrained) {
            if (r.width > rConstraint.width) {
                float dx = (r.width - rConstraint.width) / 2.0f;
                r.x = rConstraint.x - dx;
            } else if (r.x < rConstraint.x) {
                r.x = rConstraint.x;
            } else if (r.x + r.width > rConstraint.x + rConstraint.width) {
                r.x -= r.x + r.width - (rConstraint.x + rConstraint.width);
            }
            if (r.height > rConstraint.height) {
                float dy = (r.height - rConstraint.height) / 2.0f;
                r.y = rConstraint.y - dy;
            } else if (r.y < rConstraint.y) {
                r.y = rConstraint.y;
            } else if (r.y + r.height > rConstraint.y + rConstraint.height) {
                r.y -= r.y + r.height - (rConstraint.y + rConstraint.height);
            }
        }
    }

    private class ViewListener
    implements TransformerListener,
    ManagerContentChangedListener,
    ManagerChangedListener,
    ComponentListener {
        private ViewListener() {
        }

        public void managerChanged(ManagerChangedEvent event) {
            if (event.getManagerView() == ThumbnailViewInteractor.this._targetView) {
                IlvManager newMgr;
                IlvManager oldMgr = event.getOldValue();
                if (oldMgr != null) {
                    oldMgr.removeManagerContentChangedListener((ManagerContentChangedListener)this);
                }
                if ((newMgr = event.getNewValue()) != null) {
                    newMgr.addManagerContentChangedListener((ManagerContentChangedListener)this);
                }
                ThumbnailViewInteractor.this.recalculateAll();
            }
        }

        public void transformerChanged(TransformerChangedEvent event) {
            if (event.getSource() == ThumbnailViewInteractor.this._targetView && ThumbnailViewInteractor.this._updatingTarget == 0) {
                ThumbnailViewInteractor.this.recalculateControlRectangle(true);
            }
        }

        public void contentsChanged(ManagerContentChangedEvent event) {
            IlvRect r;
            if (ThumbnailViewInteractor.this._targetView != null && !event.isAdjusting() && event.getManager() == ThumbnailViewInteractor.this._targetView.getManager() && !(r = ThumbnailViewInteractor.this._targetView.getManager().boundingBox()).equals((Object)ThumbnailViewInteractor.this._lastMgrBounds)) {
                ThumbnailViewInteractor.this.recalculateAll();
            }
        }

        @Override
        public void componentResized(ComponentEvent event) {
            if (event.getSource() == ThumbnailViewInteractor.this._view) {
                ThumbnailViewInteractor.this.recalculateAll();
            } else if (event.getSource() == ThumbnailViewInteractor.this._targetView) {
                ThumbnailViewInteractor.this.recalculateControlRectangle(true);
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }
}

