/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.manager;

import ilog.views.IlvLayerVisibilityFilter;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Enumeration;
import oracle.diagram.core.manager.ExtendedLayerVisibilityFilter;
import oracle.diagram.framework.graphic.DiagramRenderingHints;

public class CoreManagerLayer
extends IlvManagerLayer {
    public CoreManagerLayer() {
        this.setQuadtreeEnabled(false);
    }

    public CoreManagerLayer(IlvInputStream stream) throws IlvReadFileException {
        super(stream);
        this.setQuadtreeEnabled(false);
    }

    public CoreManagerLayer(int maxInNode, int maxInList) {
        super(maxInNode, maxInList);
        this.setQuadtreeEnabled(false);
    }

    public void print(Graphics graphics, IlvRect rect, IlvTransformer tx) {
        Enumeration e = this.getVisibilityFilters();
        while (e.hasMoreElements()) {
            IlvLayerVisibilityFilter f = (IlvLayerVisibilityFilter)e.nextElement();
            if (!(f instanceof ExtendedLayerVisibilityFilter) || ((ExtendedLayerVisibilityFilter)f).isVisible(this, graphics)) continue;
            return;
        }
        super.print(graphics, rect, tx);
    }

    protected void draw(Graphics graphics, IlvManagerView view) {
        boolean doPaint;
        boolean bl = doPaint = view.getTransformer().getDeterminant() != 0.0;
        if (doPaint) {
            Graphics2D g2d = (Graphics2D)graphics;
            int layerIndex = this.getIndex();
            int layerCount = this.getManager().getLayersCount();
            Object value = g2d.getRenderingHint(DiagramRenderingHints.KEY_HC_FILL_COLOR);
            if (value != null && layerIndex == layerCount) {
                g2d.setRenderingHint(DiagramRenderingHints.KEY_HC_FILL_COLOR, DiagramRenderingHints.VALUE_HC_FILL_COLOR_FORE);
            }
            super.draw(graphics, view);
            if (value != null && layerIndex == layerCount) {
                g2d.setRenderingHint(DiagramRenderingHints.KEY_HC_FILL_COLOR, value);
            }
        }
    }
}

