/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.interaction;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvGrid;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsInterface;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.interactor.IlvMoveRectangleInteractor;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.interaction.AutoscrollInteractorMarker;
import oracle.diagram.core.interaction.CoreSelectInteractor;
import oracle.diagram.core.interaction.DragAndDropAwareInteractor;
import oracle.diagram.core.interaction.DropPropagationManager;
import oracle.diagram.core.interaction.MoveInteractorMarker;
import oracle.diagram.core.interaction.SelectionChangeNotificationPlugin;
import oracle.diagram.core.util.Translator;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.javatools.util.BundleLoader;

public class CoreSelectInteractorMoveSelection
extends IlvMoveRectangleInteractor
implements DragAndDropAwareInteractor,
MoveInteractorMarker,
AutoscrollInteractorMarker {
    protected static final String UNDO_NAME = BundleLoader.getBundle((String)"oracle.diagram.res.UndoResource").getString("move.text");
    public static final String INITIAL_RECT_KEY = "__InitialRect";
    protected static final String GHOST_RECT_KEY = "__GhostRect";
    protected static final String WAS_HIDDEN_KEY = "__WasHidden";
    public static final String INITIAL_LINK_POINTS = "__InitialLinkPoints";
    private static final IlvTransformer IDENTITY = new IlvTransformer();
    public static final String MOVEABLE_SHAPE_KEY = "__MovableShapeKey";
    private final Translator _translator;
    private boolean _dragged = false;
    private boolean _aborting;
    private boolean _isDragMove;
    private IlvGraphic _obj;
    protected boolean _isNativeDrag = false;
    private int _dragModifiers;
    private CoreSelectInteractor _selectInteractor;
    private IlvGraphicVector _moveList;
    private IlvGraphicVector _moveSubList;
    private IlvGraphic _lastHitObject;
    private IlvGraphic _lastHitSubObject;
    private boolean _hadLeftOwningContext;
    private MoveType _targetValidity;
    private final IlvPoint _tmpPoint = new IlvPoint();
    private final MyDragGestureListener _dgl = new MyDragGestureListener();
    private final MyDragSourceListener _dsl = new MyDragSourceListener();
    private final MyDropTargetListener _dtl = new MyDropTargetListener();
    private MyTransformerListener _transformerListener;
    private MouseEvent _lastDragEvent;
    private IlvPoint _lastMousePressed = new IlvPoint();
    protected Set<IlvGraphic> _movingContainedObjects;
    private IlvPoint _lastMouseValidPosition = new IlvPoint();

    public CoreSelectInteractorMoveSelection(CoreSelectInteractor selectInteractor) {
        super(new IlvRect());
        this.enableEvents(60L);
        this._selectInteractor = selectInteractor;
        this._moveList = null;
        this._moveSubList = null;
        this._lastHitObject = null;
        this._lastHitSubObject = null;
        this._targetValidity = MoveType.SIMPLE_MOVE;
        this._isDragMove = false;
        this._dragModifiers = -1;
        this._translator = this.createTranslator();
        this.setGridMode(true);
        this.setLineStyle(selectInteractor.getLineStyle());
        this.setCursor(selectInteractor.getMoveSelectionCursor());
        this.setMoveThreshold(selectInteractor.getMoveThreshold());
    }

    protected Translator createTranslator() {
        return new Translator();
    }

    public boolean isOpaqueMode() {
        return this.getSelectInteractor().isOpaqueMove();
    }

    public final boolean isXORGhost() {
        return this.isOpaqueMode() ? this.getSelectInteractor().isXORGhost() : true;
    }

    public CoreSelectInteractor getSelectInteractor() {
        return this._selectInteractor;
    }

    protected static int convertDropActionToMouseModifier(int action) {
        int mod = 0;
        switch (action) {
            case 2: {
                mod |= 1;
                break;
            }
            case 1: {
                mod |= 2;
                break;
            }
            case 0x40000000: {
                mod |= 8;
            }
        }
        return mod;
    }

    protected final MoveType getCurrentTargetValidity() {
        return this._targetValidity;
    }

    protected final void setCurrentTargetValidity(MoveType targetValidity) {
        this._targetValidity = targetValidity;
    }

    protected boolean hasLeftOriginalContext() {
        return this._hadLeftOwningContext;
    }

    protected MoveType validateTarget(IlvGraphic hitObject, IlvGraphic hitSubObject, int modifiers) {
        return MoveType.SIMPLE_MOVE;
    }

    protected void highlight(IlvGraphic targetObject, IlvGraphic targetSubObject, MoveType targetValidity) {
    }

    protected void unhighlight(IlvGraphic targetObject, IlvGraphic targetSubObject, MoveType targetValidity) {
    }

    protected void snapRectangleToGrid(IlvRect rectangle) {
        IlvGraphic snapObject = this.getSelectInteractor().getPrimaryMoveObject();
        boolean isMovingMain = false;
        IlvGraphicEnumeration e = this.getMovingObjects();
        while (e.hasMoreElements()) {
            if (e.nextElement() != snapObject) continue;
            isMovingMain = true;
            break;
        }
        if (!isMovingMain) {
            return;
        }
        if (snapObject instanceof IlvPolyPointsInterface) {
            IlvManagerView view = this.getManagerView();
            IlvTransformer t = ((IlvManager)snapObject.getGraphicBag()).getDrawingTransformer(view);
            IlvRect r = snapObject.boundingBox(t);
            t.compose(new IlvTransformer(new IlvPoint(rectangle.x - r.x, rectangle.y - r.y)));
            IlvPoint tmp0 = ((IlvPolyPointsInterface)snapObject).getPointAt(0, t);
            IlvPoint tmp1 = new IlvPoint(tmp0);
            view.snapToGrid(tmp1);
            rectangle.x += tmp1.x - tmp0.x;
            rectangle.y += tmp1.y - tmp0.y;
        } else {
            super.snapRectangleToGrid(rectangle);
        }
    }

    private boolean allowGroupMove(IlvGraphic obj) {
        IlvManager m = this.getSelectInteractor().getMoveSelectionManager();
        if (m instanceof IlvGrapher) {
            IlvGrapher g = (IlvGrapher)m;
            if (g.isLink(obj)) {
                IlvLinkImage l = (IlvLinkImage)obj;
                return m.isSelected(l.getFrom()) && m.isMovable(l.getFrom()) && m.isSelected(l.getTo()) && m.isMovable(l.getTo());
            }
            return m.isMovable(obj);
        }
        return m.isMovable(obj);
    }

    private void setSelectionRect() {
        IlvRect tmp;
        IlvGraphic g;
        IlvGraphicEnumeration e;
        IlvManager manager = this.getSelectInteractor().getMoveSelectionManager();
        IlvRect r = this.getRectangle();
        this._obj = null;
        int nbsel = 0;
        boolean first = true;
        IlvTransformer t = manager.getDrawingTransformer(this.getManagerView());
        IlvGraphicEnumeration e2 = this.getMovingObjects();
        while (e2.hasMoreElements()) {
            IlvGraphic object = e2.nextElement();
            if (!this.allowGroupMove(object)) continue;
            ++nbsel;
            if (object instanceof IlvLinkImage) continue;
            if (this._obj == null) {
                this._obj = object;
            }
            if (this._isDragMove) continue;
            IlvManager myManager = (IlvManager)object.getGraphicBag();
            IlvRect bbox = object.boundingBox(ManagerUtil.getConversionTransformer(manager, myManager));
            if (first) {
                r.reshape(bbox.x, bbox.y, bbox.width, bbox.height);
                first = false;
                continue;
            }
            r.add(bbox);
        }
        if (nbsel != 1) {
            this._obj = null;
        }
        if (this._isDragMove) {
            e = this.getMovingObjects();
            while (e.hasMoreElements()) {
                g = e.nextElement();
                tmp = (IlvRect)g.getProperty(GHOST_RECT_KEY);
                if (first) {
                    r.reshape(tmp.x, tmp.y, tmp.width, tmp.height);
                    first = false;
                    continue;
                }
                r.add(tmp);
            }
        }
        e = this.getMovingSubObjects();
        while (e.hasMoreElements()) {
            g = e.nextElement();
            tmp = (IlvRect)g.getProperty(GHOST_RECT_KEY);
            if (first) {
                r.reshape(tmp.x, tmp.y, tmp.width, tmp.height);
                first = false;
                continue;
            }
            r.add(tmp);
        }
        t.apply(r);
        this.setRectangle(r);
    }

    protected void attach(IlvManagerView v) {
        super.attach(v);
        this.getManager().setContentsAdjusting(true);
        this._transformerListener = new MyTransformerListener();
        v.addTransformerListener((TransformerListener)this._transformerListener);
    }

    protected void detach() {
        if (this.isMoved()) {
            DiagramContext context = DiagramContext.getDiagramContext(this.getManagerView());
            boolean propagateSelection = true;
            IlvGraphicEnumeration e = this.getMovingSubObjects();
            while (e.hasMoreElements() && propagateSelection) {
                IlvGraphic g = e.nextElement();
                DropPropagationManager.DropPropagationBehavior dpb = DropPropagationManager.getBehavior(g);
                if (dpb.propagateSelection()) continue;
                propagateSelection = false;
            }
            SelectionChangeNotificationPlugin scp = context.getPlugin(SelectionChangeNotificationPlugin.class);
            scp.setEnabled(true);
            if (propagateSelection) {
                scp.selectionChanged(context);
            }
        }
        this.getManagerView().removeTransformerListener((TransformerListener)this._transformerListener);
        this._transformerListener = null;
        this._lastDragEvent = null;
        this.getManager().setContentsAdjusting(false);
        super.detach();
        this.getSelectInteractor().clearInteractives();
        this._obj = null;
    }

    public void drawGhost(Graphics g) {
        if (!this.isDragging()) {
            return;
        }
        if (!this.getSelectInteractor().isOpaqueMove()) {
            if (this._obj == null || this._obj instanceof IlvManager || !this.getSelectInteractor().isShowingMovingObject()) {
                super.drawGhost(g);
            } else {
                this.getSelectInteractor()._drawGhostMove(g, this._obj, this.getRectangle());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateGhosts() {
        boolean drawnGhosts = false;
        try {
            IlvManager manager = this.getSelectInteractor().getMoveSelectionManager();
            IlvTransformer tx = manager.getDrawingTransformer(this.getManagerView());
            IlvRect tmp = new IlvRect();
            IlvGraphicEnumeration e = this.getMovingSubObjects();
            while (e.hasMoreElements()) {
                drawnGhosts = true;
                IlvGraphic g = e.nextElement();
                IlvRect r = (IlvRect)g.getProperty(GHOST_RECT_KEY);
                tmp.setRect(r.x - 1.0f, r.y - 1.0f, r.width + 2.0f, r.height + 2.0f);
                tx.apply(tmp);
                this.getManagerView().invalidateRect(tmp);
            }
        }
        finally {
            if (drawnGhosts) {
                int redrawMode = this.getManagerView().getRedrawMode();
                try {
                    this.getManagerView().setRedrawMode(1);
                    this.getManagerView().reDrawViews();
                }
                finally {
                    this.getManagerView().setRedrawMode(redrawMode);
                }
            }
        }
    }

    protected void cleanupMoveState() {
        IlvGraphic g;
        IlvGraphicEnumeration e = this.getMovingObjects();
        while (e.hasMoreElements()) {
            g = e.nextElement();
            g.removeProperty(INITIAL_RECT_KEY);
            g.removeProperty(GHOST_RECT_KEY);
            for (IlvGraphicBag bag = g.getGraphicBag(); bag != null; bag = bag.getGraphicBag()) {
                if (!(bag instanceof IlvGraphic)) continue;
                ((IlvGraphic)bag).removeProperty(INITIAL_RECT_KEY);
            }
        }
        e = this.getMovingSubObjects();
        while (e.hasMoreElements()) {
            g = e.nextElement();
            g.removeProperty(GHOST_RECT_KEY);
        }
        this._moveList = null;
        this._moveSubList = null;
        this._lastHitObject = null;
        this._lastHitSubObject = null;
        this._movingContainedObjects = null;
    }

    protected boolean trigger(AWTEvent event, float dx, float dy) {
        if (!this.getSelectInteractor().isOpaqueMove()) {
            this.translateSelections(dx, dy);
        }
        this.updateCursor();
        this.invalidateGhosts();
        if (this._targetValidity != MoveType.INVALID && this._lastHitObject != null) {
            this.unhighlight(this._lastHitObject, this._lastHitSubObject, this._targetValidity);
        }
        this.moveComplete(event, this.getLastHitObject(), this.getLastHitSubObject(), this.getCurrentTargetValidity());
        if (this.isMoved()) {
            this.completeUndoData();
        }
        this.getManagerView().popInteractor();
        this.cleanupMoveState();
        return true;
    }

    protected void moveComplete(AWTEvent event, IlvGraphic target, IlvGraphic subTarget, MoveType targetValidity) {
    }

    protected void captureUndoData() {
    }

    protected void completeUndoData() {
    }

    protected boolean isMoveAllowed() {
        return true;
    }

    protected boolean handleButtonDragged(MouseEvent e) {
        boolean handled = false;
        IlvManagerView view = this.getManagerView();
        if (view == null) {
            return false;
        }
        IlvTransformer t = view.getTransformer();
        IlvPoint p = new IlvPoint((float)e.getX(), (float)e.getY());
        t.inverse(p);
        IlvGrid grid = view.getGrid();
        if (grid != null && grid.isActive()) {
            float gridDx = grid.getHorizontalSpacing();
            float gridDy = grid.getVerticalSpacing();
            float dx = Math.abs(p.x - this._lastMouseValidPosition.x);
            float dy = Math.abs(p.y - this._lastMouseValidPosition.y);
            if (dx > gridDx || dy > gridDy) {
                handled = super.handleButtonDragged(e);
            }
        } else {
            handled = super.handleButtonDragged(e);
        }
        if (handled) {
            this._lastMouseValidPosition.x = p.x;
            this._lastMouseValidPosition.y = p.y;
        }
        return handled;
    }

    protected void rectangleDragged(AWTEvent event, float dx, float dy) {
        IlvManager mgr;
        IlvGraphic g;
        if (this._aborting) {
            return;
        }
        if (!this._dragged) {
            if (!this.isMoveAllowed()) {
                this._aborting = true;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IlvManagerView view = CoreSelectInteractorMoveSelection.this.getManagerView();
                        if (view != null && view.getInteractor() == CoreSelectInteractorMoveSelection.this) {
                            view.popInteractor();
                        }
                    }
                });
                return;
            }
            this._dragged = true;
            this.captureUndoData();
        }
        MouseEvent mouseEvent = (MouseEvent)event;
        this._tmpPoint.setLocation((float)mouseEvent.getX(), (float)mouseEvent.getY());
        IlvPoint mousePoint = this._tmpPoint;
        IlvGraphicEnumeration e = this.getMovingObjects();
        while (e.hasMoreElements()) {
            g = e.nextElement();
            mgr = (IlvManager)g.getGraphicBag();
            if (mgr.isVisible(g)) {
                mgr.setVisible(g, false, false);
                g.removeProperty(WAS_HIDDEN_KEY);
                continue;
            }
            g.setProperty(WAS_HIDDEN_KEY, (Object)Boolean.TRUE);
        }
        IlvGraphic hitObj = this.getManager().getObject(mousePoint, this.getManagerView(), true);
        IlvGraphicEnumeration e2 = this.getMovingObjects();
        while (e2.hasMoreElements()) {
            g = e2.nextElement();
            mgr = (IlvManager)g.getGraphicBag();
            if (!Boolean.TRUE.equals(g.getProperty(WAS_HIDDEN_KEY))) {
                mgr.setVisible(g, true, false);
            }
            g.removeProperty(WAS_HIDDEN_KEY);
        }
        if (hitObj == null) {
            hitObj = this.getManager();
        }
        IlvGraphic hitSubObj = hitObj != null ? this.getHitSubObject(hitObj, this.getManagerView(), mousePoint) : null;
        IlvGraphic primaryMoveObject = this.getSelectInteractor().getPrimaryMoveObject();
        IlvGraphic primaryMoveSubObject = this.getSelectInteractor().getPrimaryMoveSubObject();
        boolean leftOwningContext = false;
        if (primaryMoveSubObject != null) {
            IlvRect rOriginalBoundingBox = primaryMoveSubObject.boundingBox(this.getManager().getTransformer());
            leftOwningContext = !rOriginalBoundingBox.contains((double)mousePoint.x, (double)mousePoint.y);
        } else if (primaryMoveObject != null && !(hitObj instanceof IlvLinkImage)) {
            IlvManager newContextManager = hitObj instanceof IlvManager ? (IlvManager)hitObj : ManagerUtil.getManager(hitObj);
            boolean bl = leftOwningContext = !newContextManager.isManaged(primaryMoveObject);
        }
        if ((hitObj != this._lastHitObject || hitSubObj != this._lastHitSubObject) && this._targetValidity != MoveType.INVALID && this._lastHitObject != null) {
            this.unhighlight(this._lastHitObject, this._lastHitSubObject, this._targetValidity);
        }
        if (hitObj != this._lastHitObject || hitSubObj != this._lastHitSubObject) {
            this._targetValidity = this.validateTarget(hitObj, hitSubObj, mouseEvent.getModifiers());
            if ((hitSubObj == null || hitSubObj != this.getSelectInteractor().getPrimaryMoveSubObject()) && this._targetValidity != MoveType.INVALID && hitObj != null) {
                this.highlight(hitObj, hitSubObj, this._targetValidity);
            }
        }
        if (leftOwningContext != this._hadLeftOwningContext) {
            if (!leftOwningContext) {
                this._isDragMove = false;
                this._targetValidity = MoveType.SIMPLE_MOVE;
                this._hadLeftOwningContext = false;
            } else {
                this._hadLeftOwningContext = leftOwningContext;
            }
        }
        if (!leftOwningContext && this._hadLeftOwningContext) {
            this._isDragMove = false;
            this._targetValidity = MoveType.SIMPLE_MOVE;
            this._hadLeftOwningContext = false;
        } else if (!this._hadLeftOwningContext) {
            this._hadLeftOwningContext = leftOwningContext;
        }
        this._lastHitObject = hitObj;
        this._lastHitSubObject = hitSubObj;
        if (this._targetValidity != MoveType.SIMPLE_MOVE || !this._moveSubList.isEmpty()) {
            this.ensureDragMove();
        }
        if (this.getSelectInteractor().isOpaqueMove()) {
            this.translateSelections(dx, dy);
            this.setSelectionRect();
        }
        this.updateCursor();
        if (event instanceof MouseEvent) {
            this._lastDragEvent = (MouseEvent)event;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureDragMove() {
        IlvGraphic g;
        if (this._isDragMove) {
            return;
        }
        this._isDragMove = true;
        IlvManager mgr = this.getSelectInteractor().getMoveSelectionManager();
        IlvGraphicEnumeration e = this.getMovingObjects();
        while (e.hasMoreElements()) {
            g = e.nextElement();
            g.setProperty(GHOST_RECT_KEY, (Object)new IlvRect(g.boundingBox(ManagerUtil.getConversionTransformer(mgr, ManagerUtil.getManager(g)))));
        }
        e = this.getMovingObjects();
        while (e.hasMoreElements()) {
            g = e.nextElement();
            ManagerUtil.getManager(g).setContentsAdjusting(true, true);
        }
        try {
            this.getSelectInteractor().getMoveSelectionManager().initReDraws();
            e = this.getMovingObjects();
            while (e.hasMoreElements()) {
                g = e.nextElement();
                this.resetInitialRect(g);
                for (IlvGraphicBag bag = g.getGraphicBag(); bag != null; bag = bag.getGraphicBag()) {
                    if (!(bag instanceof IlvGraphic)) continue;
                    this.resetInitialRect((IlvGraphic)bag);
                }
            }
        }
        finally {
            this.getSelectInteractor().getMoveSelectionManager().reDrawViews();
        }
        e = this.getMovingObjects();
        while (e.hasMoreElements()) {
            g = e.nextElement();
            ManagerUtil.getManager(g).setContentsAdjusting(false, true);
        }
    }

    protected void updateCursor() {
        if (this.isDragging() && this.isMoved()) {
            if (this._isNativeDrag) {
                return;
            }
            switch (this.getCurrentTargetValidity()) {
                case INVALID: {
                    this.getManagerView().setCursor(DragSource.DefaultMoveNoDrop);
                    break;
                }
                case SIMPLE_MOVE: {
                    if (this._isDragMove) {
                        this.getManagerView().setCursor(DragSource.DefaultMoveDrop);
                        break;
                    }
                    this.getManagerView().setCursor(Cursor.getDefaultCursor());
                    break;
                }
                case MOVE: {
                    this.getManagerView().setCursor(DragSource.DefaultMoveDrop);
                    break;
                }
                case COPY: {
                    this.getManagerView().setCursor(DragSource.DefaultCopyDrop);
                    break;
                }
                case LINK: {
                    this.getManagerView().setCursor(DragSource.DefaultLinkDrop);
                }
            }
        } else {
            this.getManagerView().setCursor(Cursor.getDefaultCursor());
        }
    }

    protected IlvGraphic getHitSubObject(IlvGraphic mainObject, IlvManagerView view, IlvPoint mousePoint) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void translateSelections(float dx, float dy) {
        int redrawMode = this.getManagerView().getRedrawMode();
        IlvManager manager = this.getSelectInteractor().getMoveSelectionManager();
        boolean drawnGhosts = false;
        try {
            IlvRect r;
            IlvGraphic g;
            IlvGraphicEnumeration e;
            if (!this._isDragMove) {
                IlvManager myManager;
                IlvGraphic g2;
                manager.initReDraws();
                IlvGraphicEnumeration e2 = this.getMovingObjects();
                while (e2.hasMoreElements()) {
                    g2 = e2.nextElement();
                    myManager = (IlvManager)g2.getGraphicBag();
                    if (this._movingContainedObjects.contains(g2)) continue;
                    myManager.setContentsAdjusting(true, true);
                    this._translator.init(dx, dy, myManager.getDrawingTransformer(this.getManagerView()));
                    this._translator.translateObj(myManager, g2, true);
                }
                this.postTranslation();
                e2 = this.getMovingObjects();
                while (e2.hasMoreElements()) {
                    g2 = e2.nextElement();
                    myManager = (IlvManager)g2.getGraphicBag();
                    myManager.setContentsAdjusting(false, true);
                }
                try {
                    this.getManagerView().setRedrawMode(1);
                    manager.reDrawViews();
                }
                finally {
                    this.getManagerView().setRedrawMode(redrawMode);
                }
            }
            IlvTransformer tx = manager.getDrawingTransformer(this.getManagerView());
            IlvRect tmp = new IlvRect();
            IlvPoint pt = new IlvPoint();
            if (this._isDragMove) {
                e = this.getMovingObjects();
                while (e.hasMoreElements()) {
                    drawnGhosts = true;
                    g = e.nextElement();
                    r = (IlvRect)g.getProperty(GHOST_RECT_KEY);
                    tmp.setRect(r.x - 1.0f, r.y - 1.0f, r.width + 2.0f, r.height + 2.0f);
                    tx.apply(tmp);
                    this.getManagerView().invalidateRect(tmp);
                    pt.setLocation(r.x + r.width / 2.0f, r.y + r.height / 2.0f);
                    tx.apply(pt);
                    pt.translate(dx, dy);
                    tx.inverse(pt);
                    r.translate(pt.x - (r.x + r.width / 2.0f), pt.y - (r.y + r.height / 2.0f));
                    tmp.setRect(r.x - 1.0f, r.y - 1.0f, r.width + 2.0f, r.height + 2.0f);
                    tx.apply(tmp);
                    this.getManagerView().invalidateRect(tmp);
                }
            }
            e = this.getMovingSubObjects();
            while (e.hasMoreElements()) {
                drawnGhosts = true;
                g = e.nextElement();
                r = (IlvRect)g.getProperty(GHOST_RECT_KEY);
                tmp.setRect(r.x - 1.0f, r.y - 1.0f, r.width + 2.0f, r.height + 2.0f);
                tx.apply(tmp);
                this.getManagerView().invalidateRect(tmp);
                pt.setLocation(r.x + r.width / 2.0f, r.y + r.height / 2.0f);
                tx.apply(pt);
                pt.translate(dx, dy);
                tx.inverse(pt);
                r.translate(pt.x - (r.x + r.width / 2.0f), pt.y - (r.y + r.height / 2.0f));
                tmp.setRect(r.x - 1.0f, r.y - 1.0f, r.width + 2.0f, r.height + 2.0f);
                tx.apply(tmp);
                this.getManagerView().invalidateRect(tmp);
            }
        }
        finally {
            if (drawnGhosts) {
                try {
                    this.getManagerView().setRedrawMode(1);
                    this.getManagerView().reDrawViews();
                }
                finally {
                    this.getManagerView().setRedrawMode(redrawMode);
                }
            }
        }
    }

    protected void postTranslation() {
    }

    protected boolean isMoved() {
        return this._dragged;
    }

    protected boolean handleButtonUp(MouseEvent event) {
        boolean status = super.handleButtonUp(event);
        if (!this.isMoved()) {
            this.getSelectInteractor().processMouseEvent(event);
            return true;
        }
        return status;
    }

    protected void prepareInitialMoveState() {
        IlvGraphic g;
        this._dragged = false;
        this._aborting = false;
        this._isNativeDrag = false;
        this._isDragMove = false;
        this._lastHitObject = null;
        this._lastHitSubObject = null;
        this._targetValidity = MoveType.SIMPLE_MOVE;
        this._hadLeftOwningContext = false;
        CoreSelectInteractor i = this.getSelectInteractor();
        this._moveList = new IlvGraphicVector(64);
        this._moveSubList = new IlvGraphicVector(64);
        this._movingContainedObjects = new HashSet<IlvGraphic>();
        HashSet<IlvLinkImage> savedLinks = new HashSet<IlvLinkImage>();
        IlvGraphicEnumeration e = i.getSelectedMovingObjects(i.getMoveSelectionManager());
        while (e.hasMoreElements()) {
            g = e.nextElement();
            if (ManagerUtil.hasSelectedAncestor(g)) {
                this._movingContainedObjects.add(g);
            }
            this._moveList.addElement(g);
            IlvGraphicBag bag = g.getGraphicBag();
            if (g instanceof IlvLinkImage) {
                if (!savedLinks.contains((IlvLinkImage)g)) {
                    g.setProperty(INITIAL_LINK_POINTS, (Object)((IlvLinkImage)g).getLinkPoints(IDENTITY));
                    savedLinks.add((IlvLinkImage)g);
                }
            } else if (bag != null && bag instanceof IlvGrapher && ((IlvGrapher)bag).isNode(g)) {
                IlvGrapher grapher = (IlvGrapher)bag;
                IlvGraphicEnumeration graphic = grapher.getLinks(g);
                while (graphic.hasMoreElements()) {
                    IlvLinkImage link = (IlvLinkImage)graphic.nextElement();
                    if (savedLinks.contains(link)) continue;
                    link.setProperty(INITIAL_LINK_POINTS, (Object)link.getLinkPoints(IDENTITY));
                    savedLinks.add(link);
                }
            }
            g.setProperty(INITIAL_RECT_KEY, (Object)new IlvRect(g.boundingBox()));
            while (bag != null) {
                if (bag instanceof IlvGraphic) {
                    IlvGraphic bagGraphic = (IlvGraphic)bag;
                    bagGraphic.setProperty(INITIAL_RECT_KEY, (Object)new IlvRect(bagGraphic.boundingBox()));
                }
                bag = bag.getGraphicBag();
            }
        }
        e = i.getSelectedMovingSubObjects(i.getMoveSelectionManager());
        while (e.hasMoreElements()) {
            IlvGraphic subShape = e.nextElement();
            Object v = subShape.getProperty(MOVEABLE_SHAPE_KEY);
            if (v != null && !Boolean.TRUE.equals(v)) continue;
            this._moveSubList.addElement(subShape);
        }
        IlvManager mgr = i.getMoveSelectionManager();
        IlvGraphicEnumeration e2 = this._moveSubList.elements();
        while (e2.hasMoreElements()) {
            g = e2.nextElement();
            g.setProperty(GHOST_RECT_KEY, (Object)new IlvRect(g.boundingBox(ManagerUtil.getConversionTransformer(mgr, ManagerUtil.getTransformingManager(g)))));
        }
        this.setSelectionRect();
    }

    protected boolean handleButtonDown(MouseEvent event) {
        this.prepareInitialMoveState();
        this._lastMousePressed.setLocation((float)event.getX(), (float)event.getY());
        return super.handleButtonDown(event);
    }

    protected IlvGraphicEnumeration getMovingObjects() {
        return this._moveList.elements();
    }

    protected int getMovingObjectsCount() {
        return this._moveList.size();
    }

    protected IlvGraphicEnumeration getMovingSubObjects() {
        return this._moveSubList.elements();
    }

    protected int getMovingSubObjectsCount() {
        return this._moveSubList.size();
    }

    protected void handleExpose(Graphics graphics) {
        super.handleExpose(graphics);
        if (this.isMoved() && this.isDragging()) {
            IlvRect tmp;
            IlvGraphic gr;
            IlvGraphicEnumeration e;
            Graphics2D g = (Graphics2D)graphics;
            IlvTransformer tx = this.getSelectInteractor().getMoveSelectionManager().getDrawingTransformer(this.getManagerView());
            Paint oldPaint = g.getPaint();
            g.setPaint(Color.BLACK);
            IlvRect r = new IlvRect();
            if (this._isDragMove) {
                e = this.getMovingObjects();
                while (e.hasMoreElements()) {
                    gr = e.nextElement();
                    tmp = (IlvRect)gr.getProperty(GHOST_RECT_KEY);
                    r.setRect(tmp.x, tmp.y, tmp.width, tmp.height);
                    tx.apply(r);
                    g.drawRect((int)r.x, (int)r.y, (int)r.width, (int)r.height);
                }
                g.setPaint(oldPaint);
            }
            e = this.getMovingSubObjects();
            while (e.hasMoreElements()) {
                gr = e.nextElement();
                tmp = (IlvRect)gr.getProperty(GHOST_RECT_KEY);
                r.setRect(tmp.x, tmp.y, tmp.width, tmp.height);
                tx.apply(r);
                g.drawRect((int)r.x, (int)r.y, (int)r.width, (int)r.height);
            }
            g.setPaint(oldPaint);
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (this.isDragging() && this.isMoved()) {
            switch (keyEvent.getID()) {
                case 401: 
                case 402: {
                    MoveType targetValidity;
                    int modifierMask = 0;
                    if (keyEvent.isControlDown()) {
                        modifierMask |= 2;
                    }
                    if (keyEvent.isShiftDown()) {
                        modifierMask |= 1;
                    }
                    if (keyEvent.isAltDown()) {
                        modifierMask |= 8;
                    }
                    if ((targetValidity = this.validateTarget(this._lastHitObject, this._lastHitSubObject, modifierMask)) != this._targetValidity) {
                        if (this._lastHitObject != null && this._targetValidity != MoveType.INVALID) {
                            this.unhighlight(this._lastHitObject, this._lastHitSubObject, this._targetValidity);
                        }
                        this._targetValidity = targetValidity;
                        if (this._lastHitObject != null && this._targetValidity != MoveType.INVALID) {
                            this.highlight(this._lastHitObject, this._lastHitSubObject, this._targetValidity);
                        }
                        this.updateCursor();
                    }
                    if (this._targetValidity == MoveType.SIMPLE_MOVE) break;
                    this.ensureDragMove();
                }
            }
        } else if (keyEvent.getID() == 401 && !keyEvent.isConsumed()) {
            float dx = 0.0f;
            float dy = 0.0f;
            IlvGrid grid = this.getManagerView().getGrid();
            float incX = 0.0f;
            float incY = 0.0f;
            if (grid != null && grid.isActive()) {
                incX = grid.getHorizontalSpacing();
                incY = grid.getVerticalSpacing();
                IlvRect r = new IlvRect(0.0f, 0.0f, incX, incY);
                this.getManagerView().getTransformer().apply(r);
                incX = (float)r.getWidth();
                incY = (float)r.getHeight();
            } else {
                incY = 1.0f;
                incX = 1.0f;
            }
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    dy = -incY;
                    break;
                }
                case 40: {
                    dy = incY;
                    break;
                }
                case 37: {
                    dx = -incX;
                    break;
                }
                case 39: {
                    dx = incX;
                    break;
                }
                default: {
                    return;
                }
            }
            if (dx != 0.0f || dy != 0.0f) {
                keyEvent.consume();
                this.prepareInitialMoveState();
                if (this.isMoveAllowed()) {
                    this.captureUndoData();
                    this.translateSelections(dx, dy);
                    this.invalidateGhosts();
                    this.completeUndoData();
                }
                this.cleanupMoveState();
                if (this.getManagerView().getInteractor() == this) {
                    this.getManagerView().popInteractor();
                }
            }
        }
    }

    protected final IlvGraphic getLastHitObject() {
        return this._lastHitObject;
    }

    protected final IlvGraphic getLastHitSubObject() {
        return this._lastHitSubObject;
    }

    @Override
    public DragGestureListener getDragGestureListener() {
        return this._dgl;
    }

    @Override
    public DragSourceListener getDragSourceListener() {
        return this._dsl;
    }

    @Override
    public DropTargetListener getDropTargetListener() {
        return this._dtl;
    }

    protected IlvPoint getLastMousePressed() {
        return this._lastMousePressed;
    }

    protected boolean hasSelectedAncestor(IlvGraphic g) {
        IlvManager mgr = (IlvManager)g.getGraphicBag();
        while (mgr != null) {
            IlvManager mgrOfMgr = (IlvManager)mgr.getGraphicBag();
            if (mgrOfMgr != null && mgrOfMgr.isSelected((IlvGraphic)mgr)) {
                return true;
            }
            mgr = mgrOfMgr;
        }
        return false;
    }

    private void resetInitialRect(IlvGraphic g) {
        IlvRect initialRect = (IlvRect)g.getProperty(INITIAL_RECT_KEY);
        IlvManager mgr = ManagerUtil.getManager(g);
        if (initialRect != null && mgr != null) {
            IlvRect currentRect = g.boundingBox();
            this._translator.init((float)(initialRect.getX() - currentRect.getX()), (float)(initialRect.getY() - currentRect.getY()), null);
            this._translator.translateObj(mgr, g, true);
            if (initialRect.getWidth() != currentRect.getWidth() || initialRect.getHeight() != currentRect.getHeight()) {
                mgr.reshapeObject(g, initialRect, true);
            }
        }
    }

    private class MyTransformerListener
    implements TransformerListener {
        private MyTransformerListener() {
        }

        public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
            if (CoreSelectInteractorMoveSelection.this._dragged && CoreSelectInteractorMoveSelection.this._lastDragEvent != null && CoreSelectInteractorMoveSelection.this.getManagerView().getInteractor() == CoreSelectInteractorMoveSelection.this) {
                final MouseEvent event = new MouseEvent(CoreSelectInteractorMoveSelection.this._lastDragEvent.getComponent(), 506, System.currentTimeMillis(), CoreSelectInteractorMoveSelection.this._lastDragEvent.getModifiers(), CoreSelectInteractorMoveSelection.this._lastDragEvent.getX(), CoreSelectInteractorMoveSelection.this._lastDragEvent.getY(), CoreSelectInteractorMoveSelection.this._lastDragEvent.getClickCount(), false, CoreSelectInteractorMoveSelection.this._lastDragEvent.getButton());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IlvManagerView view = CoreSelectInteractorMoveSelection.this.getManagerView();
                        if (view != null && view.getInteractor() == CoreSelectInteractorMoveSelection.this) {
                            CoreSelectInteractorMoveSelection.this.processEvent(event);
                        }
                    }
                });
            }
        }
    }

    private class MyDropTargetListener
    implements DropTargetListener {
        private MyDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            int modifiers = CoreSelectInteractorMoveSelection.this._dragModifiers != -1 ? CoreSelectInteractorMoveSelection.this._dragModifiers : CoreSelectInteractorMoveSelection.convertDropActionToMouseModifier(dtde.getDropAction());
            CoreSelectInteractorMoveSelection.this.processEvent(new MouseEvent(dtde.getDropTargetContext().getComponent(), 506, System.currentTimeMillis(), modifiers, (int)dtde.getLocation().getX(), (int)dtde.getLocation().getY(), 0, false, 1));
            switch (CoreSelectInteractorMoveSelection.this.getCurrentTargetValidity()) {
                case INVALID: {
                    dtde.rejectDrag();
                    break;
                }
                case SIMPLE_MOVE: 
                case MOVE: {
                    break;
                }
                case COPY: {
                    break;
                }
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            int modifiers = CoreSelectInteractorMoveSelection.this._dragModifiers != -1 ? CoreSelectInteractorMoveSelection.this._dragModifiers : CoreSelectInteractorMoveSelection.convertDropActionToMouseModifier(dtde.getDropAction());
            CoreSelectInteractorMoveSelection.this.processEvent(new MouseEvent(dtde.getDropTargetContext().getComponent(), 506, System.currentTimeMillis(), modifiers, (int)dtde.getLocation().getX(), (int)dtde.getLocation().getY(), 0, false, 1));
            switch (CoreSelectInteractorMoveSelection.this.getCurrentTargetValidity()) {
                case INVALID: {
                    dtde.rejectDrag();
                    break;
                }
                case SIMPLE_MOVE: 
                case MOVE: {
                    break;
                }
                case COPY: {
                    break;
                }
            }
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            int modifiers = CoreSelectInteractorMoveSelection.this._dragModifiers != -1 ? CoreSelectInteractorMoveSelection.this._dragModifiers : CoreSelectInteractorMoveSelection.convertDropActionToMouseModifier(dtde.getDropAction());
            CoreSelectInteractorMoveSelection.this.processEvent(new MouseEvent(dtde.getDropTargetContext().getComponent(), 502, System.currentTimeMillis(), modifiers, (int)dtde.getLocation().getX(), (int)dtde.getLocation().getY(), 0, false, 1));
            dtde.dropComplete(true);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            CoreSelectInteractorMoveSelection.this.ensureDragMove();
            int modifiers = CoreSelectInteractorMoveSelection.this._dragModifiers != -1 ? CoreSelectInteractorMoveSelection.this._dragModifiers : CoreSelectInteractorMoveSelection.convertDropActionToMouseModifier(dtde.getDropAction());
            CoreSelectInteractorMoveSelection.this.processEvent(new MouseEvent(dtde.getDropTargetContext().getComponent(), 506, System.currentTimeMillis(), modifiers, (int)dtde.getLocation().getX(), (int)dtde.getLocation().getY(), 0, false, 1));
            switch (CoreSelectInteractorMoveSelection.this.getCurrentTargetValidity()) {
                case INVALID: {
                    dtde.rejectDrag();
                    break;
                }
                case SIMPLE_MOVE: 
                case MOVE: {
                    break;
                }
                case COPY: {
                    break;
                }
            }
        }
    }

    private class MyDragSourceListener
    implements DragSourceListener {
        private MyDragSourceListener() {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
            CoreSelectInteractorMoveSelection.this._dragModifiers = dsde.getGestureModifiers();
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
            CoreSelectInteractorMoveSelection.this._dragModifiers = -1;
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
            CoreSelectInteractorMoveSelection.this._dragModifiers = dsde.getGestureModifiers();
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
            CoreSelectInteractorMoveSelection.this._dragModifiers = dsde.getGestureModifiers();
        }
    }

    private class MyDragGestureListener
    implements DragGestureListener {
        private MyDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            CoreSelectInteractorMoveSelection.this._isNativeDrag = true;
        }
    }

    public static enum MoveType {
        INVALID,
        SIMPLE_MOVE,
        MOVE,
        COPY,
        LINK;

    }
}

