/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.interaction;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.event.InteractorChangedEvent;
import ilog.views.event.InteractorListener;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.interactor.IlvMakeRectangleInteractor;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.interaction.AutoscrollInteractorMarker;
import oracle.diagram.framework.manager.ManagerUtil;

public class CoreMakeRectangleInteractor
extends IlvMakeRectangleInteractor
implements AutoscrollInteractorMarker {
    private final IlvPoint _tmpPoint = new IlvPoint();
    private IlvGraphic _lastHitObject = null;
    private IlvGraphic _lastTarget = null;
    private boolean _started = false;
    private boolean m_forceMouseMotionEvent;
    private MyTransformerListener _transformerListener;
    private MouseEvent _lastDragEvent;
    private InteractorListener m_InteractorChangedListener;

    public CoreMakeRectangleInteractor() {
        super.setRotationAllowed(true);
    }

    protected void attach(IlvManagerView IlvManagerView2) {
        super.attach(IlvManagerView2);
        this._lastHitObject = null;
        this._lastTarget = null;
        this._started = false;
        this._transformerListener = new MyTransformerListener();
        IlvManagerView2.addTransformerListener((TransformerListener)this._transformerListener);
        this.m_InteractorChangedListener = new InteractorChangedListener();
        IlvManagerView2.addInteractorListener(this.m_InteractorChangedListener);
    }

    protected void detach() {
        IlvManagerView view = this.getManagerView();
        view.removeTransformerListener((TransformerListener)this._transformerListener);
        this._transformerListener = null;
        view.removeInteractorListener(this.m_InteractorChangedListener);
        this.m_InteractorChangedListener = null;
        this._lastDragEvent = null;
        super.detach();
        this._lastHitObject = null;
        this._lastTarget = null;
        this._started = false;
    }

    protected IlvGraphic getCurentHitObject() {
        return this._lastHitObject;
    }

    protected IlvGraphic getCurrentTarget() {
        return this._lastTarget;
    }

    protected IlvGraphic getActualTargetFromHit(IlvGraphic hit) {
        if (hit instanceof IlvManager) {
            return hit;
        }
        return ManagerUtil.getManager(hit);
    }

    protected boolean isValidTarget(IlvGraphic target) {
        return target instanceof IlvManager;
    }

    protected void highlight(IlvGraphic target) {
    }

    protected void unhighlight(IlvGraphic target) {
    }

    protected void updateCursor(IlvGraphic target, boolean valid) {
    }

    protected void processMouseMotionEvent(MouseEvent event) {
        if (event.getID() == 503 && !this.handleMouseMove(event)) {
            super.processMouseMotionEvent(event);
            return;
        }
        super.processMouseMotionEvent(event);
    }

    protected boolean handleButtonDragged(MouseEvent event) {
        boolean allowEnsureVisible = this.allowEnsureVisible();
        this.allowEnsureVisible(false);
        boolean rc = super.handleButtonDragged(event);
        this.allowEnsureVisible(allowEnsureVisible);
        this._lastDragEvent = event;
        return rc;
    }

    protected boolean handleButtonDown(MouseEvent event) {
        if (this.m_forceMouseMotionEvent) {
            this.handleMouseMove(event);
            this.m_forceMouseMotionEvent = false;
        }
        if (this.isValidTarget(this._lastTarget)) {
            this._started = true;
            if (this._lastTarget != null) {
                this.unhighlight(this._lastTarget);
            }
            return super.handleButtonDown(event);
        }
        return false;
    }

    protected boolean handleButtonUp(MouseEvent event) {
        this._started = false;
        return super.handleButtonUp(event);
    }

    protected boolean handleMouseMove(MouseEvent event) {
        this._tmpPoint.setLocation((float)event.getX(), (float)event.getY());
        IlvManager mgr = this.getManager();
        IlvManagerView view = this.getManagerView();
        IlvGraphic hit = mgr.getObject(this._tmpPoint, view, true);
        if (hit == null) {
            hit = mgr;
        }
        if (hit != this._lastHitObject && hit != null) {
            IlvGraphic target = this.getActualTargetFromHit(hit);
            if (target != this._lastTarget) {
                if (this._lastTarget != null) {
                    this.unhighlight(this._lastTarget);
                }
                if (this.isValidTarget(target)) {
                    this._lastTarget = target;
                    if (target != null) {
                        this.highlight(target);
                    }
                    this.updateCursor(target, true);
                } else {
                    this._lastTarget = null;
                    this.updateCursor(target, false);
                }
            }
            this._lastHitObject = hit;
        }
        this.m_forceMouseMotionEvent = false;
        return false;
    }

    public IlvRect getGhostRectangle() {
        return this.getDraggedRectangle();
    }

    public final DiagramContext getDiagramContext() {
        return DiagramContext.getDiagramContext(this.getManagerView());
    }

    public void setRotationAllowed(boolean allowed) {
    }

    private class InteractorChangedListener
    implements InteractorListener {
        private InteractorChangedListener() {
        }

        public void interactorChanged(InteractorChangedEvent event) {
            if (event.getNewValue() != CoreMakeRectangleInteractor.this) {
                CoreMakeRectangleInteractor.this.m_forceMouseMotionEvent = true;
            }
        }
    }

    private class MyTransformerListener
    implements TransformerListener {
        private MyTransformerListener() {
        }

        public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
            if (CoreMakeRectangleInteractor.this._started && CoreMakeRectangleInteractor.this._lastDragEvent != null && CoreMakeRectangleInteractor.this.getManagerView().getInteractor() == CoreMakeRectangleInteractor.this) {
                final MouseEvent event = new MouseEvent(CoreMakeRectangleInteractor.this._lastDragEvent.getComponent(), 506, System.currentTimeMillis(), CoreMakeRectangleInteractor.this._lastDragEvent.getModifiers(), CoreMakeRectangleInteractor.this._lastDragEvent.getX(), CoreMakeRectangleInteractor.this._lastDragEvent.getY(), CoreMakeRectangleInteractor.this._lastDragEvent.getClickCount(), false, CoreMakeRectangleInteractor.this._lastDragEvent.getButton());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CoreMakeRectangleInteractor.this.processEvent(event);
                    }
                });
            }
        }
    }
}

