/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.net;

import oracle.ide.Addin;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.net.TraceFileSystemAccess;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.net.VirtualFileSystemHelper;
import oracle.javatools.data.PropertyStorage;

public class VirtualFileSystemAddin
implements Addin,
ShutdownHook {
    public void initialize() {
        URLFileSystemHelper fileHelper = URLFileSystem.findHelper((String)"file");
        if (fileHelper != null) {
            URLFileSystemHelper current = fileHelper;
            URLFileSystemHelperDecorator last = null;
            while (current instanceof URLFileSystemHelperDecorator && !(current instanceof TraceFileSystemAccess)) {
                last = (URLFileSystemHelperDecorator)current;
                current = last.getHelper();
            }
            if (last != null) {
                last.insertNextDecorator((URLFileSystemHelperDecorator)new VirtualFileSystemHelper(fileHelper));
            } else {
                URLFileSystem.registerHelper((String)"file", (URLFileSystemHelper)new VirtualFileSystemHelper(fileHelper));
            }
            VirtualFileSystemHelper.enableVFS();
            VirtualFileSystemHelper.enableNativeWatching();
            EnvironOptions options = EnvironOptions.getInstance((PropertyStorage)Preferences.getPreferences());
            boolean verify = options.getVerifyCachedFileData();
            VirtualFileSystemHelper.setVerifyPersistedData(verify);
            ExitCommand.addShutdownHook((ShutdownHook)this);
        }
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
        VirtualFileSystemHelper.shutdownVFS();
    }
}

