/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.View;
import oracle.javatools.db.sql.DeclarativeSQLQuery;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.db.validators.RelationValidator;
import oracle.javatools.util.ModelUtil;

public class ViewValidator
extends RelationValidator {
    public ViewValidator(DBObjectProvider prov) {
        super(prov);
    }

    @AbstractValidator.PropertyValidator(value={"SQLQuery"})
    public void validateView(View original, View view) throws ValidationException {
        block3: {
            SQLQuery query = view.getSQLQuery();
            if (query == null) {
                throw new ValidationException((DBObject)view, "View must have a SQL Query");
            }
            try {
                SQLQueryBuilder builder = SQLQueryBuilderFactory.createBuilder((DBObjectProvider)this.getProvider(), (Schema)view.getSchema());
                builder.buildQuery(query);
            }
            catch (SQLQueryException sqe) {
                if (!(query instanceof DeclarativeSQLQuery) && !(sqe instanceof SQLParseException)) break block3;
                throw new ValidationException((DBObject)view, sqe.getMessage());
            }
        }
    }

    @AbstractValidator.PropertyValidator(value={"queryRestriction"})
    public void validateQueryRestriction(View original, View view) throws ValidationException {
        OrderByObject[] orderBy;
        SQLQuery query;
        String restriction = view.getQueryRestriction();
        if (ModelUtil.hasLength((String)restriction) && (query = view.getSQLQuery()) instanceof DeclarativeSQLQuery && (orderBy = ((DeclarativeSQLQuery)query).getOrderByObjects()) != null && orderBy.length > 0) {
            throw new ValidationException((DBObject)view, DBArb.format((int)357, (Object)restriction));
        }
    }
}

