/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FileSpecification;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.validators.AbstractValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablespaceValidator
extends AbstractValidator<Tablespace> {
    public TablespaceValidator(DBObjectProvider prov) {
        super(prov);
    }

    @AbstractValidator.PropertyValidator(value={"properties", "TablespaceType"}, path=true)
    public void validateTablespaceType(Tablespace original, Tablespace updated) throws ValidationException {
        Tablespace.TablespaceType updTbspType;
        Tablespace.TablespaceType origTbspType;
        if (original != null && !(origTbspType = (Tablespace.TablespaceType)original.getProperty("TablespaceType")).equals((Object)(updTbspType = (Tablespace.TablespaceType)updated.getProperty("TablespaceType"))) && updTbspType.equals((Object)Tablespace.TablespaceType.UNDO)) {
            throw new ValidationException((DBObject)updated, DBArb.getString((int)81));
        }
    }

    @AbstractValidator.PropertyValidator(value={"properties", "OracleTablespaceProperties"}, path=true)
    public void validateOracleTablespaceProps(Tablespace original, Tablespace updated) throws ValidationException {
        OracleTablespaceProperties oracleTbspProperties = (OracleTablespaceProperties)updated.getProperty("OracleTablespaceProperties");
        if (oracleTbspProperties != null) {
            this.getProvider().validateObject((DBObject)oracleTbspProperties);
        }
    }

    @AbstractValidator.PropertyValidator(value={"fileType"})
    public void validateFileTypeUpdate(Tablespace original, Tablespace updated) throws ValidationException {
        if (original != null && original.getFileType().equals((Object)Tablespace.FileType.SMALLFILE) && updated.getFileType().equals((Object)Tablespace.FileType.BIGFILE) && updated.getFileSpecifications() != null && updated.getFileSpecifications().length > 1) {
            throw new ValidationException((DBObject)updated, DBArb.getString((int)83));
        }
    }

    @AbstractValidator.PropertyValidator(value={"fileSpecifications"})
    public void validateFileSpecs(Tablespace original, Tablespace updated) throws ValidationException {
        FileSpecification[] fileSpecs = updated.getFileSpecifications();
        for (int i = 0; i < fileSpecs.length; ++i) {
            this.getProvider().validateObject((DBObject)fileSpecs[i]);
        }
        TablespaceValidator.validateUniqueNames((DBObject[])fileSpecs);
    }
}

