/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.math.BigInteger;
import java.text.MessageFormat;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.validators.AbstractSchemaObjectValidator;
import oracle.javatools.db.validators.AbstractValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceValidator
extends AbstractSchemaObjectValidator<Sequence> {
    public static final int OK = 1;
    public static final int ERROR_ZERO_INCREMENT = -2;
    public static final int ERROR_INCREMENT_TOO_MANY_DIGITS = -3;
    public static final int ERROR_INCREMENT_TOO_BIG = -4;
    public static final int ERROR_START_TOO_MANY_DIGITS = -5;
    public static final int ERROR_START_LESS_THAN_MIN = -6;
    public static final int ERROR_START_GREATER_THAN_MAX = -7;
    public static final int ERROR_MIN_TOO_MANY_DIGITS = -8;
    public static final int ERROR_MIN_GREATER_THAN_START = -9;
    public static final int ERROR_MIN_GREATER_THAN_MAX = -10;
    public static final int ERROR_MAX_TOO_MANY_DIGITS = -11;
    public static final int ERROR_MAX_LESS_THAN_START = -12;
    public static final int ERROR_MAX_LESS_THAN_MIN = -13;
    public static final int ERROR_CACHE_TOO_MANY_DIGITS = -14;
    public static final int ERROR_CACHE_TOO_SMALL = -15;
    public static final int ERROR_CACHE_TOO_BIG = -16;
    public static final int ERROR_MAX_REQD_FOR_ASCENDING_CYCLE = -17;
    private static final BigInteger MAX27 = BigInteger.valueOf(10L).pow(27);
    private static final BigInteger MIN26 = BigInteger.valueOf(10L).pow(26).negate();
    private static final BigInteger DIGITS28 = BigInteger.valueOf(10L).pow(28).subtract(BigInteger.ONE);

    public SequenceValidator(DBObjectProvider prov) {
        super(prov);
    }

    private String formatBigInteger(BigInteger value, BigInteger defaultedValue) {
        String result = defaultedValue.toString();
        if (null == value) {
            result = MessageFormat.format(DBArb.getString((int)102), result);
        }
        return result;
    }

    private boolean tooBig(BigInteger val) {
        return val.abs().compareTo(DIGITS28) > 0;
    }

    private BigInteger getIncrement(BigInteger increment) {
        BigInteger retval = BigInteger.ONE;
        if (increment != null && !increment.equals(BigInteger.ZERO)) {
            retval = increment;
        }
        return retval;
    }

    private BigInteger getMaxValue(BigInteger incr, BigInteger maxValue) {
        BigInteger max = MAX27;
        if (null != maxValue) {
            max = maxValue;
        } else if (incr.signum() < 0) {
            max = BigInteger.ONE.negate();
        }
        return max;
    }

    private BigInteger getMinValue(BigInteger incr, BigInteger minValue) {
        BigInteger min = BigInteger.ONE;
        if (null != minValue) {
            min = minValue;
        } else if (incr.signum() < 0) {
            min = MIN26;
        }
        return min;
    }

    @AbstractValidator.PropertyValidator(value={"incrementBy"})
    @AbstractValidator.PropertyDependency(value={"minValue", "maxValue"})
    public void validateIncrement(Sequence original, Sequence seq) throws ValidationException {
        BigInteger seqIncr = seq.getIncrementBy();
        BigInteger seqMin = seq.getMinValue();
        BigInteger seqMax = seq.getMaxValue();
        int v = this.validateIncrement(seqIncr, seqMin, seqMax);
        switch (v) {
            case -3: {
                throw new ValidationException((DBObject)seq, MessageFormat.format(DBArb.getString((int)104), seq.getName()));
            }
            case -2: {
                throw new ValidationException((DBObject)seq, MessageFormat.format(DBArb.getString((int)103), seq.getName()));
            }
            case -4: {
                BigInteger incr = this.getIncrement(seqIncr);
                BigInteger min = this.getMinValue(incr, seqMin);
                BigInteger max = this.getMaxValue(incr, seqMax);
                throw new ValidationException((DBObject)seq, MessageFormat.format(DBArb.getString((int)105), this.formatBigInteger(seqIncr, incr), this.formatBigInteger(seqMin, min), this.formatBigInteger(seqMax, max)));
            }
        }
        if (1 != v) {
            // empty if block
        }
    }

    private int validateIncrement(BigInteger increment, BigInteger minValue, BigInteger maxValue) {
        int result = 1;
        if (null != increment) {
            if (increment.equals(BigInteger.ZERO)) {
                result = -2;
            } else if (this.tooBig(increment)) {
                result = -3;
            } else {
                BigInteger incr = increment;
                BigInteger max = this.getMaxValue(incr, maxValue);
                BigInteger min = this.getMinValue(incr, minValue);
                if (incr.abs().compareTo(max.subtract(min).abs()) >= 0) {
                    result = -4;
                }
            }
        }
        return result;
    }

    @AbstractValidator.PropertyValidator(value={"startWith"})
    @AbstractValidator.PropertyDependency(value={"minValue", "maxValue"})
    public void validateStartWith(Sequence original, Sequence seq) throws ValidationException {
        BigInteger seqIncr = seq.getIncrementBy();
        BigInteger incr = this.getIncrement(seqIncr);
        BigInteger seqStart = seq.getStartWith();
        BigInteger seqMin = seq.getMinValue();
        BigInteger seqMax = seq.getMaxValue();
        int v = this.validateStartWith(seqStart, seqIncr, seqMin, seqMax);
        switch (v) {
            case -5: {
                throw new ValidationException((DBObject)seq, MessageFormat.format(DBArb.getString((int)106), seq.getName()));
            }
            case -6: {
                throw new ValidationException((DBObject)seq, MessageFormat.format(DBArb.getString((int)107), seqStart, this.formatBigInteger(seqMin, this.getMinValue(incr, seqMin))));
            }
            case -7: {
                String start = seqStart.toString();
                throw new ValidationException((DBObject)seq, MessageFormat.format(DBArb.getString((int)108), start, this.formatBigInteger(seqMax, this.getMaxValue(incr, seqMax))));
            }
        }
        if (1 != v) {
            // empty if block
        }
    }

    private int validateStartWith(BigInteger startWith, BigInteger increment, BigInteger minValue, BigInteger maxValue) throws ValidationException {
        int result = 1;
        if (null != startWith) {
            if (this.tooBig(startWith)) {
                result = -5;
            } else {
                BigInteger incr = this.getIncrement(increment);
                BigInteger start = startWith;
                if (incr.signum() > 0) {
                    BigInteger min = this.getMinValue(incr, minValue);
                    if (start.compareTo(min) < 0) {
                        result = -6;
                    }
                } else {
                    BigInteger max = this.getMaxValue(incr, maxValue);
                    if (start.compareTo(max) > 0) {
                        result = -7;
                    }
                }
            }
        }
        return result;
    }

    protected boolean validateMinMaxChange() {
        return this.getProvider() instanceof Database;
    }

    @AbstractValidator.PropertyValidator(value={"minValue"})
    @AbstractValidator.PropertyDependency(value={"startWith", "maxValue"})
    public void validateMinValue(Sequence original, Sequence seq) throws ValidationException {
        BigInteger seqStart = seq.getStartWith();
        BigInteger seqMin = seq.getMinValue();
        BigInteger seqMax = seq.getMaxValue();
        int v = this.validateMinValue(seqMin, seqStart, seqMax);
        switch (v) {
            case -8: {
                throw new ValidationException((DBObject)seq, MessageFormat.format(DBArb.getString((int)111), seq.getName()));
            }
            case -9: {
                throw new ValidationException((DBObject)seq, MessageFormat.format(DBArb.getString((int)112), seq.getMinValue(), seq.getStartWith()));
            }
            case -10: {
                throw new ValidationException((DBObject)seq, MessageFormat.format(DBArb.getString((int)113), seq.getMinValue(), seq.getMaxValue()));
            }
        }
        if (1 != v) {
            // empty if block
        }
        if (original != null && this.validateMinMaxChange()) {
            BigInteger minValue = seq.getMinValue();
            BigInteger lastNum = original.getLastNumber();
            if (minValue != null && lastNum != null && minValue.compareTo(lastNum) > 0) {
                throw new ValidationException((DBObject)seq, DBArb.format((int)109, (Object)minValue.toString(), (Object)lastNum));
            }
        }
    }

    private int validateMinValue(BigInteger minValue, BigInteger startWith, BigInteger maxValue) throws ValidationException {
        int result = 1;
        if (null != minValue) {
            if (this.tooBig(minValue)) {
                result = -8;
            } else {
                if (null != startWith && minValue.compareTo(startWith) > 0) {
                    result = -9;
                }
                if (null != maxValue && minValue.compareTo(maxValue) > 0) {
                    result = -10;
                }
            }
        }
        return result;
    }

    @AbstractValidator.PropertyValidator(value={"maxValue"})
    @AbstractValidator.PropertyDependency(value={"minValue", "startWith", "incrementBy", "cycleFlag"})
    public void validateMaxValue(Sequence original, Sequence seq) throws ValidationException {
        BigInteger seqStart = seq.getStartWith();
        BigInteger seqMin = seq.getMinValue();
        BigInteger seqMax = seq.getMaxValue();
        BigInteger seqIncr = seq.getIncrementBy();
        Boolean seqCycle = seq.getCycleFlag();
        int v = this.validateMaxValue(seqMax, seqStart, seqMin, seqIncr, seqCycle);
        switch (v) {
            case -11: {
                throw new ValidationException((DBObject)seq, MessageFormat.format(DBArb.getString((int)114), seq.getName()));
            }
            case -12: {
                throw new ValidationException((DBObject)seq, MessageFormat.format(DBArb.getString((int)115), seq.getMaxValue(), seq.getStartWith()));
            }
            case -13: {
                throw new ValidationException((DBObject)seq, MessageFormat.format(DBArb.getString((int)116), seq.getMaxValue(), seq.getMinValue()));
            }
            case -17: {
                throw new ValidationException((DBObject)seq, DBArb.getString((int)121));
            }
        }
        if (1 != v) {
            // empty if block
        }
        if (original != null && this.validateMinMaxChange()) {
            BigInteger maxValue = seq.getMaxValue();
            BigInteger lastNumber = original.getLastNumber();
            if (maxValue != null && lastNumber != null && maxValue.compareTo(lastNumber) < 0) {
                throw new ValidationException((DBObject)seq, DBArb.format((int)110, (Object)maxValue.toString(), (Object)lastNumber));
            }
        }
    }

    private int validateMaxValue(BigInteger maxValue, BigInteger startWith, BigInteger minValue, BigInteger increment, Boolean cycle) throws ValidationException {
        int result = 1;
        BigInteger incr = this.getIncrement(increment);
        if (null != cycle && cycle.equals(Boolean.TRUE) && incr.signum() > 0 && maxValue == null) {
            result = -17;
        } else if (null != maxValue) {
            if (this.tooBig(maxValue)) {
                result = -11;
            } else {
                if (null != startWith && maxValue.compareTo(startWith) < 0) {
                    result = -12;
                }
                if (null != minValue && maxValue.compareTo(minValue) <= 0) {
                    result = -13;
                }
            }
        }
        return result;
    }

    @AbstractValidator.PropertyValidator(value={"orderFlag"})
    public void validateOrderFlag(Sequence original, Sequence seq) throws ValidationException {
    }

    @AbstractValidator.PropertyValidator(value={"cycleFlag"})
    public void validateCycleFlag(Sequence original, Sequence seq) throws ValidationException {
    }

    @AbstractValidator.PropertyValidator(value={"cacheFlag", "cacheSize"})
    @AbstractValidator.PropertyDependency(value={"minValue", "maxValue", "startWith", "incrementBy"})
    public void validateCache(Sequence original, Sequence seq) throws ValidationException {
        BigInteger seqIncr = seq.getIncrementBy();
        BigInteger seqCache = seq.getCacheSize();
        BigInteger seqMin = seq.getMinValue();
        BigInteger seqMax = seq.getMaxValue();
        Boolean seqCycle = seq.getCycleFlag();
        Boolean seqCacheFlag = seq.getCacheFlag();
        boolean usedDefaultCacheSize = false;
        if (seqCacheFlag == null || !seqCacheFlag.equals(Boolean.FALSE)) {
            if (seqCacheFlag == null && seqCache == null) {
                seqCache = BigInteger.valueOf(20L);
                usedDefaultCacheSize = true;
            }
            if (seqCache == null) {
                throw new ValidationException((DBObject)seq, MessageFormat.format(DBArb.getString((int)118), "", seq.getName()));
            }
            int v = this.validateCache(seqCache, seqIncr, seqMin, seqMax, seqCycle);
            switch (v) {
                case -14: {
                    throw new ValidationException((DBObject)seq, MessageFormat.format(DBArb.getString((int)117), seq.getName()));
                }
                case -15: {
                    throw new ValidationException((DBObject)seq, MessageFormat.format(DBArb.getString((int)118), seqCache.toString()));
                }
                case -16: {
                    BigInteger maxCache = this.maxCacheSize(seqIncr, seqMin, seqMax);
                    if (usedDefaultCacheSize) {
                        throw new ValidationException((DBObject)seq, MessageFormat.format(DBArb.getString((int)120), maxCache.toString()));
                    }
                    throw new ValidationException((DBObject)seq, MessageFormat.format(DBArb.getString((int)119), seqCache.toString(), maxCache.toString()));
                }
            }
            if (1 != v) {
                // empty if block
            }
        }
    }

    private int validateCache(BigInteger cache, BigInteger increment, BigInteger minValue, BigInteger maxValue, Boolean cycle) throws ValidationException {
        int result = 1;
        if (null != cache) {
            BigInteger maxCache;
            if (this.tooBig(cache)) {
                result = -14;
            } else if (cache.compareTo(BigInteger.valueOf(2L)) < 0) {
                result = -15;
            } else if (null != cycle && cycle.equals(Boolean.TRUE) && cache.compareTo(maxCache = this.maxCacheSize(increment, minValue, maxValue)) > 0) {
                result = -16;
            }
        }
        return result;
    }

    private BigInteger maxCacheSize(BigInteger increment, BigInteger minValue, BigInteger maxValue) {
        BigInteger incr = this.getIncrement(increment);
        BigInteger max = this.getMaxValue(incr, maxValue);
        BigInteger min = this.getMinValue(incr, minValue);
        BigInteger[] dr = max.subtract(min).abs().divideAndRemainder(incr.abs());
        BigInteger maxCache = dr[0];
        if (dr[1].signum() > 0) {
            maxCache = maxCache.add(BigInteger.ONE);
        }
        return maxCache;
    }
}

