/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.HashSet;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.diff.IndexObjectComparator;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.validators.AbstractSchemaObjectValidator;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexValidator
extends AbstractSchemaObjectValidator<Index> {
    public IndexValidator(DBObjectProvider prov) {
        super(prov);
    }

    @Override
    public void validateObject(Index original, Index updated) throws ValidationException {
        if (updated.getParent() == null) {
            throw new ValidationException((DBObject)updated, DBArb.getString((int)122));
        }
        super.validateObject(original, updated);
    }

    @AbstractValidator.PropertyValidator(value={"columnExpressions"})
    public void validateExpressions(Index original, Index index) throws ValidationException {
        IndexObject[] ios = index.getColumnExpressions();
        if (ios.length <= 0) {
            throw new ValidationException((DBObject)index, DBArb.getString((int)125));
        }
        this.checkColumnExpressions(index);
        this.checkDefinitionIsUnique(index);
    }

    @Override
    protected void validateNameInUse(Index index) throws NameInUseException {
        block6: {
            Table table = index.getTable();
            try {
                IndexValidator.validateUniqueNames((DBObject[])table.getIndexes());
            }
            catch (ValidationException x) {
                throw new NameInUseException((DBObject)index);
            }
            if (this.enforceChildNameUniqueInSchema((DBObject)index)) {
                try {
                    super.validateNameInUse(index);
                }
                catch (NameInUseException x) {
                    String tableType = table.getType();
                    if (table instanceof MaterializedView) {
                        tableType = "TABLE";
                    }
                    if (!ModelUtil.areDifferent((Object)table.getName(), (Object)x.getUserName()) && !ModelUtil.areDifferent((Object)tableType, (Object)x.getUserType())) break block6;
                    throw x;
                }
            }
        }
    }

    @Override
    protected boolean enforceChildNameUniqueInSchema(DBObject obj) {
        return !this.isChildOfPendingObject(obj);
    }

    protected void validateColumnType(Index index, Column col) throws ValidationException {
    }

    protected void checkColumnExpressions(Index index) throws ValidationException {
        IndexObject[] ios = index.getColumnExpressions();
        Table t = index.getTable();
        HashSet<String> columnNames = new HashSet<String>();
        boolean noColumns = t instanceof MaterializedView && t.getColumns().length == 0;
        for (int i = 0; i < ios.length; ++i) {
            SQLFragment expression = ios[i].getExpression();
            if (expression instanceof ColumnUsage) {
                ((ColumnUsage)expression).setProvider(this.getProvider());
            }
            String columnName = this.getProvider().getInternalName(expression.getSQLText());
            if (this.columnMustBeUnique()) {
                if (columnNames.contains(columnName)) {
                    throw new ValidationException((DBObject)index, DBArb.format((int)132, (Object)columnName, (Object)index.getName()));
                }
                columnNames.add(columnName);
            }
            if (noColumns) continue;
            Column column = t.getColumn(columnName);
            if (column == null) {
                throw new ValidationException((DBObject)index, DBArb.format((int)126, (Object)t.getName()));
            }
            this.validateColumnType(index, column);
        }
    }

    protected boolean columnMustBeUnique() {
        return true;
    }

    protected void checkDefinitionIsUnique(Index index) throws ValidationException {
        IndexObject[] indexColExprs = index.getColumnExpressions();
        Table indexTable = index.getTable();
        Index[] indexes = indexTable.getIndexes();
        IndexObjectComparator ioComparator = new IndexObjectComparator();
        DBObjectID indexid = DBUtil.getOriginalID((DBObject)index);
        boolean compareName = indexid == null;
        String indexName = index.getName();
        for (int j = 0; j < indexes.length; ++j) {
            IndexObject[] cffColExprs;
            DBObjectID indexjid = DBUtil.getOriginalID((DBObject)indexes[j]);
            boolean bl = indexjid == null;
            String indexjName = indexes[j].getName();
            boolean nameSame = ModelUtil.areEqual((Object)indexName, (Object)indexjName);
            if ((compareName |= bl) && nameSame || !compareName && indexjid.equals(indexid) || indexColExprs.length != (cffColExprs = indexes[j].getColumnExpressions()).length) continue;
            boolean iosAreDifferent = false;
            for (int i = 0; i < indexColExprs.length; ++i) {
                if (ioComparator.compare(indexColExprs[i], cffColExprs[i]) == 0) continue;
                iosAreDifferent = true;
                break;
            }
            if (iosAreDifferent) continue;
            throw new ValidationException((DBObject)index, DBArb.format((int)123, (Object)indexName, (Object)indexjName));
        }
    }
}

