/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.math.BigInteger;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FileSpecification;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.validators.AbstractValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSpecificationValidator
extends AbstractValidator<FileSpecification> {
    private static Integer n1 = new Integer(1);

    public FileSpecificationValidator(DBObjectProvider prov) {
        super(prov);
    }

    @AbstractValidator.PropertyValidator(value={"fileSize"})
    public void validateFileSize(FileSpecification original, FileSpecification updated) throws ValidationException {
        Tablespace tbsp;
        Tablespace.TablespaceType tbspType;
        BigInteger fileSize = updated.getFileSize();
        if (fileSize != null && fileSize.compareTo(BigInteger.ONE) != 1) {
            throw new ValidationException((DBObject)updated, DBArb.format((int)274, (Object)"File Size", (Object)n1));
        }
        if (updated.getParent() instanceof Tablespace && fileSize == null && (tbspType = (Tablespace.TablespaceType)(tbsp = (Tablespace)updated.getParent()).getProperty("TablespaceType")).equals((Object)Tablespace.TablespaceType.UNDO)) {
            throw new ValidationException((DBObject)updated, DBArb.getString((int)82));
        }
    }
}

