/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.ArrayList;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.util.ModelUtil;

public class ConstraintValidator
extends AbstractValidator {
    public ConstraintValidator(DBObjectProvider prov) {
        super(prov);
    }

    public void validateObject(DBObject original, DBObject updated) throws ValidationException {
        assert (updated != null);
        assert (updated instanceof Constraint);
        Constraint constraint = (Constraint)updated;
        if (constraint.getParent() == null || !this.existsInParent(constraint)) {
            throw new IllegalStateException(DBArb.getString((int)230));
        }
        if (original == null || ModelUtil.areDifferent((Object)original, (Object)constraint)) {
            super.validateObject(original, constraint);
        }
        this.validateConstraintDefinition(constraint);
    }

    protected void validateNameInUse(DBObject object) throws NameInUseException {
        block7: {
            assert (object != null);
            assert (object instanceof Constraint);
            Constraint constraint = (Constraint)object;
            try {
                ConstraintValidator.validateUniqueNames((DBObject[])constraint.getRelation().getConstraints());
            }
            catch (ValidationException x) {
                throw new NameInUseException((DBObject)constraint);
            }
            if (this.enforceChildNameUniqueInSchema((DBObject)constraint)) {
                try {
                    super.validateNameInUse(constraint);
                }
                catch (NameInUseException x) {
                    Relation relation = constraint.getRelation();
                    if (!ModelUtil.areDifferent((Object)relation.getName(), (Object)x.getUserName()) && !ModelUtil.areDifferent((Object)relation.getType(), (Object)x.getUserType())) break block7;
                    throw x;
                }
            }
        }
    }

    protected void validateConstraintDefinition(Constraint con) throws ValidationException {
        String type = con.getConstraintType();
        if (con instanceof CheckConstraint) {
            String condition;
            Relation parent = (Relation)con.getParent();
            SQLFragment condFrag = ((CheckConstraint)con).getCheckConditionFragment();
            String string = condition = condFrag == null ? null : condFrag.getSQLText();
            if (!ModelUtil.hasLength((String)condition)) {
                throw new ValidationException((DBObject)con, DBArb.format((int)250, (Object)con.getName()));
            }
            try {
                for (String[] nameComponents : ParserUtils.getColumnNames((String)condition, (ParserUtils.ExpressionType)ParserUtils.ExpressionType.BOOLEAN)) {
                    String colName = this.getProvider().getInternalName(nameComponents[0]);
                    Column column = parent.getColumn(colName);
                    if (column != null) continue;
                    throw new ValidationException((DBObject)con, DBArb.format((int)251, (Object)con.getName(), (Object)DBArb.format((int)252, (Object)this.getProvider().getExternalName(colName))));
                }
            }
            catch (SQLQueryException e) {
                throw new ValidationException((DBObject)con, DBArb.format((int)251, (Object)con.getName(), (Object)e.getMessage()));
            }
        } else {
            boolean isFK = "FKConstraint".equals(type);
            Column[] conCols = this.getConstraintColumns((ColumnConstraint)con);
            if (conCols.length == 0) {
                throw new ValidationException((DBObject)con, DBArb.getString((int)(isFK ? 245 : 235)));
            }
            if (this.areDuplicateColumns(conCols)) {
                throw new ValidationException((DBObject)con, DBArb.getString((int)231));
            }
            if (con instanceof UniqueConstraint) {
                if (type.equals("PKConstraint")) {
                    this.checkColumnDataType(conCols, 236);
                    this.markColumnsNotNull(conCols);
                } else {
                    this.checkColumnDataType(conCols, 239);
                }
                this.checkIsUniqueDefinition(con);
            } else if (isFK) {
                FKConstraint fk = (FKConstraint)con;
                DBObjectID refID = fk.getReferenceID();
                if (refID == null) {
                    throw new ValidationException((DBObject)con, DBArb.getString((int)244));
                }
                this.checkColumnDataType(conCols, 247);
                if (refID instanceof ReferenceID) {
                    ReferenceID nbfk = (ReferenceID)refID;
                    ReferenceID parID = (ReferenceID)nbfk.getParent();
                    this.getProvider().validateName("SCHEMA", parID.getSchemaName());
                    this.getProvider().validateName("TABLE", parID.getName());
                    this.getProvider().validateName("CONSTRAINT", nbfk.getName());
                    for (String colName : nbfk.getChildObjectNames()) {
                        this.getProvider().validateName("COLUMN", colName);
                    }
                } else {
                    this.checkColumnsMatch(fk);
                }
            }
        }
    }

    public boolean isCompatibleDataTypes(DataType fkColDataType, DataType refColDataType) {
        return this.getProvider().getDescriptor().isValidFKDataType(fkColDataType, refColDataType);
    }

    protected boolean isValidConstraintDatatype(String dataTypeName, DataTypeUsage dataTypeUsage) {
        return true;
    }

    private void checkColumnsMatch(FKConstraint fk) throws ValidationException {
        block8: {
            try {
                Column[] cols = fk.getColumns();
                DBObjectID id = fk.getReferenceID();
                UniqueConstraint refCon = null;
                try {
                    refCon = (UniqueConstraint)id.resolveID();
                }
                catch (DBException dbe) {
                    // empty catch block
                }
                if (refCon == null || cols == null) break block8;
                if (cols.length == refCon.getColumns().length) {
                    Column[] refCols = refCon.getColumns();
                    for (int i = 0; i < cols.length; ++i) {
                        Column refCol = refCols[i];
                        if (refCol == null || cols[i] == null) continue;
                        String refColName = refCol.getName();
                        DataType colDataType = null;
                        DataType refColDataType = null;
                        try {
                            colDataType = DataTypeHelper.getDataType((DataTypeUsage)cols[i].getDataTypeUsage());
                            refColDataType = DataTypeHelper.getDataType((DataTypeUsage)refCol.getDataTypeUsage());
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                        if (this.isCompatibleDataTypes(colDataType, refColDataType)) continue;
                        Object[] params = new Object[]{cols[i].getName(), colDataType.getName(), refColName, refColDataType.getName()};
                        throw new ValidationException((DBObject)fk, DBArb.format((int)249, (Object[])params));
                    }
                    break block8;
                }
                throw new ValidationException((DBObject)fk, DBArb.format((int)248, (Object)cols.length, (Object)refCon.getColumns().length));
            }
            catch (IllegalStateException x) {
                throw new ValidationException((DBObject)fk, x.getMessage());
            }
        }
    }

    private void markColumnsNotNull(Column[] cols) throws ValidationException {
        for (int i = 0; i < cols.length; ++i) {
            Column col = cols[i];
            if (col.isNotNull()) continue;
            col.setNotNull(true);
        }
    }

    private void checkColumnDataType(Column[] cols, int errorMessage) throws ValidationException {
        for (int i = 0; i < cols.length; ++i) {
            Column col = cols[i];
            if (col == null || col instanceof ViewColumn) continue;
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)col.getDataTypeUsage());
            }
            catch (DBException dbe) {
                // empty catch block
            }
            if (dataType == null) {
                throw new ValidationException((DBObject)col, DBArb.format((int)223, (Object)col.getName()));
            }
            if (this.isValidConstraintDatatype(dataType.getName(), col.getDataTypeUsage())) continue;
            throw new ValidationException((DBObject)col, DBArb.format((int)errorMessage, (Object)col.getName()));
        }
    }

    protected void checkIsUniqueDefinition(Constraint con) throws ValidationException {
        Column[] conColumns = ((UniqueConstraint)con).getColumns();
        Constraint[] constraints = con.getRelation().getConstraints();
        for (int j = 0; j < constraints.length; ++j) {
            if (!(constraints[j] instanceof UniqueConstraint) || constraints[j].equals((Object)con) || !this.areIdenticalColumnLists(conColumns, ((UniqueConstraint)constraints[j]).getColumns())) continue;
            throw new ValidationException((DBObject)con, DBArb.format((int)240, (Object[])new Object[]{this.getConstraintTypeDisplayName(con), con.getName(), this.getConstraintTypeDisplayName(constraints[j]), constraints[j].getName()}));
        }
    }

    private boolean areIdenticalColumnLists(Column[] thisConsColumns, Column[] otherConsColumns) {
        if (thisConsColumns.length != otherConsColumns.length) {
            return false;
        }
        for (int i = 0; i < thisConsColumns.length; ++i) {
            if (thisConsColumns[i].getName().equals(otherConsColumns[i].getName())) continue;
            return false;
        }
        return true;
    }

    protected String getConstraintTypeDisplayName(Constraint constraint) {
        return DBArb.getString((int)(constraint.getConstraintType().equals("PKConstraint") ? 234 : 238));
    }

    private boolean areDuplicateColumns(Column[] cols) {
        boolean result = false;
        block0: for (int i = 0; i < cols.length - 1 && !result; ++i) {
            if (null == cols[i]) continue;
            for (int j = i + 1; j < cols.length; ++j) {
                if (!cols[i].equals((Object)cols[j])) continue;
                result = true;
                continue block0;
            }
        }
        return result;
    }

    private boolean missingColumns(Column[] consCols, Column[] relationCols) {
        boolean missing = false;
        block0: for (int i = 0; i < consCols.length && !missing; ++i) {
            missing = true;
            for (int j = 0; j < relationCols.length; ++j) {
                if (!consCols[i].equals((Object)relationCols[j])) continue;
                missing = false;
                continue block0;
            }
        }
        return missing;
    }

    public static void validateOnePK(Constraint[] cons) throws ValidationException {
        boolean hasPK = false;
        for (int i = 0; i < cons.length; ++i) {
            String cType = cons[i].getConstraintType();
            if (!"PKConstraint".equals(cType)) continue;
            if (hasPK) {
                throw new ValidationException((DBObject)cons[i], DBArb.getString((int)233));
            }
            hasPK = true;
        }
    }

    private boolean existsInParent(Constraint constraint) {
        Constraint[] constraints = constraint.getRelation().getConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            if (!constraint.equals((Object)constraints[i])) continue;
            return true;
        }
        return false;
    }

    private Column[] getConstraintColumns(ColumnConstraint con) throws ValidationException {
        ArrayList<Column> columns = new ArrayList<Column>();
        Relation parent = con.getRelation();
        for (DBObjectID conID : con.getColumnIDs()) {
            Column c = (Column)parent.findOwnedObject(conID);
            if (c == null) {
                throw new ValidationException((DBObject)con, DBArb.getString((int)232));
            }
            columns.add(c);
        }
        return columns.toArray(new Column[columns.size()]);
    }
}

