/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.View;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnValidator
extends AbstractValidator<Column> {
    public ColumnValidator(DBObjectProvider prov) {
        super(prov);
    }

    protected boolean isViewColumn(Column column) {
        return column instanceof ViewColumn || column.getRelation() instanceof View;
    }

    @AbstractValidator.PropertyValidator(value={"dataTypeUsage"})
    public void validateDataTypeUsage(Column original, Column updated) throws ValidationException {
        if (!this.isViewColumn(updated)) {
            DataTypeUsage dtu = updated.getDataTypeUsage();
            if (original != null && ModelUtil.areDifferent((Object)original.getDataTypeUsage(), (Object)dtu) && !ColumnValidator.canChangeColumnDatatype(this.getProvider(), original)) {
                throw new ValidationException((DBObject)original, DBArb.format((int)229, (Object)ColumnValidator.formatRelationColumn(original, null)), DBArb.getString((int)228));
            }
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)dtu);
            }
            catch (DBException dbe) {
                // empty catch block
            }
            if (dataType == null) {
                throw new ValidationException((DBObject)updated, DBArb.format((int)223, (Object)ColumnValidator.formatRelationColumn(updated, null)), DBArb.getString((int)224));
            }
            dataType.validateUsage(dtu, (DBObject)updated);
        }
    }

    @AbstractValidator.PropertyValidator(value={"default"})
    public void validateDefaultValue(Column original, Column updated) throws ValidationException {
        if (!this.isViewColumn(updated)) {
            DataTypeUsage dtu = updated.getDataTypeUsage();
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)dtu);
            }
            catch (DBException dbe) {
                // empty catch block
            }
            if (dataType != null) {
                this.validateDefaultValue(updated, dataType);
            }
        }
    }

    protected void validateDefaultValue(Column column, DataType dataType) throws ValidationException {
        Object defaultValue = column.getDefault();
        if (defaultValue != null) {
            dataType.validateDefaultValue(defaultValue, column.getDataTypeUsage(), (DBObject)column);
        }
    }

    public static String formatRelationColumn(Column column, Relation rel) {
        StringBuffer format = new StringBuffer();
        if (column != null) {
            String parName;
            Relation par = column.getRelation();
            Relation relation = par = par == null ? rel : par;
            if (par != null && ModelUtil.hasLength((String)(parName = par.getName()))) {
                format.append(parName);
                format.append(".");
            }
            format.append(column.getName());
        }
        return format.toString();
    }

    @Override
    protected void validateNameInUse(Column object) throws NameInUseException {
        assert (object != null);
        assert (object instanceof Column);
        Column column = object;
        try {
            if (column.getRelation() != null) {
                ColumnValidator.validateUniqueNames((DBObject[])column.getRelation().getColumns());
            }
        }
        catch (ValidationException x) {
            throw new NameInUseException(x.getObject());
        }
    }

    public static boolean canChangeColumnDatatype(DBObjectProvider prov, Column col) {
        boolean canChange = true;
        try {
            for (DBObject usage : DBUtil.findUsagesIn((DBObject)col, (DBObject)col.getParent())) {
                if (usage instanceof FKConstraint) {
                    canChange = false;
                } else {
                    FKConstraint[] fkrefs;
                    if (!(usage instanceof PKConstraint) && !(usage instanceof UniqueConstraint)) continue;
                    if (usage.getID() instanceof TemporaryObjectID) {
                        usage = ((TemporaryObjectID)usage.getID()).resolveOriginalID();
                    }
                    if (null == (fkrefs = DBUtil.getReferences((Constraint)((Constraint)usage), (DBObjectProvider)prov)) || fkrefs.length <= 0) continue;
                    canChange = false;
                }
                break;
            }
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.SEVERE, "Unexpected exception", dbe);
            canChange = false;
        }
        return canChange;
    }
}

