/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.timesten;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.timesten.TimesTen7DDLGenerator;
import oracle.javatools.db.timesten.TimesTen7DatabaseImpl;
import oracle.javatools.db.timesten.TimesTenDatabase;
import oracle.javatools.db.timesten.TimesTenDatabaseDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimesTen7DatabaseDescriptor<T extends TimesTenDatabase>
extends TimesTenDatabaseDescriptor<T> {
    private static final Set V7_RESERVED_WORDS = new HashSet<String>(Arrays.asList("AGING", "ALL", "ANY", "AS", "BETWEEN", "BIGINT", "BINARY", "BINARY_DOUBLE_INFINITY", "BINARY_DOUBLE_NAN", "BINARY_FLOAT_INFINITY", "BINARY_FLOAT_NAN", "CASE", "CHAR", "CHARACTER", "COLUMN", "CONNECTION", "CONSTRAINT", "CROSS", "CURSOR", "CURRENT_SCHEMA", "CURRENT_USER", "DATASTORE_OWNER", "DATE", "DEC", "DECIMAL", "DEFAULT", "DESTROY", "DISTINCT", "DOUBLE", "FIRST", "FLOAT", "FOR", "FOREIGN", "FROM", "GROUP", "HAVING", "INNER", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "JOIN", "LEFT", "LIKE", "LONG", "MINUS", "NATIONAL", "NCHAR", "NO", "NULL", "NUMERIC", "NVARCHAR", "ON", "ORA_SYSDATE", "ORDER", "PRIMARY", "PROPAGATE", "PUBLIC", "READONLY", "REAL", "RETURN", "RIGHT", "ROWNUM", "ROWS", "SELF", "SELECT", "SESSION_USER", "SET", "SMALLINT", "SOME", "SYSDATE", "SYSTEM_USER", "TIME", "TINYINT", "TT_SYSDATE", "UNION", "UNIQUE", "UPDATE", "USER", "USING", "VARBINARY", "VARCHAR", "VARYING", "WHEN", "WHERE"));

    public TimesTen7DatabaseDescriptor() {
        this(TimesTen7DatabaseImpl.class);
    }

    public TimesTen7DatabaseDescriptor(Class<? extends T> clz) {
        super(clz);
    }

    @Override
    public void validateName(String type, String name) throws InvalidNameException {
        TimesTen7DatabaseDescriptor.validateIdentifier((String)name, (char)'\"', (int)30, (String)"_$#@", (boolean)true, (Set)V7_RESERVED_WORDS, (int)this.getCasePolicy());
    }

    public Collection<String> listPreferredDataTypeNames() {
        return Arrays.asList("VARCHAR2", "NUMBER", "DATE");
    }

    @Override
    public int getDatabaseVersion() {
        return 7;
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        return new TimesTen7DDLGenerator(pro);
    }
}

