/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sybase;

import java.sql.Connection;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.datatypes.BinaryDataType;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;
import oracle.javatools.db.sybase.AdaptiveServerDatabase;

public abstract class AdaptiveServerDatabaseImpl
extends JdbcDDLDatabase
implements AdaptiveServerDatabase {
    protected AdaptiveServerDatabaseImpl(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    public DataType getOrCreateDataType(String typeName) {
        return super.getOrCreateDataType(typeName.toUpperCase().trim());
    }

    public String normaliseDataTypeName(String dmdDataTypeName) {
        String typeName = dmdDataTypeName.trim().replaceAll("\\s", " ");
        String[] tokens = typeName.toUpperCase().split("\\b");
        if (tokens[1].equals("DOUBLE") && tokens.length > 3 && tokens[3].equals("PRECIS")) {
            typeName = "DOUBLE PRECISION";
        }
        return typeName;
    }

    protected boolean isUsernameCaseInsensitive() {
        return false;
    }

    public boolean catalogIsSchema() {
        return false;
    }

    static class Registerer
    extends DataTypeRegistry.Registerer {
        Registerer() {
        }

        public void registerDataTypes(DataTypeRegistry dtr) {
            NumericDataType BIT = new NumericDataType(65535, "BIT", NumericDataType.MIN_MAX_BIT);
            NumericDataType MONEY = new NumericDataType(65535, "MONEY", NumericDataType.MIN_MAX_MONEY);
            NumericDataType SMALLMONEY = new NumericDataType(65535, "SMALLMONEY", NumericDataType.MIN_MAX_SMALLMONEY);
            NumericDataType FLOAT = new NumericDataType(65535, "FLOAT", "FLOAT[(<precision>)]", 1L, 53L, null, false, null, new NumericDataType.MinMaxValue("2.22507385850721e-308", "1.79769313486231e+308", 2));
            NumericDataType REAL = new NumericDataType(65535, "REAL", new NumericDataType.MinMaxValue("1.175495e-38", "3.402823e+38", 2));
            NumericDataType DOUBLE_PRECISION = new NumericDataType(65535, "DOUBLE PRECISION", new NumericDataType.MinMaxValue("2.22507385850721e-308", "1.79769313486231e+308", 2));
            PredefinedDataType DATETIME = new PredefinedDataType(65535, "DATETIME");
            PredefinedDataType SMALLDATETIME = new PredefinedDataType(65535, "SMALLDATETIME");
            PredefinedDataType DATE = new PredefinedDataType(65535, "DATE");
            PredefinedDataType TIME = new PredefinedDataType(65535, "TIME");
            CharacterDataType TEXT = new CharacterDataType(65535, "TEXT", 1L, Integer.MAX_VALUE);
            BinaryDataType IMAGE = new BinaryDataType(65535, "IMAGE", 1L, Integer.MAX_VALUE);
            dtr.registerDataType((DataType)BIT, AdaptiveServerDatabaseImpl.class, JdbcDatabase.ANSI_SMALLINT);
            dtr.registerDataType((DataType)FLOAT, AdaptiveServerDatabaseImpl.class, JdbcDatabase.ANSI_FLOAT);
            dtr.registerDataType((DataType)REAL, AdaptiveServerDatabaseImpl.class, JdbcDatabase.ANSI_REAL);
            dtr.registerDataType((DataType)DOUBLE_PRECISION, AdaptiveServerDatabaseImpl.class, JdbcDatabase.ANSI_DOUBLE_PRECISION);
            dtr.registerDataType((DataType)MONEY, AdaptiveServerDatabaseImpl.class, JdbcDatabase.ANSI_DECIMAL);
            dtr.registerDataType((DataType)SMALLMONEY, AdaptiveServerDatabaseImpl.class, JdbcDatabase.ANSI_DECIMAL);
            dtr.registerDataType((DataType)DATETIME, AdaptiveServerDatabaseImpl.class, JdbcDatabase.ANSI_TIMESTAMP);
            dtr.registerDataType((DataType)SMALLDATETIME, AdaptiveServerDatabaseImpl.class, JdbcDatabase.ANSI_TIMESTAMP);
            dtr.registerDataType((DataType)DATE, AdaptiveServerDatabaseImpl.class, JdbcDatabase.ANSI_DATE);
            dtr.registerDataType((DataType)TIME, AdaptiveServerDatabaseImpl.class, JdbcDatabase.ANSI_TIME);
            dtr.registerDataType((DataType)TEXT, AdaptiveServerDatabaseImpl.class);
            dtr.registerDataType((DataType)IMAGE, AdaptiveServerDatabaseImpl.class);
        }
    }
}

