/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sybase;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.sybase.AdaptiveServerAnywhereDatabase;
import oracle.javatools.db.sybase.AdaptiveServerAnywhereDatabaseImpl;
import oracle.javatools.db.sybase.AdaptiveServerAnywhereDescriptor;
import oracle.javatools.db.sybase.AdaptiveServerDatabaseImpl;
import oracle.javatools.db.sybase.AdaptiveServerEnterprise15DatabaseImpl;
import oracle.javatools.db.sybase.AdaptiveServerEnterprise15Descriptor;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseDatabaseImpl;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseDescriptor;

public class AdaptiveServerDatabaseFactory
extends BaseDatabaseCreator {
    private DatabaseDescriptor m_anywhereDesc;
    private Map<String, DatabaseDescriptor> m_enterpriseDescs = new HashMap<String, DatabaseDescriptor>();

    public AdaptiveServerDatabaseFactory() {
        this.registerProviderClass(AdaptiveServerDatabaseImpl.class, null, (DataTypeRegistry.Registerer)new AdaptiveServerDatabaseImpl.Registerer());
        this.registerProviderClass(AdaptiveServerEnterpriseDatabaseImpl.class, 405, (DataTypeRegistry.Registerer)new AdaptiveServerEnterpriseDatabaseImpl.Registerer());
        this.registerProviderClass(AdaptiveServerEnterprise15DatabaseImpl.class, DBArb.getString((int)428), (DataTypeRegistry.Registerer)new AdaptiveServerEnterprise15DatabaseImpl.Registerer());
    }

    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        if (this.isAnywhere(conn)) {
            return new AdaptiveServerAnywhereDatabaseImpl(connStore, connName, conn);
        }
        int t = this.getEnterpriseVersion(conn);
        switch (t) {
            case 0: {
                return null;
            }
            case 15: {
                return new AdaptiveServerEnterprise15DatabaseImpl(connStore, connName, conn);
            }
        }
        return new AdaptiveServerEnterpriseDatabaseImpl(connStore, connName, conn);
    }

    private boolean isAnywhere(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String driverName = dmd.getDriverName();
                String dbName = dmd.getDatabaseProductName();
                if (driverName.indexOf("Sybase") > -1 && dbName.indexOf("Anywhere") > -1) {
                    return true;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    private int getEnterpriseVersion(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String driverName = dmd.getDriverName();
                String dbName = dmd.getDatabaseProductName();
                if (driverName.indexOf("Sybase") > -1 || dbName.indexOf("Adaptive Server Enterprise") > -1) {
                    String v = dmd.getDatabaseProductVersion();
                    if (v.startsWith("Adaptive Server Enterprise/15")) {
                        return 15;
                    }
                    return 12;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return 0;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        if (AdaptiveServerAnywhereDatabase.class.isAssignableFrom(providerClass)) {
            if (this.m_anywhereDesc == null) {
                this.m_anywhereDesc = new AdaptiveServerAnywhereDescriptor(providerClass);
            }
            return this.m_anywhereDesc;
        }
        AdaptiveServerEnterpriseDescriptor descriptor = null;
        if (AdaptiveServerEnterprise15DatabaseImpl.class.isAssignableFrom(providerClass)) {
            descriptor = this.m_enterpriseDescs.get(providerClass.getName());
            if (descriptor == null) {
                descriptor = new AdaptiveServerEnterprise15Descriptor(providerClass);
                this.m_enterpriseDescs.put(providerClass.getName(), descriptor);
            }
            return descriptor;
        }
        if (AdaptiveServerEnterpriseDatabaseImpl.class.isAssignableFrom(providerClass)) {
            descriptor = this.m_enterpriseDescs.get(providerClass.getName());
            if (descriptor == null) {
                descriptor = new AdaptiveServerEnterpriseDescriptor(providerClass);
                this.m_enterpriseDescs.put(providerClass.getName(), descriptor);
            }
            return descriptor;
        }
        return null;
    }
}

