/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.jdbc.JdbcTableBuilder;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSearchException;
import oracle.javatools.util.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteTableBuilder<T extends Table>
extends JdbcTableBuilder<T> {
    public SQLiteTableBuilder(JdbcDatabase db, String catalog) {
        super(db, catalog);
    }

    @Override
    protected DataTypeUsage getDataTypeUsage(Connection conn, Relation rel, Column column, DataType dataType, Long size, Long scale, String jdbcTypeName) {
        DataTypeUsage dtu;
        Schema schema = null;
        if (rel != null) {
            schema = rel.getSchema();
        }
        if ((dtu = DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)this.getProvider(), (Schema)schema, (String)jdbcTypeName)) != null) {
            boolean mismatch = true;
            try {
                DataType datatypeFromHelper = (DataType)dtu.getDataTypeID().resolveID();
                if (datatypeFromHelper == dataType) {
                    mismatch = false;
                }
            }
            catch (DBException e) {
                // empty catch block
            }
            if (mismatch) {
                dtu = dataType.createDefaultUsage();
            }
        }
        return dtu;
    }

    @Override
    protected String makePKName(String pkSchemaName, String pkTableName) {
        final Holder sqlH = new Holder();
        final QueryWrapper wrap = new QueryWrapper((Database)this.getDatabase(), "SELECT SQL FROM SQLITE_MASTER WHERE TYPE='table' AND UPPER(TBL_NAME) = UPPER(?)", new Object[]{pkTableName});
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        sqlH.set((Object)rs.getString(1));
                    }
                }
                catch (SQLException e) {
                    wrap.throwDBException(e);
                }
            }
        };
        try {
            wrap.executeQuery(r);
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.WARNING, "", dbe);
        }
        try {
            PlSqlSearch s = new PlSqlSearch("constraint <pkName ?> primary key");
            if (s.isWithin((String)sqlH.get())) {
                return s.getNamedMatch("pkName");
            }
        }
        catch (PlSqlSearchException e) {
            // empty catch block
        }
        return pkTableName + "_PK";
    }
}

