/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.BinaryDataType;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DateDataType;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.datatypes.TimeStampTZDataType;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;
import oracle.javatools.db.ora.OracleNumberDataType;
import oracle.javatools.db.sqlite.SQLiteDatabase;
import oracle.javatools.db.sqlite.SQLiteTableBuilder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteDatabaseImpl
extends JdbcDDLDatabase
implements SQLiteDatabase {
    private static final DataTypeAttribute fractionalPrecision = new DataTypeAttribute("scale", 161, 0L, Long.valueOf(9L), Long.valueOf(6L), false);
    private static final String SQLITE_BLOB = "BLOB";
    private static final String SQLITE_BFILE = "BFILE";
    private static final String SQLITE_BINARY_DOUBLE = "BINARY_DOUBLE";
    private static final String SQLITE_BINARY_FLOAT = "BINARY_FLOAT";
    private static final String SQLITE_CHAR = "CHAR";
    private static final String SQLITE_CHAR_VARYING = "CHAR VARYING";
    private static final String SQLITE_CHARACTER = "CHARACTER";
    private static final String SQLITE_CHARACTER_VARYING = "CHARACTER VARYING";
    private static final String SQLITE_CLOB = "CLOB";
    private static final String SQLITE_DATE = "DATE";
    private static final String SQLITE_DEC = "DEC";
    private static final String SQLITE_DECIMAL = "DECIMAL";
    private static final String SQLITE_DOUBLE_PRECISION = "DOUBLE PRECISION";
    private static final String SQLITE_FLOAT = "FLOAT";
    private static final String SQLITE_INT = "INT";
    private static final String SQLITE_INTEGER = "INTEGER";
    private static final String SQLITE_LONG = "LONG";
    private static final String SQLITE_LONG_RAW = "LONG RAW";
    private static final String SQLITE_LONG_VARCHAR = "LONG VARCHAR";
    private static final String SQLITE_NATIONAL_CHAR = "NATIONAL CHAR";
    private static final String SQLITE_NATIONAL_CHAR_VARYING = "NATIONAL CHAR VARYING";
    private static final String SQLITE_NATIONAL_CHARACTER = "NATIONAL CHARACTER";
    private static final String SQLITE_NATIONAL_CHARACTER_VARYING = "NATIONAL CHARACTER VARYING";
    private static final String SQLITE_NCHAR = "NCHAR";
    private static final String SQLITE_NCHAR_VARYING = "NCHAR VARYING";
    private static final String SQLITE_NCLOB = "NCLOB";
    private static final String SQLITE_NUMBER = "NUMBER";
    private static final String SQLITE_NUMERIC = "NUMERIC";
    private static final String SQLITE_NVARCHAR2 = "NVARCHAR2";
    private static final String SQLITE_RAW = "RAW";
    private static final String SQLITE_REAL = "REAL";
    private static final String SQLITE_ROWID = "ROWID";
    private static final String SQLITE_SMALLINT = "SMALLINT";
    private static final String SQLITE_TIMESTAMP = "TIMESTAMP";
    private static final String SQLITE_UROWID = "UROWID";
    private static final String SQLITE_VARCHAR = "VARCHAR";
    private static final String SQLITE_VARCHAR2 = "VARCHAR2";
    private String m_defaultSchemaName;

    public SQLiteDatabaseImpl(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    @Override
    protected String getDefaultSchemaName() {
        if (this.m_defaultSchemaName == null) {
            String defaultSchemaName = null;
            Connection c = this.getConnection();
            try {
                String url;
                if (c != null && c.getMetaData() != null && (url = c.getMetaData().getURL()) != null) {
                    String[] bits = url.split("[\\\\/:]");
                    defaultSchemaName = bits[bits.length - 1];
                    if (defaultSchemaName.contains(".")) {
                        defaultSchemaName = defaultSchemaName.substring(0, defaultSchemaName.indexOf("."));
                    }
                    defaultSchemaName = defaultSchemaName.toUpperCase();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.m_defaultSchemaName = defaultSchemaName == null || defaultSchemaName.length() == 0 ? "SQLite".toUpperCase() : defaultSchemaName;
        }
        return this.m_defaultSchemaName;
    }

    @Override
    protected String getCatalog() {
        return this.getDefaultSchemaName();
    }

    @Override
    public String getUserName() throws DBException {
        return this.getDefaultSchemaName();
    }

    @Override
    protected void registerBuilders(Collection<String> types, String catalog) {
        this.registerBuilder("TABLE", (DBObjectBuilder)new SQLiteTableBuilder(this, catalog));
    }

    @Override
    public String normaliseDataTypeName(String name) {
        int idx = name.indexOf("(");
        if (idx > 0) {
            return name.substring(0, idx);
        }
        return name;
    }

    @Override
    protected boolean tableMatches(String ref, String rsName) {
        return super.tableMatches(this.getUpperName(ref), this.getUpperName(rsName));
    }

    protected boolean isRequestedObject(SystemObject object, String type, Schema schema, String name) {
        return ModelUtil.areEqual((Object)object.getType(), (Object)type) && ModelUtil.areEqual((Object)this.getUpperName(object.getName()), (Object)this.getUpperName(name));
    }

    private String getUpperName(String name) {
        if (name == null || name.startsWith("\"")) {
            return name;
        }
        return name.toUpperCase();
    }

    static class Registerer
    extends DataTypeRegistry.Registerer {
        Registerer() {
        }

        public void registerDataTypes(DataTypeRegistry dtr) {
            NumericDataType.MinMaxValue MIN_MAX_FLOAT = new NumericDataType.MinMaxValue("1.0e-130", "9.9999999999999999999999999999999999999e+125", 2);
            NumericDataType.MinMaxValue MIN_MAX_INT = new NumericDataType.MinMaxValue("-99999999999999999999999999999999999999", "99999999999999999999999999999999999999", 0);
            OracleNumberDataType DATATYPE_NUMBER = new OracleNumberDataType(1);
            NumericDataType DATATYPE_FLOAT = new NumericDataType(1, SQLiteDatabaseImpl.SQLITE_FLOAT, "FLOAT[(<precision>)]", 1L, 126L, new Long(126L), false, null, MIN_MAX_FLOAT);
            CharacterDataType DATATYPE_VARCHAR2 = new CharacterDataType(1, SQLiteDatabaseImpl.SQLITE_VARCHAR2, "VARCHAR2(<size>)", 1L, 4000L, 20L, true, null);
            CharacterDataType DATATYPE_CHAR = new CharacterDataType(1, SQLiteDatabaseImpl.SQLITE_CHAR, "CHAR[(<size>)]", 1L, 2000L, 1L, false, null);
            CharacterDataType DATATYPE_LONG = new CharacterDataType(1, SQLiteDatabaseImpl.SQLITE_LONG, 1L, Integer.MAX_VALUE);
            BinaryDataType DATATYPE_RAW = new BinaryDataType(1, SQLiteDatabaseImpl.SQLITE_RAW, "RAW(<size>)", 1L, 2000L, 20L, true, null);
            BinaryDataType DATATYPE_LONG_RAW = new BinaryDataType(1, SQLiteDatabaseImpl.SQLITE_LONG_RAW, 1L, Integer.MAX_VALUE);
            PredefinedDataType DATATYPE_ROWID = new PredefinedDataType(1, SQLiteDatabaseImpl.SQLITE_ROWID);
            DateDataType DATATYPE_DATE = new DateDataType(1, SQLiteDatabaseImpl.SQLITE_DATE);
            dtr.registerDataType((DataType)DATATYPE_CHAR, SQLiteDatabaseImpl.class, JdbcDatabase.ANSI_CHARACTER);
            dtr.registerDataType((DataType)DATATYPE_DATE, SQLiteDatabaseImpl.class, JdbcDatabase.ANSI_DATE);
            dtr.registerDataType((DataType)DATATYPE_FLOAT, SQLiteDatabaseImpl.class, JdbcDatabase.ANSI_FLOAT);
            dtr.registerDataType((DataType)DATATYPE_LONG, SQLiteDatabaseImpl.class, JdbcDatabase.ANSI_CHARACTER);
            dtr.registerDataType((DataType)DATATYPE_LONG_RAW, SQLiteDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_NUMBER, SQLiteDatabaseImpl.class, JdbcDatabase.ANSI_NUMERIC);
            dtr.registerDataType((DataType)DATATYPE_RAW, SQLiteDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_ROWID, SQLiteDatabaseImpl.class, JdbcDatabase.ANSI_REAL);
            dtr.registerDataType((DataType)DATATYPE_VARCHAR2, SQLiteDatabaseImpl.class, JdbcDatabase.ANSI_CHARACTER_VARYING);
            dtr.registerSynonym(SQLiteDatabaseImpl.SQLITE_CHARACTER, (DataType)DATATYPE_CHAR, SQLiteDatabaseImpl.class);
            dtr.registerSynonym(SQLiteDatabaseImpl.SQLITE_CHAR_VARYING, (DataType)DATATYPE_VARCHAR2, SQLiteDatabaseImpl.class);
            dtr.registerSynonym(SQLiteDatabaseImpl.SQLITE_CHARACTER_VARYING, (DataType)DATATYPE_VARCHAR2, SQLiteDatabaseImpl.class);
            dtr.registerSynonym(SQLiteDatabaseImpl.SQLITE_LONG_VARCHAR, (DataType)DATATYPE_LONG, SQLiteDatabaseImpl.class);
            dtr.registerSynonym(SQLiteDatabaseImpl.SQLITE_VARCHAR, (DataType)DATATYPE_VARCHAR2, SQLiteDatabaseImpl.class);
            dtr.registerSynonym(SQLiteDatabaseImpl.SQLITE_DEC, (DataType)DATATYPE_NUMBER, SQLiteDatabaseImpl.class);
            dtr.registerSynonym(SQLiteDatabaseImpl.SQLITE_DECIMAL, (DataType)DATATYPE_NUMBER, SQLiteDatabaseImpl.class);
            dtr.registerSynonym(SQLiteDatabaseImpl.SQLITE_NUMERIC, (DataType)DATATYPE_NUMBER, SQLiteDatabaseImpl.class);
            NumericDataType SYNONYM_INT = new NumericDataType(1, SQLiteDatabaseImpl.SQLITE_INT, MIN_MAX_INT);
            NumericDataType SYNONYM_INTEGER = new NumericDataType(1, SQLiteDatabaseImpl.SQLITE_INTEGER, MIN_MAX_INT);
            NumericDataType SYNONYM_SMALLINT = new NumericDataType(1, SQLiteDatabaseImpl.SQLITE_SMALLINT, MIN_MAX_INT);
            NumericDataType SYNONYM_REAL = new NumericDataType(1, SQLiteDatabaseImpl.SQLITE_REAL, MIN_MAX_FLOAT);
            NumericDataType SYNONYM_DOUBLE_PRECISION = new NumericDataType(1, SQLiteDatabaseImpl.SQLITE_DOUBLE_PRECISION, MIN_MAX_FLOAT);
            dtr.registerSynonym((DataType)SYNONYM_INT, (DataType)DATATYPE_NUMBER, SQLiteDatabaseImpl.class);
            dtr.registerSynonym((DataType)SYNONYM_INTEGER, (DataType)DATATYPE_NUMBER, SQLiteDatabaseImpl.class);
            dtr.registerSynonym((DataType)SYNONYM_SMALLINT, (DataType)DATATYPE_NUMBER, SQLiteDatabaseImpl.class);
            dtr.registerSynonym((DataType)SYNONYM_REAL, (DataType)DATATYPE_FLOAT, SQLiteDatabaseImpl.class);
            dtr.registerSynonym((DataType)SYNONYM_DOUBLE_PRECISION, (DataType)DATATYPE_FLOAT, SQLiteDatabaseImpl.class);
            BinaryDataType DATATYPE_BLOB = new BinaryDataType(1, SQLiteDatabaseImpl.SQLITE_BLOB, 1L, 0x100000000L);
            BinaryDataType DATATYPE_BFILE = new BinaryDataType(1, SQLiteDatabaseImpl.SQLITE_BFILE, 1L, 0x100000000L);
            CharacterDataType DATATYPE_NCHAR = new CharacterDataType(1, SQLiteDatabaseImpl.SQLITE_NCHAR, "NCHAR[(<size>)]", 1L, 2000L, 1L, false, null);
            CharacterDataType DATATYPE_CLOB = new CharacterDataType(1, SQLiteDatabaseImpl.SQLITE_CLOB, 1L, 0x100000000L);
            CharacterDataType DATATYPE_NCLOB = new CharacterDataType(1, SQLiteDatabaseImpl.SQLITE_NCLOB, 1L, 0x100000000L);
            CharacterDataType DATATYPE_NVARCHAR2 = new CharacterDataType(1, SQLiteDatabaseImpl.SQLITE_NVARCHAR2, "NVARCHAR2(<size>)", 1L, 4000L, 20L, true, null);
            dtr.registerDataType((DataType)DATATYPE_BFILE, SQLiteDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_BLOB, SQLiteDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_CLOB, SQLiteDatabaseImpl.class, JdbcDatabase.ANSI_CHARACTER);
            dtr.registerDataType((DataType)DATATYPE_NCHAR, SQLiteDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_NCLOB, SQLiteDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_NVARCHAR2, SQLiteDatabaseImpl.class);
            dtr.registerSynonym(SQLiteDatabaseImpl.SQLITE_NATIONAL_CHAR, (DataType)DATATYPE_NCHAR, SQLiteDatabaseImpl.class);
            dtr.registerSynonym(SQLiteDatabaseImpl.SQLITE_NATIONAL_CHAR_VARYING, (DataType)DATATYPE_NVARCHAR2, SQLiteDatabaseImpl.class);
            dtr.registerSynonym(SQLiteDatabaseImpl.SQLITE_NATIONAL_CHARACTER, (DataType)DATATYPE_NCHAR, SQLiteDatabaseImpl.class);
            dtr.registerSynonym(SQLiteDatabaseImpl.SQLITE_NATIONAL_CHARACTER_VARYING, (DataType)DATATYPE_NVARCHAR2, SQLiteDatabaseImpl.class);
            dtr.registerSynonym(SQLiteDatabaseImpl.SQLITE_NCHAR_VARYING, (DataType)DATATYPE_NVARCHAR2, SQLiteDatabaseImpl.class);
            dtr.registerDataType((DataType)new PredefinedDataType(1, SQLiteDatabaseImpl.SQLITE_UROWID, "UROWID[(<size>)]", 1L, 4000L, 4000L, false, null), SQLiteDatabaseImpl.class, JdbcDatabase.ANSI_SMALLINT);
            TimeStampTZDataType DATATYPE_TIMESTAMP = new TimeStampTZDataType(1, SQLiteDatabaseImpl.SQLITE_TIMESTAMP, "TIMESTAMP[(<scale>)]", new DataTypeAttribute[]{fractionalPrecision});
            dtr.registerDataType((DataType)DATATYPE_TIMESTAMP, SQLiteDatabaseImpl.class);
            dtr.registerDataType((DataType)new NumericDataType(1, SQLiteDatabaseImpl.SQLITE_BINARY_DOUBLE, new NumericDataType.MinMaxValue("2.3e-308", "1.79e+308", 2)), SQLiteDatabaseImpl.class);
            dtr.registerDataType((DataType)new NumericDataType(1, SQLiteDatabaseImpl.SQLITE_BINARY_FLOAT, new NumericDataType.MinMaxValue("1.2e-38", "3.4e+38", 2)), SQLiteDatabaseImpl.class);
        }
    }
}

