/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.sqlite.SQLiteDDLGenerator;
import oracle.javatools.db.sqlite.SQLiteDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteDatabaseDescriptor<T extends SQLiteDatabase>
extends JdbcDatabaseDescriptor<T> {
    public static final char QUOTE_IDENTIFIER = '\"';
    public static final int MAX_NAME_LENGTH = 1000;
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ADD", "ALL", "ALTER", "AND", "AS", "AUTOINCREMENT", "BETWEEN", "CASE", "CHECK", "COLLATE", "COMMIT", "CONSTRAINT", "CREATE", "CROSS", "DEFAULT", "DEFERRABLE", "DELETE", "DISTINCT", "DROP", "ELSE", "ESCAPE", "EXCEPT", "EXISTS", "FOREIGN", "FROM", "FULL", "GROUP", "HAVING", "IN", "INDEX", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "LEFT", "LIMIT", "NATURAL", "NOT", "NOTNULL", "NULL", "ON", "OR", "ORDER", "OUTER", "PRIMARY", "REFERENCES", "RIGHT", "ROLLBACK", "SELECT", "SET", "TABLE", "THEN", "TO", "TRANSACTION", "UNION", "UNIQUE", "UPDATE", "USING", "VALUES", "WHEN", "WHERE", "_ROWID_", "MAIN", "OID", "ROWID", "SQLITE_MASTER", "SQLITE_SEQUENCE", "SQLITE_TEMP_MASTER", "TEMP"));
    private static final Set NON_RESERVED_KEYWORDS = new HashSet<String>(Arrays.asList("ABORT", "AFTER", "ANALYZE", "ASC", "ATTACH", "BEFORE", "BEGIN", "BY", "CASCADE", "CAST", "COLUMN", "CONFLICT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DATABASE", "DEFERRED", "DESC", "DETACH", "EACH", "END", "EXCLUSIVE", "EXPLAIN", "FAIL", "FOR", "GLOB", "IF", "IGNORE", "IMMEDIATE", "INDEXED", "INITIALLY", "INSTEAD", "KEY", "LIKE", "MATCH", "OF", "OFFSET", "PLAN", "PRAGMA", "QUERY", "RAISE", "REGEXP", "REINDEX", "RELEASE", "RENAME", "REPLACE", "RESTRICT", "ROW", "SAVEPOINT", "TEMP", "TEMPORARY", "TRIGGER", "VACUUM", "VIEW", "VIRTUAL"));
    private static final Set KEYWORDS = new HashSet();

    public SQLiteDatabaseDescriptor(Class<? extends T> clz) {
        super(clz);
    }

    @Override
    public String getDatabaseType() {
        return "SQLite";
    }

    @Override
    public int getDatabaseVersion() {
        return 30620;
    }

    @Override
    public int getCasePolicy() {
        return 0;
    }

    @Override
    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    @Override
    public int getMaxNameLength(String type) {
        return 1000;
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        return new SQLiteDDLGenerator(pro);
    }

    @Override
    public void validateName(String type, String name) throws InvalidNameException {
        SQLiteDatabaseDescriptor.validateIdentifier((String)name, (char)'\"', (int)1000, (String)"_$@", (boolean)false, (Set)RESERVED_WORDS, (int)this.getCasePolicy());
        char firstChar = name.charAt(0);
        if (firstChar != '\"' && !Character.isLetter(firstChar) && firstChar != '_' && firstChar != '@') {
            throw new InvalidNameException(null, DBArb.getString((int)9));
        }
    }

    static {
        KEYWORDS.addAll(NON_RESERVED_KEYWORDS);
        KEYWORDS.addAll(RESERVED_WORDS);
    }
}

